/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kew.notes;

import java.io.Serializable;
import java.sql.Timestamp;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Map;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import javax.persistence.Transient;
import javax.persistence.Version;
import javax.xml.bind.annotation.XmlTransient;
import org.eclipse.persistence.internal.descriptors.PersistenceEntity;
import org.eclipse.persistence.internal.descriptors.PersistenceObject;
import org.eclipse.persistence.internal.identitymaps.CacheKey;
import org.eclipse.persistence.internal.jpa.EntityManagerImpl;
import org.eclipse.persistence.internal.jpa.rs.metadata.model.ItemLinks;
import org.eclipse.persistence.internal.jpa.rs.metadata.model.Link;
import org.eclipse.persistence.internal.weaving.PersistenceWeaved;
import org.eclipse.persistence.internal.weaving.PersistenceWeavedFetchGroups;
import org.eclipse.persistence.internal.weaving.PersistenceWeavedRest;
import org.eclipse.persistence.queries.FetchGroup;
import org.eclipse.persistence.queries.FetchGroupTracker;
import org.eclipse.persistence.sessions.Session;
import org.joda.time.DateTime;
import org.kuali.rice.core.api.util.RiceConstants;
import org.kuali.rice.kew.api.note.Note;
import org.kuali.rice.kew.api.note.NoteContract;
import org.kuali.rice.kew.notes.Attachment;
import org.kuali.rice.krad.data.jpa.PortableSequenceGenerator;

@Entity(name="org.kuali.rice.kew.notes.Note")
@Table(name="KREW_DOC_NTE_T")
@NamedQueries(value={@NamedQuery(name="KewNote.FindNoteByDocumentId", query="select n from org.kuali.rice.kew.notes.Note as n where n.documentId = :documentId order by n.noteId")})
public class Note
implements Serializable,
NoteContract,
Cloneable,
PersistenceWeaved,
PersistenceEntity,
PersistenceObject,
FetchGroupTracker,
PersistenceWeavedFetchGroups,
PersistenceWeavedRest {
    private static final long serialVersionUID = -6136544551121011531L;
    @Id
    @GeneratedValue(generator="KREW_DOC_NTE_S")
    @PortableSequenceGenerator(name="KREW_DOC_NTE_S")
    @Column(name="DOC_NTE_ID")
    private String noteId;
    @Column(name="DOC_HDR_ID")
    private String documentId;
    @Column(name="AUTH_PRNCPL_ID")
    private String noteAuthorWorkflowId;
    @Column(name="CRT_DT")
    private Timestamp noteCreateDate;
    @Column(name="TXT")
    private String noteText;
    @Version
    @Column(name="VER_NBR")
    private Integer lockVerNbr;
    @OneToMany(fetch=FetchType.EAGER, cascade={CascadeType.ALL}, mappedBy="note")
    private List<Attachment> attachments = new ArrayList<Attachment>();
    @Transient
    private String noteAuthorEmailAddress;
    @Transient
    private String noteAuthorNetworkId;
    @Transient
    private String noteAuthorFullName;
    @Transient
    private Long noteCreateLongDate;
    @Transient
    private Boolean authorizedToEdit;
    @Transient
    private Boolean editingNote;
    protected transient Object _persistence_primaryKey;
    protected transient CacheKey _persistence_cacheKey;
    @Transient
    @XmlTransient
    protected FetchGroup _persistence_fetchGroup;
    protected transient boolean _persistence_shouldRefreshFetchGroup;
    protected transient Session _persistence_session;
    protected transient List _persistence_relationshipInfo;
    protected transient Link _persistence_href;
    protected transient ItemLinks _persistence_links;

    public Integer getLockVerNbr() {
        return this._persistence_get_lockVerNbr();
    }

    public void setLockVerNbr(Integer lockVerNbr) {
        this._persistence_set_lockVerNbr(lockVerNbr);
    }

    public String getNoteAuthorWorkflowId() {
        return this._persistence_get_noteAuthorWorkflowId();
    }

    public void setNoteAuthorWorkflowId(String noteAuthorWorkflowId) {
        this._persistence_set_noteAuthorWorkflowId(noteAuthorWorkflowId);
    }

    public Timestamp getNoteCreateDate() {
        return this._persistence_get_noteCreateDate();
    }

    public void setNoteCreateDate(Timestamp noteCreateDate) {
        this._persistence_set_noteCreateDate(noteCreateDate);
    }

    public String getNoteId() {
        return this._persistence_get_noteId();
    }

    public void setNoteId(String noteId) {
        this._persistence_set_noteId(noteId);
    }

    public String getNoteText() {
        return this._persistence_get_noteText();
    }

    public void setNoteText(String noteText) {
        this._persistence_set_noteText(noteText);
    }

    public String getDocumentId() {
        return this._persistence_get_documentId();
    }

    public void setDocumentId(String documentId) {
        this._persistence_set_documentId(documentId);
    }

    public String getNoteAuthorEmailAddress() {
        return this.noteAuthorEmailAddress;
    }

    public void setNoteAuthorEmailAddress(String noteAuthorEmailAddress) {
        this.noteAuthorEmailAddress = noteAuthorEmailAddress;
    }

    public String getNoteAuthorFullName() {
        return this.noteAuthorFullName;
    }

    public void setNoteAuthorFullName(String noteAuthorFullName) {
        this.noteAuthorFullName = noteAuthorFullName;
    }

    public String getNoteAuthorNetworkId() {
        return this.noteAuthorNetworkId;
    }

    public void setNoteAuthorNetworkId(String noteAuthorNetworkId) {
        this.noteAuthorNetworkId = noteAuthorNetworkId;
    }

    public Long getNoteCreateLongDate() {
        return this.noteCreateLongDate;
    }

    public void setNoteCreateLongDate(Long noteCreateLongDate) {
        this.noteCreateLongDate = noteCreateLongDate;
    }

    public Boolean getAuthorizedToEdit() {
        return this.authorizedToEdit;
    }

    public void setAuthorizedToEdit(Boolean authorizedToEdit) {
        this.authorizedToEdit = authorizedToEdit;
    }

    public Boolean getEditingNote() {
        return this.editingNote;
    }

    public void setEditingNote(Boolean editingNote) {
        this.editingNote = editingNote;
    }

    public String getFormattedCreateDateTime() {
        long time = this.getNoteCreateDate().getTime();
        Calendar calendar = Calendar.getInstance();
        calendar.setTimeInMillis(time);
        Date date = calendar.getTime();
        SimpleDateFormat dateFormat = new SimpleDateFormat("MM/dd/yyyy hh:mm a");
        return dateFormat.format(date);
    }

    public String getFormattedCreateDate() {
        long time = this.getNoteCreateDate().getTime();
        Calendar calendar = Calendar.getInstance();
        calendar.setTimeInMillis(time);
        Date date = calendar.getTime();
        DateFormat dateFormat = RiceConstants.getDefaultDateFormat();
        return dateFormat.format(date);
    }

    public String getFormattedCreateTime() {
        long time = this.getNoteCreateDate().getTime();
        Calendar calendar = Calendar.getInstance();
        calendar.setTimeInMillis(time);
        Date date = calendar.getTime();
        DateFormat dateFormat = RiceConstants.getDefaultTimeFormat();
        return dateFormat.format(date);
    }

    public List<Attachment> getAttachments() {
        return this._persistence_get_attachments();
    }

    public void setAttachments(List<Attachment> attachments) {
        this._persistence_set_attachments(attachments);
    }

    public String getId() {
        if (this.getNoteId() == null) {
            return null;
        }
        return this.getNoteId().toString();
    }

    public Long getVersionNumber() {
        if (this.getLockVerNbr() == null) {
            return null;
        }
        return new Long(this.getLockVerNbr().longValue());
    }

    public String getAuthorPrincipalId() {
        return this.getNoteAuthorWorkflowId();
    }

    public DateTime getCreateDate() {
        if (this.getNoteCreateDate() == null) {
            return null;
        }
        return new DateTime(this.getNoteCreateDate().getTime());
    }

    public String getText() {
        return this.getNoteText();
    }

    public Note deepCopy(Map<Object, Object> visited) {
        if (visited.containsKey(this)) {
            return (Note)visited.get(this);
        }
        Note copy = new Note();
        visited.put(this, copy);
        copy._persistence_set_noteId(this._persistence_get_noteId());
        copy._persistence_set_documentId(this._persistence_get_documentId());
        copy._persistence_set_noteAuthorWorkflowId(this._persistence_get_noteAuthorWorkflowId());
        if (this._persistence_get_noteCreateDate() != null) {
            copy._persistence_set_noteCreateDate(new Timestamp(this._persistence_get_noteCreateDate().getTime()));
        }
        copy._persistence_set_noteText(this._persistence_get_noteText());
        copy._persistence_set_lockVerNbr(this._persistence_get_lockVerNbr());
        copy.noteAuthorEmailAddress = this.noteAuthorEmailAddress;
        copy.noteAuthorNetworkId = this.noteAuthorNetworkId;
        copy.noteAuthorFullName = this.noteAuthorFullName;
        copy.noteCreateLongDate = this.noteCreateLongDate;
        copy.authorizedToEdit = this.authorizedToEdit;
        copy.editingNote = this.editingNote;
        if (this._persistence_get_attachments() != null) {
            ArrayList<Attachment> copies = new ArrayList<Attachment>();
            for (Attachment attachment : this._persistence_get_attachments()) {
                copies.add(attachment.deepCopy(visited));
            }
            copy._persistence_set_attachments(copies);
        }
        return copy;
    }

    public static org.kuali.rice.kew.api.note.Note to(Note note) {
        if (note == null) {
            return null;
        }
        return Note.Builder.create((NoteContract)note).build();
    }

    public static Note from(org.kuali.rice.kew.api.note.Note note) {
        if (note == null) {
            return null;
        }
        Note noteBo = new Note();
        if (note.getId() != null) {
            noteBo.setNoteId(note.getId());
        }
        noteBo.setDocumentId(note.getDocumentId());
        noteBo.setNoteAuthorWorkflowId(note.getAuthorPrincipalId());
        if (note.getCreateDate() != null) {
            noteBo.setNoteCreateDate(new Timestamp(note.getCreateDate().getMillis()));
        }
        noteBo.setNoteText(note.getText());
        if (note.getVersionNumber() != null) {
            noteBo.setLockVerNbr(note.getVersionNumber().intValue());
        }
        return noteBo;
    }

    public Object _persistence_post_clone() {
        this._persistence_fetchGroup = null;
        this._persistence_session = null;
        this._persistence_primaryKey = null;
        return this;
    }

    public Object _persistence_shallow_clone() {
        return super.clone();
    }

    public Object _persistence_getId() {
        return this._persistence_primaryKey;
    }

    public void _persistence_setId(Object object) {
        this._persistence_primaryKey = object;
    }

    public CacheKey _persistence_getCacheKey() {
        return this._persistence_cacheKey;
    }

    public void _persistence_setCacheKey(CacheKey cacheKey) {
        this._persistence_cacheKey = cacheKey;
    }

    public Object _persistence_new(PersistenceObject persistenceObject) {
        return new Note();
    }

    public Object _persistence_get(String string) {
        if (string == "noteCreateDate") {
            return this.noteCreateDate;
        }
        if (string == "noteText") {
            return this.noteText;
        }
        if (string == "attachments") {
            return this.attachments;
        }
        if (string == "noteId") {
            return this.noteId;
        }
        if (string == "documentId") {
            return this.documentId;
        }
        if (string == "lockVerNbr") {
            return this.lockVerNbr;
        }
        if (string == "noteAuthorWorkflowId") {
            return this.noteAuthorWorkflowId;
        }
        return null;
    }

    public void _persistence_set(String string, Object object) {
        if (string == "noteCreateDate") {
            this.noteCreateDate = (Timestamp)object;
            return;
        }
        if (string == "noteText") {
            this.noteText = (String)object;
            return;
        }
        if (string == "attachments") {
            this.attachments = (List)object;
            return;
        }
        if (string == "noteId") {
            this.noteId = (String)object;
            return;
        }
        if (string == "documentId") {
            this.documentId = (String)object;
            return;
        }
        if (string == "lockVerNbr") {
            this.lockVerNbr = (Integer)object;
            return;
        }
        if (string == "noteAuthorWorkflowId") {
            this.noteAuthorWorkflowId = (String)object;
            return;
        }
    }

    public Timestamp _persistence_get_noteCreateDate() {
        this._persistence_checkFetched("noteCreateDate");
        return this.noteCreateDate;
    }

    public void _persistence_set_noteCreateDate(Timestamp timestamp) {
        this._persistence_checkFetchedForSet("noteCreateDate");
        this.noteCreateDate = timestamp;
    }

    public String _persistence_get_noteText() {
        this._persistence_checkFetched("noteText");
        return this.noteText;
    }

    public void _persistence_set_noteText(String string) {
        this._persistence_checkFetchedForSet("noteText");
        this.noteText = string;
    }

    public List _persistence_get_attachments() {
        this._persistence_checkFetched("attachments");
        return this.attachments;
    }

    public void _persistence_set_attachments(List list) {
        this._persistence_checkFetchedForSet("attachments");
        this.attachments = list;
    }

    public String _persistence_get_noteId() {
        this._persistence_checkFetched("noteId");
        return this.noteId;
    }

    public void _persistence_set_noteId(String string) {
        this._persistence_checkFetchedForSet("noteId");
        this.noteId = string;
    }

    public String _persistence_get_documentId() {
        this._persistence_checkFetched("documentId");
        return this.documentId;
    }

    public void _persistence_set_documentId(String string) {
        this._persistence_checkFetchedForSet("documentId");
        this.documentId = string;
    }

    public Integer _persistence_get_lockVerNbr() {
        this._persistence_checkFetched("lockVerNbr");
        return this.lockVerNbr;
    }

    public void _persistence_set_lockVerNbr(Integer n) {
        this._persistence_checkFetchedForSet("lockVerNbr");
        this.lockVerNbr = n;
    }

    public String _persistence_get_noteAuthorWorkflowId() {
        this._persistence_checkFetched("noteAuthorWorkflowId");
        return this.noteAuthorWorkflowId;
    }

    public void _persistence_set_noteAuthorWorkflowId(String string) {
        this._persistence_checkFetchedForSet("noteAuthorWorkflowId");
        this.noteAuthorWorkflowId = string;
    }

    public Session _persistence_getSession() {
        return this._persistence_session;
    }

    public void _persistence_setSession(Session session) {
        this._persistence_session = session;
    }

    public FetchGroup _persistence_getFetchGroup() {
        return this._persistence_fetchGroup;
    }

    public void _persistence_setFetchGroup(FetchGroup fetchGroup) {
        this._persistence_fetchGroup = fetchGroup;
    }

    public boolean _persistence_shouldRefreshFetchGroup() {
        return this._persistence_shouldRefreshFetchGroup;
    }

    public void _persistence_setShouldRefreshFetchGroup(boolean bl) {
        this._persistence_shouldRefreshFetchGroup = bl;
    }

    public void _persistence_resetFetchGroup() {
    }

    public boolean _persistence_isAttributeFetched(String string) {
        return this._persistence_fetchGroup == null || this._persistence_fetchGroup.containsAttributeInternal(string);
    }

    public void _persistence_checkFetched(String string) {
        if (!this._persistence_isAttributeFetched(string)) {
            EntityManagerImpl.processUnfetchedAttribute((FetchGroupTracker)this, (String)string);
        }
    }

    public void _persistence_checkFetchedForSet(String string) {
        if (!this._persistence_isAttributeFetched(string)) {
            EntityManagerImpl.processUnfetchedAttributeForSet((FetchGroupTracker)this, (String)string);
        }
    }

    public List _persistence_getRelationships() {
        return this._persistence_relationshipInfo;
    }

    public void _persistence_setRelationships(List list) {
        this._persistence_relationshipInfo = list;
    }

    public Link _persistence_getHref() {
        return this._persistence_href;
    }

    public void _persistence_setHref(Link link) {
        this._persistence_href = link;
    }

    public ItemLinks _persistence_getLinks() {
        return this._persistence_links;
    }

    public void _persistence_setLinks(ItemLinks itemLinks) {
        this._persistence_links = itemLinks;
    }
}

