/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kew.xml;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import org.apache.commons.lang.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.kuali.rice.core.api.util.xml.XmlException;
import org.kuali.rice.core.api.util.xml.XmlJotter;
import org.kuali.rice.kew.rule.bo.RuleAttribute;
import org.kuali.rice.kew.rule.xmlrouting.XPathHelper;
import org.kuali.rice.kew.service.KEWServiceLocator;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class RuleAttributeXmlParser {
    private static final Logger LOG = LogManager.getLogger(RuleAttributeXmlParser.class);
    private static final String XPATH_RULE_ATTRIBUTES = "//ruleAttributes/ruleAttribute";
    private static final String NAME = "name";
    private static final String CLASS_NAME = "className";
    private static final String LABEL = "label";
    private static final String DESCRIPTION = "description";
    private static final String TYPE = "type";
    private static final String CONFIG = "configuration";

    public List parseRuleAttributes(InputStream input) throws IOException, XmlException {
        try {
            Element root = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(new InputSource(input)).getDocumentElement();
            return this.parseRuleAttributes(root);
        }
        catch (Exception e) {
            throw new XmlException("error parsing xml data", (Throwable)e);
        }
    }

    public List parseRuleAttributes(Element element) throws XmlException {
        ArrayList<RuleAttribute> ruleAttributes = new ArrayList<RuleAttribute>();
        try {
            XPath xpath = XPathHelper.newXPath();
            NodeList nodeList = (NodeList)xpath.evaluate(XPATH_RULE_ATTRIBUTES, element, XPathConstants.NODESET);
            for (int i = 0; i < nodeList.getLength(); ++i) {
                Node ruleAttributeNode = nodeList.item(i);
                ruleAttributes.add(this.parseRuleAttribute(ruleAttributeNode));
            }
            for (RuleAttribute ruleAttribute : ruleAttributes) {
                try {
                    RuleAttribute existingAttribute = KEWServiceLocator.getRuleAttributeService().findByName(ruleAttribute.getName());
                    if (existingAttribute != null) {
                        ruleAttribute.setId(existingAttribute.getId());
                        ruleAttribute.setVersionNumber(existingAttribute.getVersionNumber());
                    }
                    KEWServiceLocator.getRuleAttributeService().save(ruleAttribute);
                }
                catch (Exception e) {
                    LOG.error("Error saving rule attribute entered by XML", (Throwable)e);
                }
            }
        }
        catch (XPathExpressionException e1) {
            throw new XmlException("Could not find a rule attribute.", (Throwable)e1);
        }
        return ruleAttributes;
    }

    private RuleAttribute parseRuleAttribute(Node ruleAttributeNode) throws XmlException {
        String name = "";
        String className = "";
        String label = "";
        String description = "";
        String type = "";
        String applicationId = null;
        Node xmlConfig = null;
        for (int i = 0; i < ruleAttributeNode.getChildNodes().getLength(); ++i) {
            Node childNode = ruleAttributeNode.getChildNodes().item(i);
            if (NAME.equals(childNode.getNodeName())) {
                name = childNode.getFirstChild().getNodeValue();
                continue;
            }
            if (CLASS_NAME.equals(childNode.getNodeName())) {
                className = childNode.getFirstChild().getNodeValue();
                continue;
            }
            if (LABEL.equals(childNode.getNodeName())) {
                label = childNode.getFirstChild().getNodeValue();
                continue;
            }
            if (DESCRIPTION.equals(childNode.getNodeName())) {
                description = childNode.getFirstChild().getNodeValue();
                continue;
            }
            if (TYPE.equals(childNode.getNodeName())) {
                type = childNode.getFirstChild().getNodeValue();
                continue;
            }
            if ("routingConfig".equals(childNode.getNodeName()) || "searchingConfig".equals(childNode.getNodeName()) || "searchResultConfig".equals(childNode.getNodeName()) || "resolverConfig".equals(childNode.getNodeName()) || CONFIG.equals(childNode.getNodeName())) {
                xmlConfig = childNode;
                continue;
            }
            if ("serviceNamespace".equals(childNode.getNodeName())) {
                applicationId = childNode.getFirstChild().getNodeValue();
                LOG.warn("serviceNamespace element was set on rule attribute type XML but is deprecated and will be removed in a future version, please use applicationId instead.");
                continue;
            }
            if (!"applicationId".equals(childNode.getNodeName())) continue;
            applicationId = childNode.getFirstChild().getNodeValue();
        }
        if (StringUtils.isEmpty((String)name)) {
            throw new XmlException("RuleAttribute must have a name");
        }
        if (StringUtils.isEmpty((String)className)) {
            throw new XmlException("RuleAttribute must have a className");
        }
        if (StringUtils.isEmpty((String)label)) {
            LOG.warn("Label empty defaulting to name");
            label = name;
        }
        if (StringUtils.isEmpty((String)type)) {
            LOG.debug("No type specified, default to RuleAttribute");
            type = "RuleAttribute";
        }
        type = type.trim();
        this.validateRuleAttributeType(type);
        RuleAttribute ruleAttribute = new RuleAttribute();
        ruleAttribute.setName(name.trim());
        ruleAttribute.setResourceDescriptor(className.trim());
        ruleAttribute.setType(type.trim());
        ruleAttribute.setLabel(label.trim());
        if (StringUtils.isEmpty((String)description)) {
            description = label;
        }
        ruleAttribute.setDescription(description.trim());
        if (applicationId != null) {
            applicationId = applicationId.trim();
        }
        ruleAttribute.setApplicationId(applicationId);
        if (xmlConfig != null) {
            ruleAttribute.setXmlConfigData(XmlJotter.jotNode((Node)xmlConfig));
        } else {
            if ("RuleXmlAttribute".equals(type)) {
                throw new XmlException("A routing config must be present to be of type: " + type);
            }
            if ("SearchableXmlAttribute".equals(type)) {
                throw new XmlException("A searching config must be present to be of type: " + type);
            }
        }
        return ruleAttribute;
    }

    protected void validateRuleAttributeType(String type) {
    }
}

