/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kew.xml;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.jdom2.Element;
import org.jdom2.Namespace;
import org.kuali.rice.core.api.util.xml.XmlException;
import org.kuali.rice.core.api.util.xml.XmlHelper;
import org.kuali.rice.kew.rule.RuleBaseValues;
import org.kuali.rice.kew.rule.RuleExtensionBo;
import org.kuali.rice.kew.rule.RuleExtensionValue;
import org.kuali.rice.kew.rule.bo.RuleAttribute;
import org.kuali.rice.kew.rule.bo.RuleTemplateAttributeBo;
import org.kuali.rice.kew.rule.bo.RuleTemplateBo;
import org.kuali.rice.kew.service.KEWServiceLocator;

public class RuleExtensionXmlParser {
    private static final Namespace NAMESPACE = Namespace.getNamespace((String)"", (String)"ns:workflow/Rule");
    private static final String RULE_EXTENSION = "ruleExtension";
    private static final String ATTRIBUTE = "attribute";
    private static final String RULE_TEMPLATE = "ruleTemplate";
    private static final String RULE_EXTENSION_VALUES = "ruleExtensionValues";
    private static final String RULE_EXTENSION_VALUE = "ruleExtensionValue";
    private static final String KEY = "key";
    private static final String VALUE = "value";

    public List parseRuleExtensions(Element element, RuleBaseValues rule) throws XmlException {
        ArrayList<RuleExtensionBo> ruleExtensions = new ArrayList<RuleExtensionBo>();
        Collection ruleElements = XmlHelper.findElements((Element)element, (String)RULE_EXTENSION);
        Iterator iterator = ruleElements.iterator();
        while (iterator.hasNext()) {
            ruleExtensions.add(this.parseRuleExtension((Element)iterator.next(), rule));
        }
        return ruleExtensions;
    }

    private RuleExtensionBo parseRuleExtension(Element element, RuleBaseValues rule) throws XmlException {
        String attributeName = element.getChildText(ATTRIBUTE, NAMESPACE);
        String templateName = element.getChildText(RULE_TEMPLATE, NAMESPACE);
        Element valuesElement = element.getChild(RULE_EXTENSION_VALUES, NAMESPACE);
        if (attributeName == null) {
            throw new XmlException("Rule extension must have a valid attribute.");
        }
        if (templateName == null) {
            throw new XmlException("Rule extension must have a valid rule template.");
        }
        RuleAttribute ruleAttribute = KEWServiceLocator.getRuleAttributeService().findByName(attributeName);
        if (ruleAttribute == null) {
            throw new XmlException("Could not locate attribute for the given name '" + attributeName + "'");
        }
        RuleTemplateBo ruleTemplate = KEWServiceLocator.getRuleTemplateService().findByRuleTemplateName(templateName);
        if (ruleTemplate == null) {
            throw new XmlException("Could not locate rule template for the given name '" + templateName + "'");
        }
        RuleExtensionBo extension = new RuleExtensionBo();
        extension.setRuleBaseValues(rule);
        boolean attributeFound = false;
        for (RuleTemplateAttributeBo templateAttribute : ruleTemplate.getActiveRuleTemplateAttributes()) {
            if (!templateAttribute.getRuleAttributeId().equals(ruleAttribute.getId())) continue;
            extension.setRuleTemplateAttribute(templateAttribute);
            extension.setRuleTemplateAttributeId(templateAttribute.getId());
            attributeFound = true;
            break;
        }
        if (!attributeFound) {
            throw new XmlException("Attribute '" + attributeName + "' not found on template '" + ruleTemplate.getName() + "'");
        }
        extension.setExtensionValues(this.parseRuleExtensionValues(valuesElement, extension));
        return extension;
    }

    private List parseRuleExtensionValues(Element element, RuleExtensionBo ruleExtension) throws XmlException {
        ArrayList<RuleExtensionValue> values = new ArrayList<RuleExtensionValue>();
        if (element == null) {
            return values;
        }
        Collection valueElements = XmlHelper.findElements((Element)element, (String)RULE_EXTENSION_VALUE);
        for (Element valueElement : valueElements) {
            values.add(this.parseRuleExtensionValue(valueElement, ruleExtension));
        }
        return values;
    }

    private RuleExtensionValue parseRuleExtensionValue(Element element, RuleExtensionBo ruleExtension) throws XmlException {
        String key = element.getChildText(KEY, NAMESPACE);
        String value = element.getChildText(VALUE, NAMESPACE);
        if (StringUtils.isEmpty((String)key)) {
            throw new XmlException("RuleExtensionValue must have a non-empty key.");
        }
        if (value == null) {
            throw new XmlException("RuleExtensionValue must have a non-null value.");
        }
        RuleExtensionValue extensionValue = new RuleExtensionValue(key, value);
        extensionValue.setExtension(ruleExtension);
        return extensionValue;
    }
}

