/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kew.api.document;

import java.util.EnumSet;
import javax.xml.bind.annotation.XmlEnum;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import org.kuali.rice.core.api.mo.common.Coded;
import org.kuali.rice.kew.api.document.DocumentStatusCategory;

@XmlRootElement(name="documentStatus")
@XmlType(name="DocumentStatusType")
@XmlEnum
public enum DocumentStatus implements Coded
{
    INITIATED("I", DocumentStatusCategory.PENDING),
    SAVED("S", DocumentStatusCategory.PENDING),
    ENROUTE("R", DocumentStatusCategory.PENDING),
    EXCEPTION("E", DocumentStatusCategory.PENDING),
    PROCESSED("P", DocumentStatusCategory.SUCCESSFUL),
    FINAL("F", DocumentStatusCategory.SUCCESSFUL),
    CANCELED("X", DocumentStatusCategory.UNSUCCESSFUL),
    DISAPPROVED("D", DocumentStatusCategory.UNSUCCESSFUL),
    RECALLED("L", DocumentStatusCategory.UNSUCCESSFUL);

    private final String code;
    private final DocumentStatusCategory category;

    private DocumentStatus(String code, DocumentStatusCategory category) {
        this.code = code;
        this.category = category;
    }

    public String getCode() {
        return this.code;
    }

    public DocumentStatusCategory getCategory() {
        return this.category;
    }

    public String getLabel() {
        return this.name();
    }

    public static DocumentStatus fromCode(String code) {
        if (code == null) {
            return null;
        }
        for (DocumentStatus status : DocumentStatus.values()) {
            if (!status.code.equals(code)) continue;
            return status;
        }
        throw new IllegalArgumentException("Failed to locate the DocumentStatus with the given code: " + code);
    }

    public static EnumSet<DocumentStatus> getStatusesForCategory(DocumentStatusCategory category) {
        if (category == null) {
            throw new IllegalArgumentException("category was null");
        }
        EnumSet<DocumentStatus> categoryStatuses = EnumSet.noneOf(DocumentStatus.class);
        for (DocumentStatus status : DocumentStatus.values()) {
            if (status.category != category) continue;
            categoryStatuses.add(status);
        }
        return categoryStatuses;
    }
}

