/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krad.service.impl;

import java.beans.PropertyDescriptor;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.lang.StringUtils;
import org.kuali.rice.core.api.config.property.ConfigContext;
import org.kuali.rice.kim.api.identity.Person;
import org.kuali.rice.kim.api.identity.PersonService;
import org.kuali.rice.kim.api.services.KimApiServiceLocator;
import org.kuali.rice.krad.bo.BusinessObject;
import org.kuali.rice.krad.bo.DataObjectRelationship;
import org.kuali.rice.krad.bo.ExternalizableBusinessObject;
import org.kuali.rice.krad.bo.PersistableBusinessObject;
import org.kuali.rice.krad.bo.PersistableBusinessObjectBaseAdapter;
import org.kuali.rice.krad.dao.BusinessObjectDao;
import org.kuali.rice.krad.exception.ObjectNotABusinessObjectRuntimeException;
import org.kuali.rice.krad.exception.ReferenceAttributeDoesntExistException;
import org.kuali.rice.krad.service.BusinessObjectService;
import org.kuali.rice.krad.service.DataObjectMetaDataService;
import org.kuali.rice.krad.service.KRADServiceLocatorWeb;
import org.kuali.rice.krad.service.ModuleService;
import org.kuali.rice.krad.service.PersistenceService;
import org.kuali.rice.krad.service.PersistenceStructureService;
import org.kuali.rice.krad.util.LegacyDataFramework;
import org.kuali.rice.krad.util.ObjectUtils;
import org.springframework.transaction.annotation.Transactional;

@Deprecated
@LegacyDataFramework
public class BusinessObjectServiceImpl
implements BusinessObjectService {
    private PersistenceService persistenceService;
    private PersistenceStructureService persistenceStructureService;
    private BusinessObjectDao businessObjectDao;
    private PersonService personService;
    private DataObjectMetaDataService dataObjectMetaDataService;
    private LegacyDataFramework legacyDataFramework;
    private boolean illegalBusinessObjectsForSaveInitialized;
    private final Set<String> illegalBusinessObjectsForSave = new HashSet<String>();

    @Override
    @Transactional
    public <T extends PersistableBusinessObject> T save(T bo) {
        this.validateBusinessObjectForSave(bo);
        return (T)this.businessObjectDao.save(bo);
    }

    @Override
    @Transactional
    public List<? extends PersistableBusinessObject> save(List<? extends PersistableBusinessObject> businessObjects) {
        this.validateBusinessObjectForSave(businessObjects);
        return this.businessObjectDao.save(businessObjects);
    }

    @Override
    @Transactional
    public PersistableBusinessObject linkAndSave(PersistableBusinessObject bo) {
        this.validateBusinessObjectForSave(bo);
        this.persistenceService.linkObjects(bo);
        return this.businessObjectDao.save(bo);
    }

    @Override
    @Transactional
    public List<? extends PersistableBusinessObject> linkAndSave(List<? extends PersistableBusinessObject> businessObjects) {
        this.validateBusinessObjectForSave(businessObjects);
        return this.businessObjectDao.save(businessObjects);
    }

    protected void validateBusinessObjectForSave(PersistableBusinessObject bo) {
        if (bo == null) {
            throw new IllegalArgumentException("Object passed in is null");
        }
        if (!this.isBusinessObjectAllowedForSave(bo)) {
            throw new IllegalArgumentException("Object passed in is a BusinessObject but has been restricted from save operations according to configuration parameter 'rice.krad.illegalBusinessObjectsForSave");
        }
    }

    protected void validateBusinessObjectForSave(List<? extends PersistableBusinessObject> businessObjects) {
        for (PersistableBusinessObject persistableBusinessObject : businessObjects) {
            if (persistableBusinessObject == null) {
                throw new IllegalArgumentException("One of the objects in the List is null.");
            }
            if (this.isBusinessObjectAllowedForSave(persistableBusinessObject)) continue;
            throw new IllegalArgumentException("One of the objects in the List is a BusinessObject but has been restricted from save operations according to configuration parameter 'rice.krad.illegalBusinessObjectsForSave  Passed in type was '" + persistableBusinessObject.getClass().getName() + "'.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean isBusinessObjectAllowedForSave(PersistableBusinessObject bo) {
        if (!this.illegalBusinessObjectsForSaveInitialized) {
            BusinessObjectServiceImpl businessObjectServiceImpl = this;
            synchronized (businessObjectServiceImpl) {
                String illegalBos;
                boolean applyCheck = true;
                String applyCheckValue = ConfigContext.getCurrentContextConfig().getProperty("rice.krad.illegalBusinessObjectsForSave.applyCheck");
                if (!StringUtils.isEmpty((String)applyCheckValue)) {
                    applyCheck = Boolean.valueOf(applyCheckValue);
                }
                if (applyCheck && !StringUtils.isEmpty((String)(illegalBos = ConfigContext.getCurrentContextConfig().getProperty("rice.krad.illegalBusinessObjectsForSave")))) {
                    String[] illegalBosSplit;
                    for (String illegalBo : illegalBosSplit = illegalBos.split(",")) {
                        this.illegalBusinessObjectsForSave.add(illegalBo.trim());
                    }
                }
            }
            this.illegalBusinessObjectsForSaveInitialized = true;
        }
        return !this.illegalBusinessObjectsForSave.contains(bo.getClass().getName());
    }

    @Override
    public <T extends BusinessObject> T findBySinglePrimaryKey(Class<T> clazz, Object primaryKey) {
        return this.businessObjectDao.findBySinglePrimaryKey(clazz, primaryKey);
    }

    @Override
    public <T extends BusinessObject> T findByPrimaryKey(Class<T> clazz, Map<String, ?> primaryKeys) {
        return this.businessObjectDao.findByPrimaryKey(clazz, primaryKeys);
    }

    @Override
    public Object retrieve(Object object) {
        return this.businessObjectDao.retrieve(object);
    }

    @Override
    public <T extends BusinessObject> Collection<T> findAll(Class<T> clazz) {
        return this.businessObjectDao.findAll(clazz);
    }

    @Override
    public <T extends BusinessObject> Collection<T> findAllOrderBy(Class<T> clazz, String sortField, boolean sortAscending) {
        Map emptyParameters = Collections.emptyMap();
        return this.businessObjectDao.findMatchingOrderBy(clazz, emptyParameters, sortField, sortAscending);
    }

    @Override
    public <T extends BusinessObject> Collection<T> findMatching(Class<T> clazz, Map<String, ?> fieldValues) {
        return this.businessObjectDao.findMatching(clazz, fieldValues);
    }

    @Override
    public int countMatching(Class clazz, Map<String, ?> fieldValues) {
        return this.businessObjectDao.countMatching(clazz, fieldValues);
    }

    @Override
    public int countMatching(Class clazz, Map<String, ?> positiveFieldValues, Map<String, ?> negativeFieldValues) {
        return this.businessObjectDao.countMatching(clazz, positiveFieldValues, negativeFieldValues);
    }

    @Override
    public <T extends BusinessObject> Collection<T> findMatchingOrderBy(Class<T> clazz, Map<String, ?> fieldValues, String sortField, boolean sortAscending) {
        return this.businessObjectDao.findMatchingOrderBy(clazz, fieldValues, sortField, sortAscending);
    }

    @Override
    @Transactional
    public void delete(Object bo) {
        if (bo instanceof List) {
            this.delete((List)bo);
        } else {
            this.businessObjectDao.delete(bo);
        }
    }

    @Override
    @Transactional
    public void delete(List<? extends PersistableBusinessObject> boList) {
        this.businessObjectDao.delete(boList);
    }

    @Override
    @Transactional
    public void deleteMatching(Class clazz, Map<String, ?> fieldValues) {
        this.businessObjectDao.deleteMatching(clazz, fieldValues);
    }

    @Override
    public BusinessObject getReferenceIfExists(BusinessObject bo, String referenceName) {
        PropertyDescriptor propertyDescriptor;
        if (ObjectUtils.isNull(bo)) {
            throw new IllegalArgumentException("Passed in BusinessObject was null.  No processing can be done.");
        }
        if (StringUtils.isEmpty((String)referenceName)) {
            throw new IllegalArgumentException("Passed in referenceName was empty or null.  No processing can be done.");
        }
        try {
            propertyDescriptor = PropertyUtils.getPropertyDescriptor((Object)bo, (String)referenceName);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        if (propertyDescriptor == null) {
            throw new ReferenceAttributeDoesntExistException("Requested attribute: '" + referenceName + "' does not exist on class: '" + bo.getClass().getName() + "'. GFK");
        }
        Class referenceClass = null;
        if (bo instanceof PersistableBusinessObject) {
            referenceClass = this.persistenceStructureService.getBusinessObjectAttributeClass(((PersistableBusinessObject)bo).getClass(), referenceName);
        }
        if (referenceClass == null) {
            referenceClass = ObjectUtils.getPropertyType(bo, referenceName, this.persistenceStructureService);
        }
        if (referenceClass == null) {
            referenceClass = propertyDescriptor.getPropertyType();
        }
        if (ExternalizableBusinessObject.class.isAssignableFrom(referenceClass)) {
            try {
                BusinessObject referenceBoExternalizable = (BusinessObject)PropertyUtils.getProperty((Object)bo, (String)referenceName);
                if (referenceBoExternalizable != null) {
                    return referenceBoExternalizable;
                }
            }
            catch (Exception referenceBoExternalizable) {
                // empty catch block
            }
        }
        if (!ExternalizableBusinessObject.class.isAssignableFrom(referenceClass) && !PersistableBusinessObject.class.isAssignableFrom(referenceClass)) {
            throw new ObjectNotABusinessObjectRuntimeException("Attribute requested (" + referenceName + ") is of class: '" + referenceClass.getName() + "' and is not a descendent of PersistableBusinessObject.  Only descendents of PersistableBusinessObject can be used.");
        }
        DataObjectRelationship boRel = this.getDataObjectMetaDataService().getDataObjectRelationship(bo, bo.getClass(), referenceName, "", true, false, false);
        Map fkMap = boRel != null ? boRel.getParentToChildReferences() : Collections.emptyMap();
        boolean allFkeysHaveValues = true;
        HashMap<String, Object> pkMap = new HashMap<String, Object>();
        for (Map.Entry entry : fkMap.entrySet()) {
            Object fkFieldValue;
            String fkFieldName = (String)entry.getKey();
            String pkFieldName = (String)entry.getValue();
            try {
                fkFieldValue = PropertyUtils.getProperty((Object)bo, (String)fkFieldName);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            if (ObjectUtils.isNull(fkFieldValue)) {
                allFkeysHaveValues = false;
                break;
            }
            if (String.class.isAssignableFrom(fkFieldValue.getClass())) {
                if (StringUtils.isEmpty((String)((String)fkFieldValue))) {
                    allFkeysHaveValues = false;
                    break;
                }
                pkMap.put(pkFieldName, fkFieldValue);
                continue;
            }
            pkMap.put(pkFieldName, fkFieldValue);
        }
        BusinessObject referenceBo = null;
        if (allFkeysHaveValues) {
            if (ExternalizableBusinessObject.class.isAssignableFrom(referenceClass)) {
                ModuleService responsibleModuleService = KRADServiceLocatorWeb.getKualiModuleService().getResponsibleModuleService(referenceClass);
                if (responsibleModuleService != null) {
                    return responsibleModuleService.getExternalizableBusinessObject(referenceClass, pkMap);
                }
            } else {
                referenceBo = (BusinessObject)this.findByPrimaryKey(referenceClass, pkMap);
            }
        }
        return referenceBo;
    }

    @Override
    public void linkUserFields(Object bo) {
        if (bo == null) {
            throw new IllegalArgumentException("bo passed in was null");
        }
        if (bo instanceof List) {
            this.linkUserFieldsInBoList((List)bo);
        } else if (bo instanceof PersistableBusinessObject) {
            ((PersistableBusinessObject)bo).linkEditableUserFields();
            this.linkUserFieldsInBoList(Collections.singletonList((PersistableBusinessObject)bo));
        } else if (bo instanceof PersistableBusinessObjectBaseAdapter) {
            ((PersistableBusinessObjectBaseAdapter)bo).linkEditableUserFields();
        }
    }

    protected void linkUserFieldsInBoList(List<PersistableBusinessObject> list) {
        if (list == null) {
            throw new IllegalArgumentException("List of bos passed in was null");
        }
        if (list.isEmpty()) {
            return;
        }
        for (PersistableBusinessObject obj : list) {
            Person person;
            if (!(obj instanceof PersistableBusinessObject)) continue;
            PersistableBusinessObject bo = obj;
            List<DataObjectRelationship> relationships = this.dataObjectMetaDataService.getDataObjectRelationships(bo.getClass());
            block1: for (DataObjectRelationship rel : relationships) {
                if (!Person.class.isAssignableFrom(rel.getRelatedClass()) || (person = (Person)ObjectUtils.getPropertyValue(bo, rel.getParentAttributeName())) == null) continue;
                for (Map.Entry entry : rel.getParentToChildReferences().entrySet()) {
                    if (!"principalId".equals(entry.getValue())) continue;
                    this.linkUserReference(bo, person, rel.getParentAttributeName(), (String)entry.getKey());
                    continue block1;
                }
            }
            if (!this.persistenceStructureService.isPersistable(bo.getClass())) continue;
            Map<String, Class> references = this.persistenceStructureService.listReferenceObjectFields(bo);
            for (Map.Entry<String, Class> entry : references.entrySet()) {
                if (!Person.class.isAssignableFrom(entry.getValue()) || (person = (Person)ObjectUtils.getPropertyValue(bo, entry.getKey())) == null) continue;
                String fkFieldName = this.persistenceStructureService.getForeignKeyFieldName(bo.getClass(), entry.getKey(), "principalId");
                this.linkUserReference(bo, person, entry.getKey(), fkFieldName);
            }
        }
    }

    private void linkUserReference(PersistableBusinessObject bo, Person user, String refFieldName, String fkFieldName) {
        if (StringUtils.isBlank((String)user.getPrincipalName())) {
            return;
        }
        Person userFromService = this.getPersonService().getPersonByPrincipalName(user.getPrincipalName());
        if (userFromService == null) {
            return;
        }
        this.setBoField(bo, fkFieldName, userFromService.getPrincipalId());
    }

    private void setBoField(PersistableBusinessObject bo, String fieldName, Object fieldValue) {
        try {
            ObjectUtils.setObjectProperty(bo, fieldName, fieldValue.getClass(), fieldValue);
        }
        catch (Exception e) {
            throw new RuntimeException("Could not set field [" + fieldName + "] on BO to value: " + fieldValue.toString() + " (see nested exception for details).", e);
        }
    }

    @Override
    public PersistableBusinessObject manageReadOnly(PersistableBusinessObject bo) {
        return this.getBusinessObjectDao().manageReadOnly(bo);
    }

    protected BusinessObjectDao getBusinessObjectDao() {
        return this.businessObjectDao;
    }

    public void setBusinessObjectDao(BusinessObjectDao businessObjectDao) {
        this.businessObjectDao = businessObjectDao;
    }

    public void setPersistenceStructureService(PersistenceStructureService persistenceStructureService) {
        this.persistenceStructureService = persistenceStructureService;
    }

    public final void setPersonService(PersonService personService) {
        this.personService = personService;
    }

    protected PersonService getPersonService() {
        return this.personService != null ? this.personService : (this.personService = KimApiServiceLocator.getPersonService());
    }

    public final void setPersistenceService(PersistenceService persistenceService) {
        this.persistenceService = persistenceService;
    }

    protected DataObjectMetaDataService getDataObjectMetaDataService() {
        return this.dataObjectMetaDataService;
    }

    public void setDataObjectMetaDataService(DataObjectMetaDataService dataObjectMetadataService) {
        this.dataObjectMetaDataService = dataObjectMetadataService;
    }
}

