/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.core.api.util.collect;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public final class CollectionUtils {
    private CollectionUtils() {
        throw new UnsupportedOperationException("do not call");
    }

    public static boolean collectionsEquivalent(Collection<?> a, Collection<?> b) {
        if (a == null && b == null) {
            return true;
        }
        if (a == null ^ b == null) {
            return false;
        }
        return a.containsAll(b) && b.containsAll(a);
    }

    public static <T> Iterable<T> toIterable(Iterator<T> i) {
        return new IterableIterator<T>(i);
    }

    public static <T> Iterable<T> toIterable(Enumeration<T> e) {
        return new IterableEnumeration<T>(e);
    }

    public static <T> Collection<T> unmodifiableCollectionNullSafe(Collection<? extends T> collection) {
        if (collection == null) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableCollection(collection);
    }

    public static <T> List<T> unmodifiableListNullSafe(List<? extends T> list) {
        if (list == null) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(list);
    }

    public static <T> Set<T> unmodifiableSetNullSafe(Set<? extends T> set) {
        if (set == null) {
            return Collections.emptySet();
        }
        return Collections.unmodifiableSet(set);
    }

    public static <K, V> Map<K, V> unmodifiableMapNullSafe(Map<? extends K, ? extends V> map) {
        if (map == null) {
            return Collections.emptyMap();
        }
        return Collections.unmodifiableMap(map);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void makeUnmodifiableAndNullSafe(Object o) throws IllegalAccessException {
        if (o == null) {
            return;
        }
        Class<?> targetClass = o.getClass();
        for (Field f : targetClass.getDeclaredFields()) {
            f.setAccessible(true);
            try {
                if (f.getType().isAssignableFrom(List.class)) {
                    f.set(o, CollectionUtils.unmodifiableListNullSafe((List)f.get(o)));
                    continue;
                }
                if (f.getType().isAssignableFrom(Set.class)) {
                    f.set(o, CollectionUtils.unmodifiableSetNullSafe((Set)f.get(o)));
                    continue;
                }
                if (f.getType().isAssignableFrom(Collection.class)) {
                    f.set(o, CollectionUtils.unmodifiableCollectionNullSafe((Collection)f.get(o)));
                    continue;
                }
                if (!f.getType().isAssignableFrom(Map.class)) continue;
                f.set(o, CollectionUtils.unmodifiableMapNullSafe((Map)f.get(o)));
            }
            finally {
                f.setAccessible(false);
            }
        }
    }

    public static <T> Enumeration<T> concat(Enumeration<? extends T> ... inputs) {
        return new SimpleEnumeration<T>(inputs);
    }

    private static class IterableIterator<T>
    implements Iterable<T> {
        private final Iterator<T> i;

        private IterableIterator(Iterator<T> i) {
            if (i == null) {
                throw new IllegalArgumentException("the iterator is null");
            }
            this.i = i;
        }

        @Override
        public Iterator<T> iterator() {
            return this.i;
        }
    }

    private static class IterableEnumeration<T>
    implements Iterable<T> {
        private final Enumeration<T> e;

        private IterableEnumeration(Enumeration<T> e) {
            if (e == null) {
                throw new IllegalArgumentException("the enumeration is null");
            }
            this.e = e;
        }

        @Override
        public Iterator<T> iterator() {
            return new Iterator<T>(){

                @Override
                public boolean hasNext() {
                    return e.hasMoreElements();
                }

                @Override
                public T next() {
                    return e.nextElement();
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException("this iterator does not support remove");
                }
            };
        }
    }

    private static class SimpleEnumeration<T>
    implements Enumeration<T> {
        private final Iterator<T> iterator;

        private SimpleEnumeration(Enumeration<? extends T> ... enumerations) {
            if (enumerations == null) {
                throw new NullPointerException("enumerations is null");
            }
            ArrayList<T> internalList = new ArrayList<T>();
            for (Enumeration<T> enumeration : enumerations) {
                if (enumeration == null) {
                    throw new NullPointerException("input is null");
                }
                while (enumeration.hasMoreElements()) {
                    internalList.add(enumeration.nextElement());
                }
            }
            this.iterator = internalList.iterator();
        }

        @Override
        public boolean hasMoreElements() {
            return this.iterator.hasNext();
        }

        @Override
        public T nextElement() {
            return this.iterator.next();
        }
    }
}

