/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ojb.broker.accesslayer;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.ojb.broker.PersistenceBrokerException;
import org.apache.ojb.broker.accesslayer.OJBIterator;
import org.apache.ojb.broker.accesslayer.RsIterator;

public class ChainingIterator
implements OJBIterator {
    private List m_rsIterators = new ArrayList();
    private OJBIterator m_activeIterator = null;
    private int m_activeIteratorIndex = 0;
    private int m_fullSize = -1;
    private int m_currentCursorPosition = 0;
    private boolean disableLifeCycleEvents = false;

    public ChainingIterator() {
    }

    public ChainingIterator(List list) {
        for (OJBIterator oJBIterator : list) {
            this.addIterator(oJBIterator);
        }
    }

    public void addIterator(OJBIterator oJBIterator) {
        if (oJBIterator != null && oJBIterator.hasNext()) {
            this.setNextIterator();
            this.m_rsIterators.add(oJBIterator);
        }
    }

    @Override
    public int size() throws PersistenceBrokerException {
        if (this.m_fullSize == -1) {
            int n = 0;
            Iterator iterator = this.m_rsIterators.iterator();
            while (iterator.hasNext()) {
                n += ((OJBIterator)iterator.next()).size();
            }
            this.m_fullSize = n;
        }
        return this.m_fullSize;
    }

    @Override
    public int fullSize() throws PersistenceBrokerException {
        return this.size();
    }

    @Override
    public boolean absolute(int n) throws PersistenceBrokerException {
        boolean bl;
        block8: {
            boolean bl2;
            block7: {
                if (n == 0) {
                    return true;
                }
                if (n == 1) {
                    this.m_activeIteratorIndex = 0;
                    this.m_activeIterator = (OJBIterator)this.m_rsIterators.get(this.m_activeIteratorIndex);
                    this.m_activeIterator.absolute(1);
                    return true;
                }
                if (n == -1) {
                    this.m_activeIteratorIndex = this.m_rsIterators.size();
                    this.m_activeIterator = (OJBIterator)this.m_rsIterators.get(this.m_activeIteratorIndex);
                    this.m_activeIterator.absolute(-1);
                    return true;
                }
                bl2 = false;
                bl = false;
                this.setNextIterator();
                if (n <= 0) break block7;
                int n2 = 0;
                Iterator iterator = this.m_rsIterators.iterator();
                OJBIterator oJBIterator = null;
                while (iterator.hasNext() && !bl2) {
                    oJBIterator = (OJBIterator)iterator.next();
                    if (oJBIterator.size() < n) {
                        n2 += oJBIterator.size();
                        continue;
                    }
                    this.m_currentCursorPosition = n - n2;
                    bl = oJBIterator.absolute(this.m_currentCursorPosition);
                    bl2 = true;
                }
                break block8;
            }
            if (n >= 0) break block8;
            int n3 = 0;
            OJBIterator oJBIterator = null;
            for (int i = this.m_rsIterators.size(); i >= 0 && !bl2; --i) {
                oJBIterator = (OJBIterator)this.m_rsIterators.get(i);
                if (oJBIterator.size() < n) {
                    n3 += oJBIterator.size();
                    continue;
                }
                this.m_currentCursorPosition = n + n3;
                bl = oJBIterator.absolute(this.m_currentCursorPosition);
                bl2 = true;
            }
        }
        return bl;
    }

    @Override
    public boolean relative(int n) throws PersistenceBrokerException {
        if (n == 0) {
            return true;
        }
        boolean bl = false;
        boolean bl2 = false;
        this.setNextIterator();
        if (n > 0) {
            if (n > this.m_activeIterator.size() - this.m_currentCursorPosition) {
                int n2 = this.m_activeIterator.size() - this.m_currentCursorPosition;
                for (int i = this.m_activeIteratorIndex + 1; i < this.m_rsIterators.size() && !bl; ++i) {
                    this.m_activeIteratorIndex = i;
                    this.m_currentCursorPosition = 0;
                    this.m_activeIterator = (OJBIterator)this.m_rsIterators.get(this.m_activeIteratorIndex);
                    if (n - n2 > this.m_activeIterator.size()) continue;
                    this.m_currentCursorPosition = n - n2;
                    bl2 = this.m_activeIterator.relative(this.m_currentCursorPosition);
                    bl = true;
                }
            } else {
                bl2 = this.m_activeIterator.relative(n);
                bl = true;
            }
        }
        return bl2;
    }

    @Override
    public void releaseDbResources() {
        Iterator iterator = this.m_rsIterators.iterator();
        while (iterator.hasNext()) {
            ((OJBIterator)iterator.next()).releaseDbResources();
        }
    }

    @Override
    public boolean hasNext() {
        this.setNextIterator();
        if (this.m_activeIterator == null) {
            return false;
        }
        return this.m_activeIterator.hasNext();
    }

    public Object next() {
        this.setNextIterator();
        ++this.m_currentCursorPosition;
        return this.m_activeIterator.next();
    }

    @Override
    public void remove() {
        this.setNextIterator();
        this.m_activeIterator.remove();
    }

    private boolean setNextIterator() {
        boolean bl = false;
        if (this.m_activeIterator == null) {
            if (this.m_rsIterators.size() > 0) {
                this.m_activeIteratorIndex = 0;
                this.m_currentCursorPosition = 0;
                this.m_activeIterator = (OJBIterator)this.m_rsIterators.get(this.m_activeIteratorIndex);
            }
        } else if (!this.m_activeIterator.hasNext() && this.m_rsIterators.size() > this.m_activeIteratorIndex + 1) {
            ++this.m_activeIteratorIndex;
            this.m_currentCursorPosition = 0;
            this.m_activeIterator = (OJBIterator)this.m_rsIterators.get(this.m_activeIteratorIndex);
            bl = true;
        }
        return bl;
    }

    public boolean containsIteratorForTable(String string) {
        boolean bl = false;
        if (this.m_rsIterators != null) {
            for (int i = 0; i < this.m_rsIterators.size(); ++i) {
                OJBIterator oJBIterator = (OJBIterator)this.m_rsIterators.get(i);
                if (oJBIterator instanceof RsIterator) {
                    if (!((RsIterator)oJBIterator).getClassDescriptor().getFullTableName().equals(string)) continue;
                    bl = true;
                    break;
                }
                if (!(oJBIterator instanceof ChainingIterator)) continue;
                bl = ((ChainingIterator)oJBIterator).containsIteratorForTable(string);
            }
        }
        return bl;
    }

    @Override
    public void disableLifeCycleEvents() {
        for (OJBIterator oJBIterator : this.m_rsIterators) {
            oJBIterator.disableLifeCycleEvents();
        }
    }
}

