/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ojb.broker.ant;

import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.taskdefs.Java;
import org.apache.tools.ant.types.Path;
import org.apache.tools.ant.types.Reference;

public class TorqueRepositoryGeneratorTask
extends Task {
    private String inputFile;
    private String outputFile;
    private String database;
    private Reference classpathRef = null;
    private Path classpath = null;
    private String indexTablespace = "";
    private boolean useNativeIncrement = true;

    public void setInputFile(String string) {
        this.inputFile = string;
    }

    public String getInputFile() {
        return this.inputFile;
    }

    public void setOutputFile(String string) {
        this.outputFile = string;
    }

    public String getOutputFile() {
        return this.outputFile;
    }

    public void setDatabase(String string) {
        this.database = string;
    }

    public String getDatabase() {
        return this.database;
    }

    public void setIndexTablespace(String string) {
        this.indexTablespace = string;
    }

    public String getIndexTablespace() {
        return this.indexTablespace;
    }

    public void setUseNativeIncrement(String string) {
        this.useNativeIncrement = "yes".equalsIgnoreCase(string);
    }

    public String getUseNativeIncrement() {
        if (this.useNativeIncrement) {
            return "yes";
        }
        return "no";
    }

    public Path getClasspath() {
        return this.classpath;
    }

    public void setClasspath(Path path) {
        this.classpath = path;
    }

    public Path createClasspath() {
        if (this.classpath == null) {
            this.classpath = new Path(this.getProject());
        }
        return this.classpath.createPath();
    }

    public Reference getClasspathRef() {
        return this.classpathRef;
    }

    public void setClasspathRef(Reference reference) {
        this.classpathRef = reference;
    }

    public void execute() throws BuildException {
        this.checkParameters();
        Java java = (Java)this.project.createTask("java");
        java.createArg().setLine(this.inputFile + " " + this.outputFile + " " + this.database + " " + this.indexTablespace + " " + this.useNativeIncrement);
        java.setFork(true);
        java.setClassname("org.apache.ojb.broker.metadata.torque.TorqueRepositoryGenerator");
        if (this.classpathRef != null) {
            java.setClasspathRef(this.classpathRef);
        }
        if (this.classpath != null) {
            java.setClasspath(this.classpath);
        }
        java.execute();
    }

    protected boolean isEmpty(String string) {
        return string == null || string.trim().length() == 0;
    }

    protected void checkParameters() throws BuildException {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.isEmpty(this.database)) {
            stringBuffer.append("Database property not set.\n");
        }
        if (this.isEmpty(this.inputFile)) {
            stringBuffer.append("Input file property not set.\n");
        }
        if (this.isEmpty(this.outputFile)) {
            stringBuffer.append("Output file property not set.\n");
        }
        if (stringBuffer.toString().length() > 0) {
            throw new BuildException(stringBuffer.toString());
        }
    }
}

