/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ojb.broker.util;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.iterators.ArrayIterator;
import org.apache.commons.collections.map.ReferenceIdentityMap;
import org.apache.ojb.broker.Identity;
import org.apache.ojb.broker.ManageableCollection;
import org.apache.ojb.broker.MtoNImplementor;
import org.apache.ojb.broker.OJBRuntimeException;
import org.apache.ojb.broker.PBKey;
import org.apache.ojb.broker.PersistenceBrokerException;
import org.apache.ojb.broker.accesslayer.StatementManagerIF;
import org.apache.ojb.broker.accesslayer.sql.SqlExistStatement;
import org.apache.ojb.broker.core.PersistenceBrokerImpl;
import org.apache.ojb.broker.core.ValueContainer;
import org.apache.ojb.broker.core.proxy.IndirectionHandler;
import org.apache.ojb.broker.core.proxy.ProxyHelper;
import org.apache.ojb.broker.metadata.AttributeDescriptorBase;
import org.apache.ojb.broker.metadata.ClassDescriptor;
import org.apache.ojb.broker.metadata.CollectionDescriptor;
import org.apache.ojb.broker.metadata.FieldDescriptor;
import org.apache.ojb.broker.metadata.FieldHelper;
import org.apache.ojb.broker.metadata.MetadataException;
import org.apache.ojb.broker.metadata.MetadataManager;
import org.apache.ojb.broker.metadata.ObjectReferenceDescriptor;
import org.apache.ojb.broker.metadata.fieldaccess.PersistentField;
import org.apache.ojb.broker.platforms.Platform;
import org.apache.ojb.broker.query.Criteria;
import org.apache.ojb.broker.query.MtoNQuery;
import org.apache.ojb.broker.query.Query;
import org.apache.ojb.broker.query.QueryByCriteria;
import org.apache.ojb.broker.query.QueryBySQL;
import org.apache.ojb.broker.query.ReportQueryByCriteria;
import org.apache.ojb.broker.query.ReportQueryByMtoNCriteria;
import org.apache.ojb.broker.util.ExceptionHelper;
import org.apache.ojb.broker.util.logging.LoggerFactory;
import org.apache.ojb.broker.util.sequence.SequenceManagerException;

public class BrokerHelper {
    public static final String REPOSITORY_NAME_SEPARATOR = "#";
    private PersistenceBrokerImpl m_broker;
    private Map sqlSelectMap = new ReferenceIdentityMap(2, 0);

    public BrokerHelper(PersistenceBrokerImpl persistenceBrokerImpl) {
        this.m_broker = persistenceBrokerImpl;
    }

    public static PBKey extractAllTokens(String string) {
        if (string == null) {
            throw new PersistenceBrokerException("Could not extract PBKey, given argument is 'null'");
        }
        String string2 = null;
        String string3 = null;
        StringTokenizer stringTokenizer = new StringTokenizer(string, REPOSITORY_NAME_SEPARATOR);
        String string4 = stringTokenizer.nextToken();
        if (stringTokenizer.hasMoreTokens() && (string2 = stringTokenizer.nextToken()) != null && string2.trim().equals("")) {
            string2 = null;
        }
        if (stringTokenizer.hasMoreTokens() && string2 != null) {
            string3 = stringTokenizer.nextToken();
        }
        if (string2 != null && string3 == null) {
            string3 = "";
        }
        return new PBKey(string4, string2, string3);
    }

    public static PBKey crossCheckPBKey(PBKey pBKey) {
        PBKey pBKey2;
        if (pBKey.getUser() == null && (pBKey2 = MetadataManager.getInstance().connectionRepository().getStandardPBKeyForJcdAlias(pBKey.getAlias())) != null) {
            return pBKey2;
        }
        return pBKey;
    }

    private ClassDescriptor getRealClassDescriptor(ClassDescriptor classDescriptor, Object object) {
        ClassDescriptor classDescriptor2 = classDescriptor.getClassOfObject() == ProxyHelper.getRealClass(object) ? classDescriptor : classDescriptor.getRepository().getDescriptorFor(object.getClass());
        return classDescriptor2;
    }

    public ValueContainer[] getKeyValues(ClassDescriptor classDescriptor, Object object, boolean bl) throws PersistenceBrokerException {
        IndirectionHandler indirectionHandler = ProxyHelper.getIndirectionHandler(object);
        if (indirectionHandler != null) {
            return this.getKeyValues(classDescriptor, indirectionHandler.getIdentity(), bl);
        }
        ClassDescriptor classDescriptor2 = this.getRealClassDescriptor(classDescriptor, object);
        return this.getValuesForObject(classDescriptor2.getPkFields(), object, bl);
    }

    public ValueContainer[] getKeyValues(ClassDescriptor classDescriptor, Identity identity) throws PersistenceBrokerException {
        return this.getKeyValues(classDescriptor, identity, true);
    }

    public ValueContainer[] getKeyValues(ClassDescriptor classDescriptor, Identity identity, boolean bl) throws PersistenceBrokerException {
        FieldDescriptor[] fieldDescriptorArray = classDescriptor.getPkFields();
        ValueContainer[] valueContainerArray = new ValueContainer[fieldDescriptorArray.length];
        Object[] objectArray = identity.getPrimaryKeyValues();
        try {
            for (int i = 0; i < valueContainerArray.length; ++i) {
                FieldDescriptor fieldDescriptor = fieldDescriptorArray[i];
                Object object = objectArray[i];
                if (bl) {
                    object = fieldDescriptor.getFieldConversion().javaToSql(object);
                }
                valueContainerArray[i] = new ValueContainer(object, fieldDescriptor.getJdbcType());
            }
        }
        catch (Exception exception) {
            throw new PersistenceBrokerException("Can't generate primary key values for given Identity " + identity, exception);
        }
        return valueContainerArray;
    }

    public ValueContainer[] getKeyValues(ClassDescriptor classDescriptor, Object object) throws PersistenceBrokerException {
        return this.getKeyValues(classDescriptor, object, true);
    }

    public boolean representsNull(FieldDescriptor fieldDescriptor, Object object) {
        if (object == null) {
            return true;
        }
        boolean bl = false;
        if (object instanceof Number && ((Number)object).longValue() == 0L) {
            Class clazz = fieldDescriptor.getPersistentField().getType();
            if (clazz != null) {
                bl = clazz.isPrimitive();
            }
        } else if (object instanceof String && ((String)object).length() == 0) {
            bl = fieldDescriptor.isPrimaryKey();
        }
        return bl;
    }

    public boolean hasNullPKField(ClassDescriptor classDescriptor, Object object) {
        FieldDescriptor[] fieldDescriptorArray = classDescriptor.getPkFields();
        boolean bl = false;
        IndirectionHandler indirectionHandler = ProxyHelper.getIndirectionHandler(object);
        if (indirectionHandler == null || indirectionHandler.alreadyMaterialized()) {
            FieldDescriptor fieldDescriptor;
            if (indirectionHandler != null) {
                object = indirectionHandler.getRealSubject();
            }
            for (int i = 0; i < fieldDescriptorArray.length && !(bl = this.representsNull(fieldDescriptor = fieldDescriptorArray[i], fieldDescriptor.getPersistentField().get(object))); ++i) {
            }
        }
        return bl;
    }

    private Object setAutoIncrementValue(FieldDescriptor fieldDescriptor, Object object) {
        PersistentField persistentField = fieldDescriptor.getPersistentField();
        try {
            Object object2 = this.m_broker.serviceSequenceManager().getUniqueValue(fieldDescriptor);
            persistentField.set(object, object2);
            return object2;
        }
        catch (MetadataException metadataException) {
            throw new PersistenceBrokerException("Error while trying to autoincrement field " + persistentField.getDeclaringClass() + REPOSITORY_NAME_SEPARATOR + persistentField.getName(), (Throwable)((Object)metadataException));
        }
        catch (SequenceManagerException sequenceManagerException) {
            throw new PersistenceBrokerException("Could not get key value", (Throwable)((Object)sequenceManagerException));
        }
    }

    public ValueContainer[] getValuesForObject(FieldDescriptor[] fieldDescriptorArray, Object object, boolean bl, boolean bl2) throws PersistenceBrokerException {
        ValueContainer[] valueContainerArray = new ValueContainer[fieldDescriptorArray.length];
        for (int i = 0; i < fieldDescriptorArray.length; ++i) {
            FieldDescriptor fieldDescriptor = fieldDescriptorArray[i];
            Object object2 = fieldDescriptor.getPersistentField().get(object);
            if (bl2 && fieldDescriptor.isAutoIncrement() && this.representsNull(fieldDescriptor, object2)) {
                object2 = this.setAutoIncrementValue(fieldDescriptor, object);
            }
            if (bl) {
                object2 = fieldDescriptor.getFieldConversion().javaToSql(object2);
            }
            valueContainerArray[i] = new ValueContainer(object2, fieldDescriptor.getJdbcType());
        }
        return valueContainerArray;
    }

    public ValueContainer[] getValuesForObject(FieldDescriptor[] fieldDescriptorArray, Object object, boolean bl) throws PersistenceBrokerException {
        return this.getValuesForObject(fieldDescriptorArray, object, bl, false);
    }

    public ValueContainer[] getNonKeyRwValues(ClassDescriptor classDescriptor, Object object) throws PersistenceBrokerException {
        return this.getValuesForObject(classDescriptor.getNonPkRwFields(), object, true);
    }

    public ValueContainer[] getAllRwValues(ClassDescriptor classDescriptor, Object object) throws PersistenceBrokerException {
        return this.getValuesForObject(classDescriptor.getAllRwFields(), object, true);
    }

    public Object[] extractValueArray(ValueContainer[] valueContainerArray) {
        Object[] objectArray = new Object[valueContainerArray.length];
        for (int i = 0; i < valueContainerArray.length; ++i) {
            objectArray[i] = valueContainerArray[i].getValue();
        }
        return objectArray;
    }

    public boolean assertValidPksForStore(FieldDescriptor[] fieldDescriptorArray, Object[] objectArray) {
        int n = fieldDescriptorArray.length;
        for (int i = 0; i < n; ++i) {
            FieldDescriptor fieldDescriptor = fieldDescriptorArray[i];
            if (fieldDescriptor.isAutoIncrement() || fieldDescriptor.isLocking() || !this.representsNull(fieldDescriptor, objectArray[i])) continue;
            return false;
        }
        return true;
    }

    public boolean assertValidPkForDelete(ClassDescriptor classDescriptor, Object object) {
        if (!ProxyHelper.isProxy(object)) {
            for (FieldDescriptor fieldDescriptor : classDescriptor.getPkFields()) {
                Object object2 = fieldDescriptor.getPersistentField().get(object);
                if (!this.representsNull(fieldDescriptor, object2)) continue;
                return false;
            }
        }
        return true;
    }

    public Query getCountQuery(Query query) {
        if (query instanceof QueryBySQL) {
            return this.getQueryBySqlCount((QueryBySQL)query);
        }
        if (query instanceof ReportQueryByCriteria) {
            return this.getReportQueryByCriteriaCount((ReportQueryByCriteria)query);
        }
        return this.getQueryByCriteriaCount((QueryByCriteria)query);
    }

    private Query getQueryBySqlCount(QueryBySQL queryBySQL) {
        int n;
        String string = queryBySQL.getSql();
        int n2 = string.toUpperCase().indexOf(" FROM ");
        if (n2 >= 0) {
            string = "select count(*)" + string.substring(n2);
        }
        if ((n = string.toUpperCase().indexOf(" ORDER BY ")) >= 0) {
            string = string.substring(0, n);
        }
        return new QueryBySQL(queryBySQL.getSearchClass(), string);
    }

    private Query getQueryByCriteriaCount(QueryByCriteria queryByCriteria) {
        int n;
        Object object4;
        Object object2;
        Class clazz = queryByCriteria.getSearchClass();
        Object object3 = null;
        Criteria criteria = null;
        String[] stringArray = new String[1];
        if (queryByCriteria.getCriteria() != null) {
            criteria = queryByCriteria.getCriteria().copy(false, false, false);
        }
        if (queryByCriteria.isDistinct()) {
            object2 = this.m_broker.getClassDescriptor(clazz).getPkFields();
            object4 = new String[((FieldDescriptor[])object2).length];
            if (((FieldDescriptor[])object2).length > 1) {
                for (n = 0; n < ((FieldDescriptor[])object2).length; ++n) {
                    object4[n] = ((FieldDescriptor)object2[n]).getColumnName();
                }
            } else {
                for (n = 0; n < ((FieldDescriptor[])object2).length; ++n) {
                    object4[n] = ((AttributeDescriptorBase)object2[n]).getAttributeName();
                }
            }
            stringArray[0] = "count(distinct " + this.getPlatform().concatenate((String[])object4) + ")";
        } else {
            stringArray[0] = "count(*)";
        }
        if (queryByCriteria instanceof MtoNQuery) {
            object2 = (MtoNQuery)((Object)queryByCriteria);
            object4 = new ReportQueryByMtoNCriteria(clazz, stringArray, criteria);
            ((ReportQueryByMtoNCriteria)object4).setIndirectionTable(object2.getIndirectionTable());
            object3 = object4;
        } else {
            object3 = new ReportQueryByCriteria(clazz, stringArray, criteria);
        }
        for (Object object4 : queryByCriteria.getOuterJoinPaths()) {
            if (!queryByCriteria.isPathOuterJoin((String)object4)) continue;
            ((QueryByCriteria)object3).setPathOuterJoin((String)object4);
        }
        object2 = queryByCriteria.getOrderBy();
        if (object2 != null && !object2.isEmpty()) {
            object4 = new String[object2.size()];
            for (n = 0; n < object2.size(); ++n) {
                object4[n] = ((FieldHelper)object2.get((int)n)).name;
            }
            ((ReportQueryByCriteria)object3).setJoinAttributes((String[])object4);
        }
        return object3;
    }

    private Query getReportQueryByCriteriaCount(ReportQueryByCriteria reportQueryByCriteria) {
        ReportQueryByCriteria reportQueryByCriteria2 = (ReportQueryByCriteria)this.getQueryByCriteriaCount(reportQueryByCriteria);
        reportQueryByCriteria2.setJoinAttributes(reportQueryByCriteria.getAttributes());
        Iterator iterator = reportQueryByCriteria.getGroupBy().iterator();
        while (iterator.hasNext()) {
            reportQueryByCriteria2.addGroupBy((FieldHelper)iterator.next());
        }
        return reportQueryByCriteria2;
    }

    private Platform getPlatform() {
        return this.m_broker.serviceSqlGenerator().getPlatform();
    }

    public boolean doesExist(ClassDescriptor classDescriptor, Identity identity, Object object) {
        boolean bl = false;
        String string = (String)this.sqlSelectMap.get(classDescriptor);
        if (string == null) {
            string = new SqlExistStatement(classDescriptor, LoggerFactory.getDefaultLogger()).getStatement();
            this.sqlSelectMap.put(classDescriptor, string);
        }
        ValueContainer[] valueContainerArray = identity == null ? this.getKeyValues(classDescriptor, object, true) : this.getKeyValues(classDescriptor, identity);
        StatementManagerIF statementManagerIF = this.m_broker.serviceStatementManager();
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        try {
            preparedStatement = statementManagerIF.getPreparedStatement(classDescriptor, string, false, 1, false);
            statementManagerIF.bindValues(preparedStatement, valueContainerArray, 1);
            resultSet = preparedStatement.executeQuery();
            bl = resultSet.next();
            statementManagerIF.closeResources(preparedStatement, resultSet);
        }
        catch (SQLException sQLException) {
            try {
                throw ExceptionHelper.generateException("[BrokerHelper#doesExist] Can't check if specified object is already persisted", sQLException, string, classDescriptor, valueContainerArray, null, object);
            }
            catch (Throwable throwable) {
                statementManagerIF.closeResources(preparedStatement, resultSet);
                throw throwable;
            }
        }
        return bl;
    }

    public void link(Object object, boolean bl) {
        this.linkOrUnlink(true, object, bl);
    }

    public void unlink(Object object) {
        this.linkOrUnlink(false, object, false);
    }

    private void linkOrUnlink(boolean bl, Object object, boolean bl2) {
        ClassDescriptor classDescriptor = this.m_broker.getDescriptorRepository().getDescriptorFor(object.getClass());
        if (classDescriptor.getObjectReferenceDescriptors().size() > 0) {
            for (ObjectReferenceDescriptor objectReferenceDescriptor : classDescriptor.getObjectReferenceDescriptors()) {
                this.linkOrUnlinkOneToOne(bl, object, objectReferenceDescriptor, bl2);
            }
        }
        if (classDescriptor.getCollectionDescriptors().size() > 0) {
            for (ObjectReferenceDescriptor objectReferenceDescriptor : classDescriptor.getCollectionDescriptors()) {
                this.linkOrUnlinkXToMany(bl, object, (CollectionDescriptor)objectReferenceDescriptor, bl2);
            }
        }
    }

    public void link(Object object, ObjectReferenceDescriptor objectReferenceDescriptor, boolean bl) {
        this.linkOrUnlink(true, object, objectReferenceDescriptor, bl);
    }

    public boolean link(Object object, String string, boolean bl) {
        return this.linkOrUnlink(true, object, string, bl);
    }

    public boolean link(Object object, String string, Object object2, boolean bl) {
        ClassDescriptor classDescriptor = this.m_broker.getDescriptorRepository().getDescriptorFor(ProxyHelper.getRealClass(object));
        boolean bl2 = false;
        ObjectReferenceDescriptor objectReferenceDescriptor = classDescriptor.getObjectReferenceDescriptorByName(string);
        if (objectReferenceDescriptor != null) {
            this.linkOrUnlinkOneToOne(true, object, objectReferenceDescriptor, bl);
            bl2 = true;
        } else {
            CollectionDescriptor collectionDescriptor = classDescriptor.getCollectionDescriptorByName(string);
            if (collectionDescriptor != null) {
                this.linkOrUnlinkXToMany(true, object, collectionDescriptor, bl);
                bl2 = true;
            }
        }
        return bl2;
    }

    public boolean unlink(Object object, String string, Object object2) {
        return this.linkOrUnlink(false, object, string, false);
    }

    public boolean unlink(Object object, String string) {
        return this.linkOrUnlink(false, object, string, false);
    }

    public void unlink(Object object, ObjectReferenceDescriptor objectReferenceDescriptor, boolean bl) {
        this.linkOrUnlink(false, object, objectReferenceDescriptor, bl);
    }

    private boolean linkOrUnlink(boolean bl, Object object, String string, boolean bl2) {
        boolean bl3 = false;
        ClassDescriptor classDescriptor = this.m_broker.getDescriptorRepository().getDescriptorFor(ProxyHelper.getRealClass(object));
        ObjectReferenceDescriptor objectReferenceDescriptor = classDescriptor.getObjectReferenceDescriptorByName(string);
        if (objectReferenceDescriptor != null) {
            this.linkOrUnlinkOneToOne(bl, object, objectReferenceDescriptor, bl2);
            bl3 = true;
        } else {
            CollectionDescriptor collectionDescriptor = classDescriptor.getCollectionDescriptorByName(string);
            if (collectionDescriptor != null) {
                this.linkOrUnlinkXToMany(bl, object, collectionDescriptor, bl2);
                bl3 = true;
            }
        }
        return bl3;
    }

    private void linkOrUnlink(boolean bl, Object object, ObjectReferenceDescriptor objectReferenceDescriptor, boolean bl2) {
        if (objectReferenceDescriptor instanceof CollectionDescriptor) {
            this.linkOrUnlinkXToMany(bl, object, (CollectionDescriptor)objectReferenceDescriptor, bl2);
        } else {
            this.linkOrUnlinkOneToOne(bl, object, objectReferenceDescriptor, bl2);
        }
    }

    private void linkOrUnlinkXToMany(boolean bl, Object object, CollectionDescriptor collectionDescriptor, boolean bl2) {
        if (bl) {
            if (collectionDescriptor.isMtoNRelation()) {
                this.m_broker.linkMtoN(object, collectionDescriptor, bl2);
            } else {
                this.m_broker.linkOneToMany(object, collectionDescriptor, bl2);
            }
        } else {
            this.m_broker.unlinkXtoN(object, collectionDescriptor);
        }
    }

    private void linkOrUnlinkOneToOne(boolean bl, Object object, ObjectReferenceDescriptor objectReferenceDescriptor, boolean bl2) {
        ClassDescriptor classDescriptor = objectReferenceDescriptor.getClassDescriptor();
        if (classDescriptor.isInterface()) {
            classDescriptor = this.m_broker.getDescriptorRepository().getDescriptorFor(ProxyHelper.getRealClass(object));
        }
        if (bl) {
            this.m_broker.linkOneToOne(object, classDescriptor, objectReferenceDescriptor, bl2);
        } else {
            this.m_broker.unlinkFK(object, classDescriptor, objectReferenceDescriptor);
            objectReferenceDescriptor.getPersistentField().set(object, null);
        }
    }

    public void unlink(Object object, CollectionDescriptor collectionDescriptor, List list) {
        for (int i = 0; i < list.size(); ++i) {
            this.unlink(object, collectionDescriptor, list.get(i));
        }
    }

    public void unlink(Object object, CollectionDescriptor collectionDescriptor, Object object2) {
        if (collectionDescriptor.isMtoNRelation()) {
            this.m_broker.deleteMtoNImplementor(new MtoNImplementor(collectionDescriptor, object, object2));
        } else {
            ClassDescriptor classDescriptor = this.m_broker.getClassDescriptor(object2.getClass());
            this.m_broker.unlinkFK(object2, classDescriptor, collectionDescriptor);
        }
    }

    public void link(Object object, CollectionDescriptor collectionDescriptor, List list) {
        for (int i = 0; i < list.size(); ++i) {
            this.link(object, collectionDescriptor, list.get(i));
        }
    }

    public void link(Object object, CollectionDescriptor collectionDescriptor, Object object2) {
        if (collectionDescriptor.isMtoNRelation()) {
            this.m_broker.addMtoNImplementor(new MtoNImplementor(collectionDescriptor, object, object2));
        } else {
            ClassDescriptor classDescriptor = this.m_broker.getClassDescriptor(object2.getClass());
            this.m_broker.link(object2, classDescriptor, collectionDescriptor, object, false);
        }
    }

    public static Iterator getCollectionIterator(Object object) {
        ArrayIterator arrayIterator;
        if (object instanceof ManageableCollection) {
            arrayIterator = ((ManageableCollection)object).ojbIterator();
        } else if (object instanceof Collection) {
            arrayIterator = ((Collection)object).iterator();
        } else if (object.getClass().isArray()) {
            arrayIterator = new ArrayIterator(object);
        } else {
            throw new OJBRuntimeException("Given object collection of type '" + (object != null ? object.getClass().toString() : "null") + "' can not be managed by OJB. Use Array, Collection or ManageableCollection instead!");
        }
        return arrayIterator;
    }

    public static Object[] getCollectionArray(Object object) {
        Object[] objectArray;
        if (object instanceof Collection) {
            objectArray = ((Collection)object).toArray();
        } else if (object instanceof ManageableCollection) {
            ArrayList arrayList = new ArrayList();
            CollectionUtils.addAll(arrayList, (Iterator)((ManageableCollection)object).ojbIterator());
            objectArray = arrayList.toArray();
        } else if (object.getClass().isArray()) {
            objectArray = (Object[])object;
        } else {
            throw new OJBRuntimeException("Given object collection of type '" + (object != null ? object.getClass().toString() : "null") + "' can not be managed by OJB. Use Array, Collection or ManageableCollection instead!");
        }
        return objectArray;
    }

    public static boolean hasAnonymousKeyReference(ClassDescriptor classDescriptor, ObjectReferenceDescriptor objectReferenceDescriptor) {
        boolean bl = false;
        FieldDescriptor[] fieldDescriptorArray = objectReferenceDescriptor.getForeignKeyFieldDescriptors(classDescriptor);
        for (int i = 0; i < fieldDescriptorArray.length; ++i) {
            FieldDescriptor fieldDescriptor = fieldDescriptorArray[i];
            if (!fieldDescriptor.isAnonymous()) continue;
            bl = true;
            break;
        }
        return bl;
    }
}

