/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ojb.broker.util.collections;

import java.util.Iterator;
import java.util.Vector;
import org.apache.ojb.broker.PersistenceBroker;
import org.apache.ojb.broker.PersistenceBrokerException;
import org.apache.ojb.broker.util.collections.IRemovalAwareCollection;
import org.apache.ojb.broker.util.collections.ManageableHashSet;

public class RemovalAwareSet
extends ManageableHashSet
implements IRemovalAwareCollection {
    private Vector allObjectsToBeRemoved = new Vector();

    @Override
    public void afterStore(PersistenceBroker persistenceBroker) throws PersistenceBrokerException {
        this.allObjectsToBeRemoved.removeAll(this);
        Iterator iterator = this.allObjectsToBeRemoved.iterator();
        while (iterator.hasNext()) {
            persistenceBroker.delete(iterator.next());
        }
        this.allObjectsToBeRemoved.clear();
    }

    protected void registerForDeletion(Object object) {
        if (!this.allObjectsToBeRemoved.contains(object)) {
            this.allObjectsToBeRemoved.add(object);
        }
    }

    @Override
    public boolean remove(Object object) {
        boolean bl = super.remove(object);
        this.registerForDeletion(object);
        return bl;
    }

    public synchronized void removeAllElements() {
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            this.registerForDeletion(iterator.next());
        }
        super.clear();
    }

    @Override
    public synchronized void clear() {
        this.removeAllElements();
    }

    public void resetDeleted() {
        this.allObjectsToBeRemoved.clear();
    }
}

