/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ojb.broker.util.dbhandling;

import java.io.IOException;
import java.util.ArrayList;
import java.util.StringTokenizer;
import org.apache.ojb.broker.PBKey;
import org.apache.ojb.broker.PersistenceBrokerFactory;
import org.apache.ojb.broker.metadata.ConnectionRepository;
import org.apache.ojb.broker.metadata.MetadataManager;
import org.apache.ojb.broker.util.ClassHelper;
import org.apache.ojb.broker.util.dbhandling.DBHandling;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.types.FileSet;

public class DBHandlingTask
extends Task {
    private static final String HANDLING_TORQUE = "torque";
    private static final String COMMAND_CREATE = "create";
    private static final String COMMAND_INIT = "init";
    private String _handling = "torque";
    private String _propertiesFile = null;
    private String _jcdAlias = null;
    private String _workDir = null;
    private ArrayList _fileSets = new ArrayList();
    private String _commands = "";

    public void setHandling(String string) {
        this._handling = string == null ? HANDLING_TORQUE : string.toLowerCase();
    }

    public String getHandling() {
        return this._handling;
    }

    public void setPropertiesFile(String string) {
        this._propertiesFile = string;
    }

    public String getPropertiesFile() {
        return this._propertiesFile;
    }

    public void setJcdAlias(String string) {
        this._jcdAlias = string;
    }

    public String getJcdAlias() {
        return this._jcdAlias;
    }

    public void setWorkDir(String string) {
        this._workDir = string;
    }

    public String getWorkDir() {
        return this._workDir;
    }

    public void addFileset(FileSet fileSet) {
        this._fileSets.add(fileSet);
    }

    public void setCommands(String string) {
        this._commands = string;
    }

    public String getCommands() {
        return this._commands;
    }

    public void execute() throws BuildException {
        if (this._commands == null || this._commands.length() == 0) {
            return;
        }
        DBHandling dBHandling = this.createDBHandling();
        try {
            if (this._workDir != null && this._workDir.length() > 0) {
                dBHandling.setWorkDir(this._workDir);
                System.setProperty("user.dir", this._workDir);
            }
            Object object = this._fileSets.iterator();
            while (object.hasNext()) {
                this.addIncludes(dBHandling, (FileSet)object.next());
            }
            if (this._propertiesFile != null && this._propertiesFile.length() > 0) {
                System.setProperty("OJB.properties", this._propertiesFile);
            }
            object = MetadataManager.getInstance().connectionRepository();
            PBKey pBKey = null;
            if (this._jcdAlias == null || this._jcdAlias.length() == 0) {
                pBKey = PersistenceBrokerFactory.getDefaultKey();
            } else {
                pBKey = ((ConnectionRepository)object).getStandardPBKeyForJcdAlias(this._jcdAlias);
                if (pBKey == null) {
                    throw new BuildException("Undefined jcdAlias " + this._jcdAlias);
                }
            }
            dBHandling.setConnection(((ConnectionRepository)object).getDescriptor(pBKey));
            StringTokenizer stringTokenizer = new StringTokenizer(this._commands, ",");
            while (stringTokenizer.hasMoreTokens()) {
                String string = stringTokenizer.nextToken().toLowerCase().trim();
                if (COMMAND_CREATE.equals(string)) {
                    dBHandling.createDB();
                    continue;
                }
                if (COMMAND_INIT.equals(string)) {
                    dBHandling.initDB();
                    continue;
                }
                throw new BuildException("Unknown command " + string);
            }
        }
        catch (Exception exception) {
            throw new BuildException((Throwable)exception);
        }
    }

    private DBHandling createDBHandling() throws BuildException {
        if (this._handling == null || this._handling.length() == 0) {
            throw new BuildException("No handling specified");
        }
        try {
            String string = "org.apache.ojb.broker.platforms." + Character.toTitleCase(this._handling.charAt(0)) + this._handling.substring(1) + "DBHandling";
            Class clazz = ClassHelper.getClass(string);
            return (DBHandling)clazz.newInstance();
        }
        catch (Exception exception) {
            throw new BuildException("Invalid handling '" + this._handling + "' specified");
        }
    }

    private void addIncludes(DBHandling dBHandling, FileSet fileSet) throws BuildException {
        DirectoryScanner directoryScanner = fileSet.getDirectoryScanner(this.getProject());
        String[] stringArray = directoryScanner.getIncludedFiles();
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < stringArray.length; ++i) {
            if (i > 0) {
                stringBuffer.append(",");
            }
            stringBuffer.append(stringArray[i]);
        }
        try {
            dBHandling.addDBDefinitionFiles(fileSet.getDir(this.getProject()).getAbsolutePath(), stringBuffer.toString());
        }
        catch (IOException iOException) {
            throw new BuildException((Throwable)iOException);
        }
    }
}

