/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ojb.odmg;

import org.apache.ojb.broker.PBKey;
import org.apache.ojb.broker.PersistenceBroker;
import org.apache.ojb.broker.PersistenceBrokerFactory;
import org.apache.ojb.broker.util.BrokerHelper;
import org.apache.ojb.broker.util.logging.Logger;
import org.apache.ojb.broker.util.logging.LoggerFactory;
import org.apache.ojb.odmg.ImplementationImpl;
import org.apache.ojb.odmg.NarrowTransaction;
import org.apache.ojb.odmg.RuntimeObject;
import org.apache.ojb.odmg.TransactionImpl;
import org.apache.ojb.odmg.TxUtil;
import org.odmg.Database;
import org.odmg.DatabaseClosedException;
import org.odmg.DatabaseOpenException;
import org.odmg.ODMGException;
import org.odmg.ObjectNameNotFoundException;
import org.odmg.ObjectNameNotUniqueException;
import org.odmg.Transaction;
import org.odmg.TransactionInProgressException;
import org.odmg.TransactionNotInProgressException;

public class DatabaseImpl
implements Database {
    private Logger log = LoggerFactory.getLogger(DatabaseImpl.class);
    private PBKey pbKey;
    private boolean isOpen = false;
    private ImplementationImpl odmg;

    public DatabaseImpl(ImplementationImpl implementationImpl) {
        this.odmg = implementationImpl;
    }

    private TransactionImpl getTransaction() {
        Transaction transaction = this.odmg.currentTransaction();
        if (transaction instanceof NarrowTransaction) {
            return ((NarrowTransaction)transaction).getRealTransaction();
        }
        return (TransactionImpl)transaction;
    }

    public PBKey getPBKey() {
        if (this.pbKey == null) {
            this.log.error("## PBKey not set, Database isOpen=" + this.isOpen + " ##");
            if (!this.isOpen) {
                throw new DatabaseClosedException("Database is not open");
            }
        }
        return this.pbKey;
    }

    public boolean isOpen() {
        return this.isOpen;
    }

    @Override
    public synchronized void open(String string, int n) throws ODMGException {
        if (this.isOpen()) {
            throw new DatabaseOpenException("Database is already open");
        }
        try (PersistenceBroker persistenceBroker = null;){
            if (string == null) {
                this.log.info("Given argument was 'null', open default database");
                persistenceBroker = PersistenceBrokerFactory.defaultPersistenceBroker();
            } else {
                persistenceBroker = PersistenceBrokerFactory.createPersistenceBroker(BrokerHelper.extractAllTokens(string));
            }
            this.pbKey = persistenceBroker.getPBKey();
            this.isOpen = true;
            this.odmg.registerOpenDatabase(this);
            if (this.log.isDebugEnabled()) {
                this.log.debug("Open database using PBKey " + this.pbKey);
            }
        }
    }

    @Override
    public void close() throws ODMGException {
        if (!this.isOpen()) {
            throw new DatabaseClosedException("Database is not Open. Must have an open DB to call close.");
        }
        if (this.odmg.hasOpenTransaction() && this.getTransaction().getAssociatedDatabase().equals(this)) {
            String string = "Database cannot be closed, associated Tx is still open. Transaction status is '" + TxUtil.getStatusString(this.getTransaction().getStatus()) + "'." + " Used PBKey was " + this.getTransaction().getBroker().getPBKey();
            this.log.error(string);
            throw new TransactionInProgressException(string);
        }
        this.isOpen = false;
        this.pbKey = null;
        if (this == this.odmg.getCurrentDatabase()) {
            this.odmg.setCurrentDatabase(null);
        }
    }

    @Override
    public void bind(Object object, String string) throws ObjectNameNotUniqueException {
        if (!this.isOpen()) {
            throw new DatabaseClosedException("Database is not open. Must have an open DB to call bind.");
        }
        TransactionImpl transactionImpl = this.getTransaction();
        if (transactionImpl == null || !transactionImpl.isOpen()) {
            throw new TransactionNotInProgressException("Tx is not open. Must have an open TX to call bind.");
        }
        transactionImpl.getNamedRootsMap().bind(object, string);
    }

    @Override
    public Object lookup(String string) throws ObjectNameNotFoundException {
        if (!this.isOpen()) {
            throw new DatabaseClosedException("Database is not open. Must have an open DB to call lookup");
        }
        TransactionImpl transactionImpl = this.getTransaction();
        if (transactionImpl == null || !transactionImpl.isOpen()) {
            throw new TransactionNotInProgressException("Tx is not open. Must have an open TX to call lookup.");
        }
        return transactionImpl.getNamedRootsMap().lookup(string);
    }

    @Override
    public void unbind(String string) throws ObjectNameNotFoundException {
        if (!this.isOpen()) {
            throw new DatabaseClosedException("Database is not open. Must have an open DB to call unbind");
        }
        TransactionImpl transactionImpl = this.getTransaction();
        if (transactionImpl == null || !transactionImpl.isOpen()) {
            throw new TransactionNotInProgressException("Tx is not open. Must have an open TX to call lookup.");
        }
        transactionImpl.getNamedRootsMap().unbind(string);
    }

    @Override
    public void makePersistent(Object object) {
        if (!this.isOpen()) {
            throw new DatabaseClosedException("Database is not open");
        }
        TransactionImpl transactionImpl = this.getTransaction();
        if (transactionImpl == null || !transactionImpl.isOpen()) {
            throw new TransactionNotInProgressException("No transaction in progress, cannot persist");
        }
        RuntimeObject runtimeObject = new RuntimeObject(object, this.getTransaction());
        transactionImpl.makePersistent(runtimeObject);
    }

    @Override
    public void deletePersistent(Object object) {
        if (!this.isOpen()) {
            throw new DatabaseClosedException("Database is not open");
        }
        TransactionImpl transactionImpl = this.getTransaction();
        if (transactionImpl == null || !transactionImpl.isOpen()) {
            throw new TransactionNotInProgressException("No transaction in progress, cannot delete persistent");
        }
        RuntimeObject runtimeObject = new RuntimeObject(object, transactionImpl);
        transactionImpl.deletePersistent(runtimeObject);
    }
}

