/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.pqc.crypto.xmss;

import java.security.SecureRandom;
import org.bouncycastle.crypto.Digest;
import org.bouncycastle.pqc.crypto.xmss.DefaultXMSSMTOid;
import org.bouncycastle.pqc.crypto.xmss.WOTSPlus;
import org.bouncycastle.pqc.crypto.xmss.XMSS;
import org.bouncycastle.pqc.crypto.xmss.XMSSOid;
import org.bouncycastle.pqc.crypto.xmss.XMSSParameters;

public final class XMSSMTParameters {
    private final XMSSOid oid;
    private final XMSS xmss;
    private final int height;
    private final int layers;

    public XMSSMTParameters(int n, int n2, Digest digest, SecureRandom secureRandom) {
        this.height = n;
        this.layers = n2;
        this.xmss = new XMSS(new XMSSParameters(XMSSMTParameters.xmssTreeHeight(n, n2), digest, secureRandom));
        this.oid = DefaultXMSSMTOid.lookup(this.getDigest().getAlgorithmName(), this.getDigestSize(), this.getWinternitzParameter(), this.getLen(), this.getHeight(), n2);
    }

    private static int xmssTreeHeight(int n, int n2) throws IllegalArgumentException {
        if (n < 2) {
            throw new IllegalArgumentException("totalHeight must be > 1");
        }
        if (n % n2 != 0) {
            throw new IllegalArgumentException("layers must divide totalHeight without remainder");
        }
        if (n / n2 == 1) {
            throw new IllegalArgumentException("height / layers must be greater than 1");
        }
        return n / n2;
    }

    public int getHeight() {
        return this.height;
    }

    public int getLayers() {
        return this.layers;
    }

    protected XMSS getXMSS() {
        return this.xmss;
    }

    protected WOTSPlus getWOTSPlus() {
        return this.xmss.getWOTSPlus();
    }

    protected Digest getDigest() {
        return this.xmss.getParams().getDigest();
    }

    public int getDigestSize() {
        return this.xmss.getParams().getDigestSize();
    }

    public int getWinternitzParameter() {
        return this.xmss.getParams().getWinternitzParameter();
    }

    protected int getLen() {
        return this.xmss.getWOTSPlus().getParams().getLen();
    }
}

