/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krad.datadictionary.validation.constraint;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;
import org.kuali.rice.krad.datadictionary.parse.BeanTag;
import org.kuali.rice.krad.datadictionary.parse.BeanTagAttribute;
import org.kuali.rice.krad.datadictionary.validation.constraint.ValidCharactersPatternConstraint;
import org.kuali.rice.krad.datadictionary.validator.ValidationTrace;

@BeanTag(name="charsetPatternConstraint", parent="CharsetPatternConstraint")
public class CharsetPatternConstraint
extends ValidCharactersPatternConstraint {
    protected String validChars;

    @BeanTagAttribute(name="validChars")
    public String getValidChars() {
        return this.validChars;
    }

    public void setValidChars(String validChars) {
        if (StringUtils.isEmpty((String)validChars)) {
            throw new IllegalArgumentException("invalid (empty) validChars");
        }
        this.validChars = validChars;
    }

    @Override
    protected String getRegexString() {
        if (StringUtils.isEmpty((String)this.validChars)) {
            throw new IllegalStateException("validChars is empty");
        }
        Pattern filteringChars = Pattern.compile("([\\-\\[\\]\\{\\}\\$\\.\\^\\(\\)\\*\\&\\|])");
        String filteredChars = filteringChars.matcher(this.validChars).replaceAll("\\\\$1");
        StringBuffer regexString = new StringBuffer("[");
        regexString.append(filteredChars);
        if (filteredChars.endsWith("\\")) {
            regexString.append("\\");
        }
        regexString.append("]");
        return regexString.toString();
    }

    @Override
    public String getMessageKey() {
        String messageKey = super.getMessageKey();
        if (StringUtils.isNotEmpty((String)messageKey)) {
            return messageKey;
        }
        return "validation.charsetPattern";
    }

    @Override
    public List<String> getValidationMessageParams() {
        if (this.validationMessageParams == null) {
            this.validationMessageParams = new ArrayList();
            if (StringUtils.isNotBlank((String)this.validChars)) {
                this.validationMessageParams.add(this.validChars);
            }
        }
        return this.validationMessageParams;
    }

    @Override
    public void completeValidation(ValidationTrace tracer) {
        tracer.addBean("CharsetPatternConstraint", this.getMessageKey());
        if (this.getValidChars() == null) {
            String[] currentValues = new String[]{"validChars =" + this.getValidChars()};
            tracer.createError("ValidChars must be set", currentValues);
        }
        super.completeValidation(tracer.getCopy());
    }
}

