/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krad.datadictionary.validation.constraint;

import java.util.List;
import org.kuali.rice.krad.datadictionary.parse.BeanTag;
import org.kuali.rice.krad.datadictionary.parse.BeanTagAttribute;
import org.kuali.rice.krad.datadictionary.validation.constraint.BaseConstraint;
import org.kuali.rice.krad.datadictionary.validation.constraint.PrerequisiteConstraint;
import org.kuali.rice.krad.datadictionary.validator.ValidationTrace;

@BeanTag(name="mustOccurConstraint", parent="MustOccurConstraint")
public class MustOccurConstraint
extends BaseConstraint {
    private List<PrerequisiteConstraint> prerequisiteConstraints;
    private List<MustOccurConstraint> mustOccurConstraints;
    private Integer min;
    private Integer max;

    @BeanTagAttribute(name="prerequisiteConstraints", type=BeanTagAttribute.AttributeType.LISTBEAN)
    public List<PrerequisiteConstraint> getPrerequisiteConstraints() {
        return this.prerequisiteConstraints;
    }

    public void setPrerequisiteConstraints(List<PrerequisiteConstraint> prerequisiteConstraints) {
        this.prerequisiteConstraints = prerequisiteConstraints;
    }

    @BeanTagAttribute(name="mustOccurConstraints", type=BeanTagAttribute.AttributeType.LISTBEAN)
    public List<MustOccurConstraint> getMustOccurConstraints() {
        return this.mustOccurConstraints;
    }

    public void setMustOccurConstraints(List<MustOccurConstraint> occurs) {
        this.mustOccurConstraints = occurs;
    }

    @BeanTagAttribute(name="min")
    public Integer getMin() {
        return this.min;
    }

    public void setMin(Integer min) {
        this.min = min;
    }

    @BeanTagAttribute(name="max")
    public Integer getMax() {
        return this.max;
    }

    public void setMax(Integer max) {
        this.max = max;
    }

    @Override
    public void completeValidation(ValidationTrace tracer) {
        String[] currentValues;
        tracer.addBean("MustOccurConstraint", this.getMessageKey());
        if (this.getMax() <= 0) {
            currentValues = new String[]{"max =" + this.getMax()};
            tracer.createWarning("Max must be greater than 0", currentValues);
        }
        if (this.getPrerequisiteConstraints() == null) {
            currentValues = new String[]{"prerequisiteConstraints =" + this.getPrerequisiteConstraints()};
            tracer.createWarning("PrerequisiteConstraints cannot be null or empty", currentValues);
        } else if (this.getPrerequisiteConstraints().size() == 0) {
            currentValues = new String[]{"prerequisiteConstraints.size =" + this.getPrerequisiteConstraints().size()};
            tracer.createWarning("PrerequisiteConstraints cannot be null or empty", currentValues);
        } else {
            for (int i = 0; i < this.getPrerequisiteConstraints().size(); ++i) {
                this.getPrerequisiteConstraints().get(i).completeValidation(tracer.getCopy());
            }
        }
        if (this.getMustOccurConstraints() == null) {
            String[] currentValues2 = new String[]{"mustOccurConstraints =" + this.getMustOccurConstraints()};
            tracer.createWarning("MustOccurConstraints cannot be null or empty", currentValues2);
        } else if (this.getMustOccurConstraints().size() == 0) {
            String[] currentValues3 = new String[]{"mustOccurConstraints.size =" + this.getMustOccurConstraints().size()};
            tracer.createWarning("MustOccurConstraints cannot be null or empty", currentValues3);
        } else {
            for (int i = 0; i < this.getMustOccurConstraints().size(); ++i) {
                this.getMustOccurConstraints().get(i).completeValidation(tracer.getCopy());
            }
        }
        super.completeValidation(tracer.getCopy());
    }
}

