/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krad.uif.container;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.kuali.rice.kim.api.identity.Person;
import org.kuali.rice.krad.uif.UifConstants;
import org.kuali.rice.krad.uif.component.BindingInfo;
import org.kuali.rice.krad.uif.component.Component;
import org.kuali.rice.krad.uif.component.ComponentSecurity;
import org.kuali.rice.krad.uif.component.DataBinding;
import org.kuali.rice.krad.uif.container.CollectionGroup;
import org.kuali.rice.krad.uif.container.DialogGroup;
import org.kuali.rice.krad.uif.container.Group;
import org.kuali.rice.krad.uif.container.collections.LineBuilderContext;
import org.kuali.rice.krad.uif.control.Control;
import org.kuali.rice.krad.uif.control.ControlBase;
import org.kuali.rice.krad.uif.element.Action;
import org.kuali.rice.krad.uif.field.DataField;
import org.kuali.rice.krad.uif.field.Field;
import org.kuali.rice.krad.uif.field.FieldGroup;
import org.kuali.rice.krad.uif.field.InputField;
import org.kuali.rice.krad.uif.field.RemoteFieldsHolder;
import org.kuali.rice.krad.uif.layout.CollectionLayoutManager;
import org.kuali.rice.krad.uif.layout.TableLayoutManagerBase;
import org.kuali.rice.krad.uif.lifecycle.ViewLifecycle;
import org.kuali.rice.krad.uif.lifecycle.ViewLifecycleUtils;
import org.kuali.rice.krad.uif.util.ComponentFactory;
import org.kuali.rice.krad.uif.util.ComponentUtils;
import org.kuali.rice.krad.uif.util.ContextUtils;
import org.kuali.rice.krad.uif.util.ObjectPropertyUtils;
import org.kuali.rice.krad.uif.util.ScriptUtils;
import org.kuali.rice.krad.uif.view.ExpressionEvaluator;
import org.kuali.rice.krad.uif.view.View;
import org.kuali.rice.krad.uif.view.ViewAuthorizer;
import org.kuali.rice.krad.uif.view.ViewModel;
import org.kuali.rice.krad.uif.view.ViewPresentationController;
import org.kuali.rice.krad.util.GlobalVariables;
import org.kuali.rice.krad.web.form.UifFormBase;

public class CollectionGroupLineBuilder
implements Serializable {
    private static final long serialVersionUID = 981187437246864378L;
    private LineBuilderContext lineBuilderContext;
    private List<Field> unauthorizedFields = new ArrayList<Field>();

    public CollectionGroupLineBuilder(LineBuilderContext lineBuilderContext) {
        this.lineBuilderContext = lineBuilderContext;
    }

    public void buildLine() {
        boolean hasSubCollections;
        this.preprocessLine();
        boolean hasLineFields = this.lineBuilderContext.getLineFields() != null && !this.lineBuilderContext.getLineFields().isEmpty();
        boolean bl = hasSubCollections = this.lineBuilderContext.getSubCollectionFields() != null && !this.lineBuilderContext.getSubCollectionFields().isEmpty();
        if (hasLineFields || hasSubCollections) {
            if (!this.lineBuilderContext.isAddLine()) {
                this.setupEditLineDetails();
            }
            ArrayList<? extends Component> actions = new ArrayList<Component>();
            actions.addAll(this.lineBuilderContext.getLineActions());
            List<DialogGroup> dialogGroups = this.lineBuilderContext.getCollectionGroup().getLineDialogs();
            if (Boolean.TRUE.equals(this.lineBuilderContext.getCollectionGroup().getReadOnly())) {
                for (DialogGroup group : dialogGroups) {
                    group.setReadOnly(true);
                }
            }
            actions.addAll(dialogGroups);
            this.lineBuilderContext.setLineActions(actions);
            this.lineBuilderContext.getCollectionGroup().getLineDialogs().clear();
            this.lineBuilderContext.getLayoutManager().buildLine(this.lineBuilderContext);
        }
        this.applyOnChangeForSave(this.lineBuilderContext.getLineFields());
    }

    public void preprocessLine() {
        List<? extends Component> lineItems = this.initializeLineItems();
        List<Field> lineFields = this.processAnyRemoteFieldsHolder(this.lineBuilderContext.getCollectionGroup(), lineItems);
        this.adjustFieldBindingAndId(lineFields, this.lineBuilderContext.getBindingPath());
        ContextUtils.updateContextsForLine(lineFields, this.lineBuilderContext.getCollectionGroup(), this.lineBuilderContext.getCurrentLine(), this.lineBuilderContext.getLineIndex(), this.lineBuilderContext.getIdSuffix());
        boolean canViewLine = this.checkViewLineAuthorization();
        if (!canViewLine) {
            return;
        }
        List<Action> actions = ViewLifecycleUtils.getElementsOfTypeDeep(this.lineBuilderContext.getLineActions(), Action.class);
        this.setFocusOnIdForActions(actions, lineFields);
        boolean canEditLine = this.checkEditLineAuthorization(lineFields);
        ContextUtils.pushObjectToContextDeep(lineFields, "readOnlyLine", (Object)(!canEditLine ? 1 : 0));
        ContextUtils.pushObjectToContextDeep(actions, "readOnlyLine", (Object)(!canEditLine ? 1 : 0));
        if (!canEditLine) {
            Iterator<Action> actionsIterator = actions.iterator();
            while (actionsIterator.hasNext()) {
                Action action = actionsIterator.next();
                if (!action.getId().startsWith("Uif-EditLineInDialogAction_" + this.lineBuilderContext.getCollectionGroup().getId())) continue;
                actionsIterator.remove();
                break;
            }
            this.lineBuilderContext.setLineActions(actions);
        }
        this.applyLineFieldAuthorizationAndPresentationLogic(!canEditLine, lineFields, actions);
        lineFields = this.removeNonRenderLineFields(lineFields);
        this.buildSubCollectionFieldGroups();
        List<Action> lineFieldActions = ViewLifecycleUtils.getElementsOfTypeDeep(lineFields, Action.class);
        if (lineFieldActions != null) {
            this.lineBuilderContext.getCollectionGroup().getCollectionGroupBuilder().initializeActions(lineFieldActions, this.lineBuilderContext.getCollectionGroup(), this.lineBuilderContext.getLineIndex());
        }
        this.setupAddLineControlValidation(lineFields);
        this.lineBuilderContext.setLineFields(lineFields);
    }

    protected List<? extends Component> initializeLineItems() {
        List<? extends Component> lineItems = this.lineBuilderContext.isAddLine() ? ComponentUtils.copyComponentList(this.lineBuilderContext.getCollectionGroup().getAddLineItems(), null) : ComponentUtils.copyComponentList(this.lineBuilderContext.getCollectionGroup().getItems(), null);
        return lineItems;
    }

    public List<Field> processAnyRemoteFieldsHolder(CollectionGroup group, List<? extends Component> items) {
        ArrayList<Field> processedItems = new ArrayList<Field>();
        for (Component component : items) {
            if (component instanceof RemoteFieldsHolder) {
                List<InputField> translatedFields = ((RemoteFieldsHolder)component).fetchAndTranslateRemoteFields(group);
                processedItems.addAll(translatedFields);
                continue;
            }
            if (!(component instanceof Field)) continue;
            processedItems.add((Field)component);
        }
        return processedItems;
    }

    protected void adjustFieldBindingAndId(List<Field> lineFields, String bindingPath) {
        for (Field lineField : lineFields) {
            this.adjustFieldBinding(lineField, bindingPath);
            this.adjustFieldId(lineField);
        }
        if (this.lineBuilderContext.isBindToForm()) {
            ComponentUtils.setComponentsPropertyDeep(lineFields, "bindingInfo.bindToForm", true);
        }
    }

    protected void adjustFieldBinding(Field lineField, String bindingPath) {
        if (lineField instanceof DataBinding && ((DataBinding)((Object)lineField)).getBindingInfo().isBindToForm()) {
            BindingInfo bindingInfo = ((DataBinding)((Object)lineField)).getBindingInfo();
            bindingInfo.setCollectionPath(null);
            bindingInfo.setBindingName(bindingInfo.getBindingName() + "[" + this.lineBuilderContext.getLineIndex() + "]");
        } else {
            ComponentUtils.prefixBindingPath(lineField, bindingPath);
        }
    }

    protected void adjustFieldId(Field lineField) {
        ComponentUtils.updateIdWithSuffix(lineField, this.lineBuilderContext.getIdSuffix());
        lineField.setContainerIdSuffix(this.lineBuilderContext.getIdSuffix());
    }

    protected void setFocusOnIdForActions(List<Action> actions, List<Field> lineFields) {
        for (Action action : actions) {
            boolean lineHasFields;
            if (action == null) continue;
            boolean focusLineFirst = StringUtils.isNotBlank((String)action.getFocusOnIdAfterSubmit()) && action.getFocusOnIdAfterSubmit().equalsIgnoreCase(UifConstants.Order.LINE_FIRST.toString());
            boolean bl = lineHasFields = !lineFields.isEmpty();
            if (!focusLineFirst || !lineHasFields) continue;
            action.setFocusOnIdAfterSubmit(lineFields.get(0).getId() + "_control");
        }
    }

    protected void applyOnChangeForSave(List<Field> lineFields) {
        boolean isLineNewlyAdded = ((UifFormBase)this.lineBuilderContext.getModel()).isAddedCollectionItem(this.lineBuilderContext.getCurrentLine());
        boolean saveLineEnabled = this.lineBuilderContext.getCollectionGroup().isRenderSaveLineActions();
        if (!isLineNewlyAdded && !saveLineEnabled) {
            return;
        }
        for (Field field : lineFields) {
            boolean isInputField = field instanceof InputField;
            if (field.isHidden() || Boolean.TRUE.equals(field.getReadOnly()) || !isInputField) continue;
            InputField inputField = (InputField)field;
            if (inputField.getControl() == null) {
                inputField.setControl(ComponentFactory.getTextControl());
            }
            ControlBase control = (ControlBase)((InputField)field).getControl();
            String onBlurScript = "collectionLineChanged(this, 'uif-newCollectionItem');";
            onBlurScript = ScriptUtils.appendScript(control.getOnBlurScript(), onBlurScript);
            control.setOnBlurScript(onBlurScript);
        }
    }

    protected List<Field> removeNonRenderLineFields(List<Field> lineFields) {
        ArrayList<Field> fields = new ArrayList<Field>();
        ExpressionEvaluator expressionEvaluator = ViewLifecycle.getExpressionEvaluator();
        for (Field lineField : lineFields) {
            String conditionalRender = lineField.getPropertyExpression("render");
            if (StringUtils.isNotBlank((String)conditionalRender)) {
                Map<String, Object> context = this.getContextForField(ViewLifecycle.getView(), this.lineBuilderContext.getCollectionGroup(), lineField);
                conditionalRender = expressionEvaluator.replaceBindingPrefixes(ViewLifecycle.getView(), lineField, conditionalRender);
                Boolean render = (Boolean)expressionEvaluator.evaluateExpression(context, conditionalRender);
                lineField.setRender(render);
            }
            if (!lineField.isRender() && !StringUtils.isNotBlank((String)lineField.getProgressiveRender())) continue;
            fields.add(lineField);
        }
        return fields;
    }

    protected boolean checkViewLineAuthorization() {
        boolean canViewLine = true;
        if (!this.lineBuilderContext.isAddLine()) {
            canViewLine = this.checkViewLineAuthorizationAndPresentationLogic();
        }
        if (!canViewLine) {
            this.addUnauthorizedBindingInfo();
        }
        return canViewLine;
    }

    protected boolean checkViewLineAuthorizationAndPresentationLogic() {
        ViewPresentationController presentationController = ViewLifecycle.getView().getPresentationController();
        ViewAuthorizer authorizer = ViewLifecycle.getView().getAuthorizer();
        Person user = GlobalVariables.getUserSession().getPerson();
        CollectionGroup collectionGroup = this.lineBuilderContext.getCollectionGroup();
        boolean canViewLine = authorizer.canViewLine(ViewLifecycle.getView(), this.lineBuilderContext.getModel(), collectionGroup, collectionGroup.getPropertyName(), this.lineBuilderContext.getCurrentLine(), user);
        if (canViewLine) {
            canViewLine = presentationController.canViewLine(ViewLifecycle.getView(), this.lineBuilderContext.getModel(), collectionGroup, collectionGroup.getPropertyName(), this.lineBuilderContext.getCurrentLine());
        }
        return canViewLine;
    }

    protected boolean checkEditLineAuthorization(List<Field> lineFields) {
        boolean canEditLine;
        boolean bl = canEditLine = !Boolean.TRUE.equals(this.lineBuilderContext.getCollectionGroup().getReadOnly());
        if (!canEditLine) {
            ExpressionEvaluator expressionEvaluator = ViewLifecycle.getExpressionEvaluator();
            View view = ViewLifecycle.getView();
            for (Field field : lineFields) {
                field.pushObjectToContext("parent", this.lineBuilderContext.getCollectionGroup());
                field.pushAllToContext(view.getContext());
                field.pushObjectToContext("component", field);
                expressionEvaluator.evaluatePropertyExpression(view, field.getContext(), field, "readOnly", true);
                if (Boolean.TRUE.equals(field.getReadOnly())) continue;
                canEditLine = true;
                break;
            }
        }
        if (canEditLine && !this.lineBuilderContext.isAddLine()) {
            canEditLine = this.checkEditLineAuthorizationAndPresentationLogic(this.lineBuilderContext.getCollectionGroup(), this.lineBuilderContext.getModel(), this.lineBuilderContext.getCurrentLine());
        }
        if (!canEditLine) {
            this.addUnauthorizedBindingInfo();
        }
        return canEditLine;
    }

    protected boolean checkEditLineAuthorizationAndPresentationLogic(CollectionGroup collectionGroup, ViewModel model, Object currentLine) {
        ViewPresentationController presentationController = ViewLifecycle.getView().getPresentationController();
        ViewAuthorizer authorizer = ViewLifecycle.getView().getAuthorizer();
        Person user = GlobalVariables.getUserSession().getPerson();
        boolean canEditLine = authorizer.canEditLine(ViewLifecycle.getView(), model, collectionGroup, collectionGroup.getPropertyName(), currentLine, user);
        if (canEditLine) {
            canEditLine = presentationController.canEditLine(ViewLifecycle.getView(), model, collectionGroup, collectionGroup.getPropertyName(), currentLine);
        }
        return canEditLine;
    }

    protected void addUnauthorizedBindingInfo() {
        if (this.lineBuilderContext.getCollectionGroup().getUnauthorizedLineBindingInfos() == null) {
            this.lineBuilderContext.getCollectionGroup().setUnauthorizedLineBindingInfos(new ArrayList<BindingInfo>());
        }
        BindingInfo bindingInfo = new BindingInfo();
        bindingInfo.setDefaults(ViewLifecycle.getView(), this.lineBuilderContext.getBindingPath());
        this.lineBuilderContext.getCollectionGroup().getUnauthorizedLineBindingInfos().add(bindingInfo);
    }

    protected void applyLineFieldAuthorizationAndPresentationLogic(boolean readOnlyLine, List<Field> lineFields, List<? extends Component> actionList) {
        ViewPresentationController presentationController = ViewLifecycle.getView().getPresentationController();
        ViewAuthorizer authorizer = ViewLifecycle.getView().getAuthorizer();
        Person user = GlobalVariables.getUserSession().getPerson();
        ExpressionEvaluator expressionEvaluator = ViewLifecycle.getExpressionEvaluator();
        CollectionGroup collectionGroup = this.lineBuilderContext.getCollectionGroup();
        View view = ViewLifecycle.getView();
        ViewModel model = this.lineBuilderContext.getModel();
        Object currentLine = this.lineBuilderContext.getCurrentLine();
        for (Field lineField : lineFields) {
            boolean canEditField;
            String propertyName = null;
            if (lineField instanceof DataBinding) {
                propertyName = ((DataBinding)((Object)lineField)).getPropertyName();
            }
            ComponentSecurity componentSecurity = lineField.getComponentSecurity();
            Map<String, Object> context = this.getContextForField(ViewLifecycle.getView(), collectionGroup, lineField);
            expressionEvaluator.evaluateExpressionsOnConfigurable(ViewLifecycle.getView(), componentSecurity, context);
            if (!lineField.isRender() || lineField.isHidden()) continue;
            boolean canViewField = authorizer.canViewLineField(view, model, collectionGroup, collectionGroup.getPropertyName(), currentLine, lineField, propertyName, user);
            if (canViewField) {
                canViewField = presentationController.canViewLineField(view, model, collectionGroup, collectionGroup.getPropertyName(), currentLine, lineField, propertyName);
            }
            if (!canViewField) {
                lineField.setHidden(true);
                if (!lineField.getPropertyExpressions().containsKey("hidden")) continue;
                lineField.getPropertyExpressions().remove("hidden");
                continue;
            }
            boolean bl = canEditField = !readOnlyLine;
            if (!readOnlyLine && (canEditField = authorizer.canEditLineField(view, model, collectionGroup, collectionGroup.getPropertyName(), currentLine, lineField, propertyName, user))) {
                canEditField = presentationController.canEditLineField(view, model, collectionGroup, collectionGroup.getPropertyName(), currentLine, lineField, propertyName);
            }
            if (!readOnlyLine && canEditField) continue;
            lineField.setReadOnly(true);
            if (!lineField.getPropertyExpressions().containsKey("readOnly")) continue;
            lineField.getPropertyExpressions().remove("readOnly");
        }
        List<Action> actions = ViewLifecycleUtils.getElementsOfTypeDeep(actionList, Action.class);
        for (Action action : actions) {
            if (!action.isRender()) continue;
            boolean canPerformAction = authorizer.canPerformLineAction(view, model, collectionGroup, collectionGroup.getPropertyName(), currentLine, action, action.getActionEvent(), action.getId(), user);
            if (canPerformAction) {
                canPerformAction = presentationController.canPerformLineAction(view, model, collectionGroup, collectionGroup.getPropertyName(), currentLine, action, action.getActionEvent(), action.getId());
            }
            if (canPerformAction) continue;
            action.setRender(false);
            if (!action.getPropertyExpressions().containsKey("render")) continue;
            action.getPropertyExpressions().remove("render");
        }
    }

    protected void buildSubCollectionFieldGroups() {
        CollectionGroup collectionGroup = this.lineBuilderContext.getCollectionGroup();
        String idSuffix = this.lineBuilderContext.getIdSuffix();
        if (this.lineBuilderContext.isAddLine() || collectionGroup.getSubCollections() == null) {
            return;
        }
        ArrayList<FieldGroup> subCollectionFields = new ArrayList<FieldGroup>();
        for (int subLineIndex = 0; subLineIndex < collectionGroup.getSubCollections().size(); ++subLineIndex) {
            CollectionGroup subCollectionPrototype = collectionGroup.getSubCollections().get(subLineIndex);
            CollectionGroup subCollectionGroup = ComponentUtils.copy(subCollectionPrototype);
            boolean renderSubCollection = this.checkSubCollectionRender(subCollectionGroup);
            if (!renderSubCollection) continue;
            subCollectionGroup.getBindingInfo().setBindByNamePrefix(this.lineBuilderContext.getBindingPath());
            if (subCollectionGroup.isRenderAddLine()) {
                subCollectionGroup.getAddLineBindingInfo().setBindByNamePrefix(this.lineBuilderContext.getBindingPath());
            }
            FieldGroup fieldGroupPrototype = this.lineBuilderContext.getLayoutManager().getSubCollectionFieldGroupPrototype();
            FieldGroup subCollectionFieldGroup = ComponentUtils.copy(fieldGroupPrototype, idSuffix + "_sub" + subLineIndex);
            subCollectionFieldGroup.setGroup(subCollectionGroup);
            subCollectionFieldGroup.setContainerIdSuffix(idSuffix);
            ContextUtils.updateContextForLine(subCollectionFieldGroup, collectionGroup, this.lineBuilderContext.getCurrentLine(), this.lineBuilderContext.getLineIndex(), idSuffix + "_sub" + subLineIndex);
            ContextUtils.pushObjectToContextDeep(subCollectionGroup, "parentLine", this.lineBuilderContext.getCurrentLine());
            subCollectionFields.add(subCollectionFieldGroup);
        }
        ContextUtils.pushObjectToContextDeep(subCollectionFields, "parentLine", this.lineBuilderContext.getCurrentLine());
        for (FieldGroup subCollectionField : subCollectionFields) {
            Group group = subCollectionField.getGroup();
            if (group == null || !(group instanceof CollectionGroup)) continue;
            CollectionGroup collectionGroup1 = (CollectionGroup)group;
            ContextUtils.pushObjectToContextDeep(collectionGroup1.getItems(), "parentLine", this.lineBuilderContext.getCurrentLine());
        }
        this.lineBuilderContext.setSubCollectionFields(subCollectionFields);
    }

    protected boolean checkSubCollectionRender(CollectionGroup subCollectionGroup) {
        String conditionalRender = subCollectionGroup.getPropertyExpression("render");
        if (StringUtils.isNotBlank((String)conditionalRender)) {
            HashMap<String, Object> context = new HashMap<String, Object>();
            Map<String, Object> viewContext = ViewLifecycle.getView().getContext();
            if (viewContext != null) {
                context.putAll(viewContext);
            }
            context.put("parent", this.lineBuilderContext.getCollectionGroup());
            context.put("component", subCollectionGroup);
            Boolean render = (Boolean)ViewLifecycle.getExpressionEvaluator().evaluateExpression(context, conditionalRender);
            subCollectionGroup.setRender(render);
        }
        return subCollectionGroup.isRender();
    }

    protected void setupAddLineControlValidation(List<Field> lineFields) {
        if (!this.lineBuilderContext.isAddLine()) {
            return;
        }
        ArrayList<String> selectors = new ArrayList<String>();
        String lineFieldSelector = "_control";
        String nestedLineFieldSelector = "_add_control";
        for (Field lineField : lineFields) {
            if (lineField instanceof InputField) {
                this.setupAddLineControlValidation((InputField)lineField, selectors, lineFieldSelector);
                continue;
            }
            if (!(lineField instanceof FieldGroup)) continue;
            Group group = ((FieldGroup)lineField).getGroup();
            List<InputField> nestedLineFields = ViewLifecycleUtils.getElementsOfTypeDeep(group, InputField.class);
            for (InputField nestedLineField : nestedLineFields) {
                this.setupAddLineControlValidation(nestedLineField, selectors, nestedLineFieldSelector);
            }
        }
        this.lineBuilderContext.getCollectionGroup().addDataAttribute("add_controls", StringUtils.join(selectors, (String)","));
    }

    protected void setupAddLineControlValidation(InputField lineField, List<String> selectors, String suffix) {
        Control control = lineField.getControl();
        if (control != null) {
            control.addStyleClass("ignoreValid");
            selectors.add("#" + lineField.getId() + suffix);
        }
    }

    protected void setupEditLineDetails() {
        CollectionGroup group = this.lineBuilderContext.getCollectionGroup();
        if (!group.isEditWithDialog()) {
            return;
        }
        for (DialogGroup lineDialog : group.getLineDialogs()) {
            String dialogId = lineDialog.getId();
            UifFormBase form = (UifFormBase)this.lineBuilderContext.getModel();
            if (!group.getCollectionGroupBuilder().refreshEditLineDialogContents(lineDialog, form, group, this.lineBuilderContext.getLineIndex()) || !lineDialog.getId().contains("Uif-EditLineDialog")) continue;
            form.setUpdateComponent(lineDialog);
            if (lineDialog.getItems() == null || lineDialog.getItems().isEmpty() || !group.isCustomEditLineDialog()) {
                List<Field> lineFields = this.lineBuilderContext.getLineFields();
                lineDialog.setItems(this.processDialogFieldsFromLineFields(lineFields, dialogId));
                ArrayList<? extends Component> items = new ArrayList<Component>(lineDialog.getItems());
                items.addAll(this.processDialogSubFieldsFromLineSubFields(lineDialog));
                items.addAll(this.processDialogSubFieldsFromRowDetails(lineDialog));
                lineDialog.setItems(items);
                continue;
            }
            ArrayList<? extends Component> dialogFields = new ArrayList<Component>(lineDialog.getItems());
            ArrayList<Component> dialogComponents = new ArrayList<Component>();
            int fieldIndex = 0;
            int subIndex = 0;
            for (Component component : dialogFields) {
                if (component instanceof DataField) {
                    DataField dataField = (DataField)component;
                    DataField lineField = this.findItemInLineFields(dataField);
                    if (lineField != null) {
                        dataField.getBindingInfo().setCollectionPath(lineField.getBindingInfo().getCollectionPath());
                        lineField.setReadOnly(true);
                    } else {
                        dataField.getBindingInfo().setCollectionPath(group.getBindingInfo().getBindingName());
                    }
                    dataField.getBindingInfo().setBindByNamePrefix("dialogDataObject");
                    dialogComponents.add(dataField);
                } else if (component instanceof FieldGroup) {
                    FieldGroup fieldGroup = (FieldGroup)component;
                    if (fieldGroup.getGroup() instanceof CollectionGroup) {
                        dialogComponents.add(this.getNewFieldGroup(fieldGroup, (CollectionGroup)fieldGroup.getGroup(), lineDialog, fieldIndex, subIndex, null));
                        ++subIndex;
                    }
                } else if (component instanceof CollectionGroup) {
                    CollectionGroup collectionGroup = (CollectionGroup)component;
                    FieldGroup fieldGroupPrototype = this.lineBuilderContext.getLayoutManager().getSubCollectionFieldGroupPrototype();
                    dialogComponents.add(this.getNewFieldGroup(fieldGroupPrototype, collectionGroup, lineDialog, fieldIndex, subIndex, "dialogDataObject"));
                    ++subIndex;
                } else {
                    ComponentUtils.prefixBindingPath(component, "dialogDataObject");
                    dialogComponents.add(component);
                }
                ++fieldIndex;
            }
            lineDialog.setItems(dialogComponents);
        }
        if (this.lineBuilderContext.getCollectionGroup().isEditWithDialog()) {
            for (Field lineField : this.lineBuilderContext.getLineFields()) {
                if (!(lineField instanceof InputField)) continue;
                lineField.setReadOnly(Boolean.TRUE);
            }
            List<FieldGroup> subLineFields = this.lineBuilderContext.getSubCollectionFields();
            if (subLineFields != null) {
                for (FieldGroup subLineField : subLineFields) {
                    subLineField.setReadOnly(Boolean.TRUE);
                }
            }
        }
    }

    private List<FieldGroup> processDialogSubFieldsFromLineSubFields(DialogGroup lineDialog) {
        List<FieldGroup> subCollectionFields = this.lineBuilderContext.getSubCollectionFields();
        ArrayList<FieldGroup> newSubCollectionFields = new ArrayList<FieldGroup>();
        int fieldIndex = lineDialog.getItems().size();
        int subIndex = 0;
        for (FieldGroup subCollectionFieldGroup : subCollectionFields) {
            CollectionGroup subCollectionGroup = (CollectionGroup)subCollectionFieldGroup.getGroup();
            newSubCollectionFields.add(this.getNewFieldGroup(subCollectionFieldGroup, subCollectionGroup, lineDialog, fieldIndex, subIndex, "dialogDataObject"));
            ++fieldIndex;
            ++subIndex;
            List<Component> components = ViewLifecycleUtils.getElementsOfTypeDeep(subCollectionGroup.getItems(), Component.class);
            for (Component component : components) {
                component.setReadOnly(Boolean.TRUE);
            }
        }
        return newSubCollectionFields;
    }

    private List<Field> processDialogSubFieldsFromRowDetails(DialogGroup lineDialog) {
        TableLayoutManagerBase tableLayoutManagerBase;
        Group rowDetailsGroup;
        ArrayList<Field> newSubCollectionFields = new ArrayList<Field>();
        CollectionLayoutManager layoutManager = (CollectionLayoutManager)this.lineBuilderContext.getCollectionGroup().getLayoutManager();
        if (layoutManager instanceof TableLayoutManagerBase && (rowDetailsGroup = (tableLayoutManagerBase = (TableLayoutManagerBase)layoutManager).getRowDetailsGroup()) != null) {
            ArrayList<? extends Component> subCollectionComponents = new ArrayList<Component>(rowDetailsGroup.getItems());
            int fieldIndex = lineDialog.getItems().size();
            int subIndex = 0;
            for (Component component : subCollectionComponents) {
                if (component instanceof CollectionGroup) {
                    CollectionGroup subCollectionGroup = (CollectionGroup)component;
                    boolean renderSubCollection = this.checkSubCollectionRender(subCollectionGroup);
                    if (!renderSubCollection) continue;
                    FieldGroup fieldGroupPrototype = this.lineBuilderContext.getLayoutManager().getSubCollectionFieldGroupPrototype();
                    newSubCollectionFields.add(this.getNewFieldGroup(fieldGroupPrototype, subCollectionGroup, lineDialog, fieldIndex, subIndex, "dialogDataObject"));
                    ++subIndex;
                } else if (component instanceof Field) {
                    Field subCollectionField = (Field)component;
                    Field newSubCollectionField = this.getNewFieldForEditLineDialog(subCollectionField, lineDialog.getId() + "_fieldset" + Integer.toString(fieldIndex++));
                    newSubCollectionFields.add(newSubCollectionField);
                }
                ContextUtils.pushObjectToContextDeep(newSubCollectionFields, "parentLine", ((UifFormBase)this.lineBuilderContext.getModel()).getDialogDataObject());
            }
        }
        return newSubCollectionFields;
    }

    private FieldGroup getNewFieldGroup(FieldGroup fieldGroupPrototype, CollectionGroup subCollectionGroup, DialogGroup lineDialog, int fieldIndex, int subIndex, String bindingPrefix) {
        FieldGroup newSubCollectionFieldGroup = ComponentUtils.copy(fieldGroupPrototype);
        newSubCollectionFieldGroup.setId(lineDialog.getId() + "_fieldset" + Integer.toString(fieldIndex));
        newSubCollectionFieldGroup.pushObjectToContext("parent", lineDialog);
        CollectionGroup newSubCollectionGroup = ComponentUtils.copy(subCollectionGroup);
        newSubCollectionGroup.setId(newSubCollectionFieldGroup.getId() + "_sub" + Integer.toString(subIndex));
        if (bindingPrefix != null) {
            newSubCollectionGroup.getBindingInfo().setBindByNamePrefix(bindingPrefix);
        }
        if (newSubCollectionGroup.getBindingInfo().getBindingName() == null) {
            newSubCollectionGroup.getBindingInfo().setBindingName(newSubCollectionGroup.getPropertyName());
        }
        newSubCollectionGroup.pushObjectToContext("parent", lineDialog);
        newSubCollectionGroup.addDataAttribute("parent", lineDialog.getId());
        if (newSubCollectionGroup.isRenderAddLine()) {
            newSubCollectionGroup.getAddLineBindingInfo().setBindByNamePrefix(newSubCollectionGroup.getBindingInfo().getBindByNamePrefix());
            newSubCollectionGroup.getAddLineBindingInfo().setBindingName(newSubCollectionGroup.getBindingInfo().getBindingName());
            String addBindingPath = "newCollectionLines['" + newSubCollectionGroup.getBindingInfo().getBindByNamePrefix() + "." + newSubCollectionGroup.getBindingInfo().getBindingName() + "']";
            Object addLine = ObjectPropertyUtils.getPropertyValue(this.lineBuilderContext.getModel(), addBindingPath);
            if (addLine != null) {
                ObjectPropertyUtils.setPropertyValue(this.lineBuilderContext.getModel(), addBindingPath, null);
            }
        }
        List<Action> subLineActions = ViewLifecycleUtils.getElementsOfTypeDeep(newSubCollectionGroup.getLineActions(), Action.class);
        this.setupSubCollectionActions(subLineActions, lineDialog.getId(), this.lineBuilderContext.getCollectionGroup().getBindingInfo().getBindingName(), this.lineBuilderContext.getLineIndex());
        this.lineBuilderContext.getCollectionGroup().getCollectionGroupBuilder().initializeLineActions(subLineActions, ViewLifecycle.getView(), newSubCollectionGroup, this.lineBuilderContext.getCurrentLine(), this.lineBuilderContext.getLineIndex());
        ArrayList<? extends Component> subAddLineComponents = new ArrayList<Component>(newSubCollectionGroup.getAddLineActions());
        if (newSubCollectionGroup.getAddBlankLineAction() != null) {
            subAddLineComponents.add(newSubCollectionGroup.getAddBlankLineAction());
        }
        List<Action> subAddLineActions = ViewLifecycleUtils.getElementsOfTypeDeep(subAddLineComponents, Action.class);
        this.setupSubCollectionActions(subAddLineActions, lineDialog.getId(), this.lineBuilderContext.getCollectionGroup().getBindingInfo().getBindingName(), this.lineBuilderContext.getLineIndex());
        newSubCollectionFieldGroup.setGroup(newSubCollectionGroup);
        ContextUtils.updateContextForLine(newSubCollectionFieldGroup, this.lineBuilderContext.getCollectionGroup(), ((UifFormBase)this.lineBuilderContext.getModel()).getDialogDataObject(), this.lineBuilderContext.getLineIndex(), this.lineBuilderContext.getIdSuffix() + "_sub" + subIndex);
        ContextUtils.pushObjectToContextDeep(newSubCollectionGroup, "parentLine", ((UifFormBase)this.lineBuilderContext.getModel()).getDialogDataObject());
        return newSubCollectionFieldGroup;
    }

    private List<Field> processDialogFieldsFromLineFields(List<Field> lineFields, String prefix) {
        ArrayList<Field> newLineFields = new ArrayList<Field>();
        int fieldIndex = 0;
        for (Field lineField : lineFields) {
            if (lineField instanceof FieldGroup) continue;
            Field newLineField = this.getNewFieldForEditLineDialog(lineField, prefix + "_fieldset" + Integer.toString(fieldIndex));
            newLineFields.add(newLineField);
            ++fieldIndex;
        }
        return newLineFields;
    }

    private Field getNewFieldForEditLineDialog(Field field, String id) {
        Field newLineField = ComponentUtils.copy(field, id);
        if (newLineField instanceof DataField) {
            ((DataField)newLineField).getBindingInfo().setBindByNamePrefix("dialogDataObject");
        }
        return newLineField;
    }

    private void setupSubCollectionActions(List<Action> actions, String dialogId, String bindingName, int lineIndex) {
        for (Action action : actions) {
            action.setDialogDismissOption("REQUEST");
            action.setRefreshId(StringUtils.substring((String)dialogId, (int)(dialogId.indexOf("_") + 1), (int)dialogId.lastIndexOf("_")));
            String actionScript = "showEditLineDialog('" + dialogId + "', '" + bindingName + "', " + lineIndex + ");";
            action.setRefreshedByAction(false);
            action.setSuccessCallback("jQuery.unblockUI();" + actionScript);
            action.setOnClickScript("jQuery('#" + dialogId + "').one('hide.bs.modal', function(e) { jQuery.blockUI({ message: '<h1>Editing line ...</h1>' }); });");
            action.addActionParameter("dialogId", dialogId);
        }
    }

    private DataField findItemInLineFields(DataField dataItem) {
        for (Field field : this.lineBuilderContext.getLineFields()) {
            if (!(field instanceof DataField) || !dataItem.getPropertyName().equals(((DataField)field).getPropertyName())) continue;
            return (DataField)field;
        }
        return null;
    }

    protected Map<String, Object> getContextForField(View view, CollectionGroup collectionGroup, Field field) {
        Map<String, Object> fieldContext;
        HashMap<String, Object> context = new HashMap<String, Object>();
        Map<String, Object> viewContext = view.getContext();
        if (viewContext != null) {
            context.putAll(viewContext);
        }
        if ((fieldContext = field.getContext()) != null) {
            context.putAll(fieldContext);
        }
        context.put("parent", collectionGroup);
        context.put("component", field);
        return context;
    }
}

