/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krad.uif.layout;

import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.kuali.rice.krad.service.KRADServiceLocatorWeb;
import org.kuali.rice.krad.uif.component.DataBinding;
import org.kuali.rice.krad.uif.container.CollectionGroup;
import org.kuali.rice.krad.uif.control.Control;
import org.kuali.rice.krad.uif.control.ValueConfiguredControl;
import org.kuali.rice.krad.uif.element.Pager;
import org.kuali.rice.krad.uif.field.Field;
import org.kuali.rice.krad.uif.field.InputField;
import org.kuali.rice.krad.uif.util.ObjectPropertyUtils;
import org.kuali.rice.krad.util.KRADUtils;

public class CollectionLayoutUtils {
    public static void prepareSelectFieldForLine(Field selectField, CollectionGroup collectionGroup, String lineBindingPath, Object line) {
        String selectPropertyName = collectionGroup.getLineSelectPropertyName();
        if (StringUtils.isNotBlank((String)selectPropertyName)) {
            if (selectPropertyName.startsWith("#form.")) {
                selectPropertyName = StringUtils.removeStart((String)selectPropertyName, (String)"#form.");
                ((DataBinding)((Object)selectField)).getBindingInfo().setBindingName(selectPropertyName);
                ((DataBinding)((Object)selectField)).getBindingInfo().setBindToForm(true);
            } else {
                ((DataBinding)((Object)selectField)).getBindingInfo().setBindingName(selectPropertyName);
                ((DataBinding)((Object)selectField)).getBindingInfo().setBindByNamePrefix(lineBindingPath);
            }
        } else {
            String collectionLineKey = KRADUtils.translateToMapSafeKey(collectionGroup.getBindingInfo().getBindingPath());
            String selectBindingPath = "selectedCollectionLines['" + collectionLineKey + "']";
            ((DataBinding)((Object)selectField)).getBindingInfo().setBindingName(selectBindingPath);
            ((DataBinding)((Object)selectField)).getBindingInfo().setBindToForm(true);
        }
        CollectionLayoutUtils.setControlValueToLineIdentifier(selectField, line, lineBindingPath);
    }

    protected static void setControlValueToLineIdentifier(Field selectField, Object line, String lineBindingPath) {
        Control selectControl;
        if (selectField instanceof InputField && (selectControl = ((InputField)selectField).getControl()) != null) {
            selectControl.addStyleClass("uif-select-line");
            if (selectControl instanceof ValueConfiguredControl) {
                String lineIdentifier = KRADServiceLocatorWeb.getLegacyDataAdapter().getDataObjectIdentifierString(line);
                if (StringUtils.isBlank((String)lineIdentifier)) {
                    lineIdentifier = lineBindingPath;
                }
                ((ValueConfiguredControl)((Object)selectControl)).setValue(lineIdentifier);
            }
        }
    }

    protected static void setupPagerWidget(Pager pagerWidget, CollectionGroup collectionGroup, Object model) {
        List modelCollection = (List)ObjectPropertyUtils.getPropertyValue(model, collectionGroup.getBindingInfo().getBindingPath());
        if (modelCollection != null) {
            double pages = (double)modelCollection.size() / (double)collectionGroup.getDisplayLength();
            pagerWidget.setNumberOfPages((int)Math.ceil(pages));
        } else {
            pagerWidget.setNumberOfPages(1);
        }
        int currentPage = (collectionGroup.getDisplayStart() + collectionGroup.getDisplayLength()) / collectionGroup.getDisplayLength();
        pagerWidget.setCurrentPage(currentPage);
        if (StringUtils.isBlank((String)pagerWidget.getLinkScript())) {
            pagerWidget.setLinkScript("retrieveCollectionPage(this, '" + collectionGroup.getId() + "');");
        }
    }
}

