/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.coreservice.api.component;

import java.io.Serializable;
import java.util.Collection;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAnyElement;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import org.apache.commons.lang.StringUtils;
import org.kuali.rice.core.api.mo.AbstractDataTransferObject;
import org.kuali.rice.core.api.mo.ModelBuilder;
import org.kuali.rice.coreservice.api.component.ComponentContract;
import org.w3c.dom.Element;

@XmlRootElement(name="component")
@XmlAccessorType(value=XmlAccessType.NONE)
@XmlType(name="ComponentType", propOrder={"namespaceCode", "code", "name", "componentSetId", "active", "versionNumber", "objectId", "_futureElements"})
public final class Component
extends AbstractDataTransferObject
implements ComponentContract {
    private static final long serialVersionUID = -5114772381708593543L;
    @XmlElement(name="namespaceCode", required=true)
    private final String namespaceCode;
    @XmlElement(name="code", required=true)
    private final String code;
    @XmlElement(name="name", required=true)
    private final String name;
    @XmlElement(name="componentSetId", required=false)
    private final String componentSetId;
    @XmlElement(name="active", required=false)
    private final boolean active;
    @XmlElement(name="versionNumber", required=false)
    private final Long versionNumber;
    @XmlElement(name="objectId", required=false)
    private final String objectId;
    @XmlAnyElement
    private final Collection<Element> _futureElements = null;

    private Component() {
        this.namespaceCode = null;
        this.code = null;
        this.name = null;
        this.componentSetId = null;
        this.active = true;
        this.versionNumber = null;
        this.objectId = null;
    }

    private Component(Builder builder) {
        this.namespaceCode = builder.getNamespaceCode();
        this.code = builder.getCode();
        this.name = builder.getName();
        this.componentSetId = builder.getComponentSetId();
        this.active = builder.isActive();
        this.versionNumber = builder.getVersionNumber();
        this.objectId = builder.getObjectId();
    }

    @Override
    public String getNamespaceCode() {
        return this.namespaceCode;
    }

    public String getCode() {
        return this.code;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getComponentSetId() {
        return this.componentSetId;
    }

    public boolean isActive() {
        return this.active;
    }

    public Long getVersionNumber() {
        return this.versionNumber;
    }

    public String getObjectId() {
        return this.objectId;
    }

    public static class Cache {
        public static final String NAME = "http://rice.kuali.org/core/v2_0/ComponentType";
    }

    static class Elements {
        static final String CODE = "code";
        static final String NAME = "name";
        static final String NAMESPACE_CODE = "namespaceCode";
        static final String COMPONENT_SET_ID = "componentSetId";
        static final String ACTIVE = "active";

        Elements() {
        }
    }

    static class Constants {
        static final String ROOT_ELEMENT_NAME = "component";
        static final String TYPE_NAME = "ComponentType";

        Constants() {
        }
    }

    public static final class Builder
    implements ComponentContract,
    ModelBuilder,
    Serializable {
        private static final long serialVersionUID = 5548130104299578283L;
        private String namespaceCode;
        private String code;
        private String name;
        private String componentSetId;
        private boolean active;
        private Long versionNumber;
        private String objectId;

        private Builder(String namespaceCode, String code, String name) {
            this.setNamespaceCode(namespaceCode);
            this.setCode(code);
            this.setName(name);
            this.setActive(true);
        }

        public static Builder create(String namespaceCode, String code, String name) {
            return new Builder(namespaceCode, code, name);
        }

        public static Builder create(ComponentContract contract) {
            Builder builder = new Builder(contract.getNamespaceCode(), contract.getCode(), contract.getName());
            builder.setComponentSetId(contract.getComponentSetId());
            builder.setActive(contract.isActive());
            builder.setVersionNumber(contract.getVersionNumber());
            builder.setObjectId(contract.getObjectId());
            return builder;
        }

        public void setNamespaceCode(String namespaceCode) {
            if (StringUtils.isBlank((String)namespaceCode)) {
                throw new IllegalArgumentException("namespaceCode is null");
            }
            this.namespaceCode = namespaceCode;
        }

        public void setCode(String code) {
            if (StringUtils.isBlank((String)code)) {
                throw new IllegalArgumentException("code is blank");
            }
            this.code = code;
        }

        public void setName(String name) {
            if (StringUtils.isBlank((String)name)) {
                throw new IllegalArgumentException("name is blank");
            }
            this.name = name;
        }

        public boolean isActive() {
            return this.active;
        }

        public void setActive(boolean active) {
            this.active = active;
        }

        @Override
        public String getNamespaceCode() {
            return this.namespaceCode;
        }

        public String getCode() {
            return this.code;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public String getComponentSetId() {
            return this.componentSetId;
        }

        public void setComponentSetId(String componentSetId) {
            if (componentSetId != null && StringUtils.isBlank((String)componentSetId)) {
                throw new IllegalArgumentException("componentSetId should be either null or a non-blank value");
            }
            this.componentSetId = componentSetId;
        }

        public Long getVersionNumber() {
            return this.versionNumber;
        }

        public void setVersionNumber(Long versionNumber) {
            this.versionNumber = versionNumber;
        }

        public String getObjectId() {
            return this.objectId;
        }

        public void setObjectId(String objectId) {
            this.objectId = objectId;
        }

        public Component build() {
            return new Component(this);
        }
    }
}

