/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.coreservice.impl.parameter;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.Id;
import javax.persistence.IdClass;
import javax.persistence.JoinColumn;
import javax.persistence.JoinColumns;
import javax.persistence.ManyToOne;
import javax.persistence.OneToOne;
import javax.persistence.Table;
import javax.persistence.Transient;
import javax.xml.bind.annotation.XmlTransient;
import org.eclipse.persistence.indirection.ValueHolder;
import org.eclipse.persistence.indirection.WeavedAttributeValueHolderInterface;
import org.eclipse.persistence.internal.descriptors.PersistenceObject;
import org.eclipse.persistence.internal.weaving.PersistenceWeaved;
import org.eclipse.persistence.internal.weaving.PersistenceWeavedChangeTracking;
import org.eclipse.persistence.internal.weaving.PersistenceWeavedFetchGroups;
import org.eclipse.persistence.internal.weaving.PersistenceWeavedLazy;
import org.kuali.rice.coreservice.api.parameter.EvaluationOperator;
import org.kuali.rice.coreservice.api.parameter.Parameter;
import org.kuali.rice.coreservice.api.parameter.ParameterContract;
import org.kuali.rice.coreservice.framework.parameter.ParameterEbo;
import org.kuali.rice.coreservice.impl.component.ComponentBo;
import org.kuali.rice.coreservice.impl.component.DerivedComponentBo;
import org.kuali.rice.coreservice.impl.namespace.NamespaceBo;
import org.kuali.rice.coreservice.impl.parameter.ParameterId;
import org.kuali.rice.coreservice.impl.parameter.ParameterTypeBo;
import org.kuali.rice.krad.bo.PersistableBusinessObjectBase;
import org.kuali.rice.krad.data.jpa.DisableVersioning;
import org.kuali.rice.krad.data.jpa.RemoveMapping;
import org.kuali.rice.krad.data.jpa.RemoveMappings;

@IdClass(value=ParameterId.class)
@Entity
@Table(name="KRCR_PARM_T")
@DisableVersioning
@RemoveMappings(value={@RemoveMapping(name="versionNumber")})
public class ParameterBo
extends PersistableBusinessObjectBase
implements ParameterEbo,
PersistenceWeaved,
PersistenceObject,
PersistenceWeavedFetchGroups,
PersistenceWeavedLazy,
PersistenceWeavedChangeTracking {
    private static final long serialVersionUID = 1L;
    @Id
    @Column(name="NMSPC_CD")
    private String namespaceCode;
    @Id
    @Column(name="CMPNT_CD")
    private String componentCode;
    @Id
    @Column(name="PARM_NM")
    private String name;
    @Id
    @Column(name="APPL_ID")
    private String applicationId;
    @Column(name="VAL")
    private String value;
    @Column(name="PARM_DESC_TXT", length=2048)
    private String description;
    @Column(name="PARM_TYP_CD")
    private String parameterTypeCode;
    @Column(name="EVAL_OPRTR_CD")
    private String evaluationOperatorCode;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="NMSPC_CD", insertable=false, updatable=false)
    private NamespaceBo namespace;
    @OneToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="PARM_TYP_CD", insertable=false, updatable=false)
    private ParameterTypeBo parameterType;
    @OneToOne(targetEntity=ComponentBo.class, fetch=FetchType.LAZY)
    @JoinColumns(value={@JoinColumn(name="NMSPC_CD", referencedColumnName="NMSPC_CD", insertable=false, updatable=false), @JoinColumn(name="CMPNT_CD", referencedColumnName="CMPNT_CD", insertable=false, updatable=false)})
    private ComponentBo component;
    @OneToOne(fetch=FetchType.LAZY)
    @JoinColumns(value={@JoinColumn(name="NMSPC_CD", referencedColumnName="NMSPC_CD", insertable=false, updatable=false), @JoinColumn(name="CMPNT_CD", referencedColumnName="CMPNT_CD", insertable=false, updatable=false)})
    private DerivedComponentBo derivedComponent;
    @Transient
    @XmlTransient
    protected WeavedAttributeValueHolderInterface _persistence_parameterType_vh;
    @Transient
    @XmlTransient
    protected WeavedAttributeValueHolderInterface _persistence_component_vh;
    @Transient
    @XmlTransient
    protected WeavedAttributeValueHolderInterface _persistence_namespace_vh;
    @Transient
    @XmlTransient
    protected WeavedAttributeValueHolderInterface _persistence_derivedComponent_vh;

    public static Parameter to(ParameterBo bo) {
        if (bo == null) {
            return null;
        }
        return Parameter.Builder.create((ParameterContract)bo).build();
    }

    public static ParameterBo from(Parameter im) {
        if (im == null) {
            return null;
        }
        ParameterBo bo = new ParameterBo();
        bo.setNamespaceCode(im.getNamespaceCode());
        bo.setComponentCode(im.getComponentCode());
        bo.setName(im.getName());
        bo.setApplicationId(im.getApplicationId());
        bo.setValue(im.getValue());
        bo.setDescription(im.getDescription());
        bo.setParameterTypeCode(im.getParameterType().getCode());
        if (null != im.getEvaluationOperator()) {
            bo.setEvaluationOperatorCode(im.getEvaluationOperator().getCode());
        }
        bo.setParameterType(ParameterTypeBo.from(im.getParameterType()));
        bo.setVersionNumber(im.getVersionNumber());
        bo.setObjectId(im.getObjectId());
        return bo;
    }

    public ParameterTypeBo getParameterType() {
        return this._persistence_get_parameterType();
    }

    public EvaluationOperator getEvaluationOperator() {
        return EvaluationOperator.fromCode((String)this._persistence_get_evaluationOperatorCode());
    }

    public String getNamespaceCode() {
        return this._persistence_get_namespaceCode();
    }

    public void setNamespaceCode(String namespaceCode) {
        this._persistence_set_namespaceCode(namespaceCode);
    }

    public String getComponentCode() {
        return this._persistence_get_componentCode();
    }

    public void setComponentCode(String componentCode) {
        this._persistence_set_componentCode(componentCode);
    }

    public String getName() {
        return this._persistence_get_name();
    }

    public void setName(String name) {
        this._persistence_set_name(name);
    }

    public String getApplicationId() {
        return this._persistence_get_applicationId();
    }

    public void setApplicationId(String applicationId) {
        this._persistence_set_applicationId(applicationId);
    }

    public String getValue() {
        return this._persistence_get_value();
    }

    public void setValue(String value) {
        this._persistence_set_value(value);
    }

    public String getDescription() {
        return this._persistence_get_description();
    }

    public void setDescription(String description) {
        this._persistence_set_description(description);
    }

    public String getParameterTypeCode() {
        return this._persistence_get_parameterTypeCode();
    }

    public void setParameterTypeCode(String parameterTypeCode) {
        this._persistence_set_parameterTypeCode(parameterTypeCode);
    }

    public void setParameterType(ParameterTypeBo parameterType) {
        this._persistence_set_parameterType(parameterType);
    }

    public String getEvaluationOperatorCode() {
        return this._persistence_get_evaluationOperatorCode();
    }

    public void setEvaluationOperatorCode(String evaluationOperatorCode) {
        this._persistence_set_evaluationOperatorCode(evaluationOperatorCode);
    }

    public NamespaceBo getNamespace() {
        return this._persistence_get_namespace();
    }

    public void setNamespace(NamespaceBo namespace) {
        this._persistence_set_namespace(namespace);
    }

    public ComponentBo getComponent() {
        return this._persistence_get_component();
    }

    public void setComponent(ComponentBo component) {
        this._persistence_set_component(component);
    }

    public DerivedComponentBo getDerivedComponent() {
        return this._persistence_get_derivedComponent();
    }

    public void setDerivedComponent(DerivedComponentBo derivedComponent) {
        this._persistence_set_derivedComponent(derivedComponent);
    }

    public ParameterId getParameterId() {
        return new ParameterId(this._persistence_get_namespaceCode(), this._persistence_get_componentCode(), this._persistence_get_name(), this._persistence_get_applicationId());
    }

    public Object _persistence_post_clone() {
        Object object = super._persistence_post_clone();
        if (this._persistence_parameterType_vh != null) {
            this._persistence_parameterType_vh = (WeavedAttributeValueHolderInterface)this._persistence_parameterType_vh.clone();
        }
        if (this._persistence_component_vh != null) {
            this._persistence_component_vh = (WeavedAttributeValueHolderInterface)this._persistence_component_vh.clone();
        }
        if (this._persistence_namespace_vh != null) {
            this._persistence_namespace_vh = (WeavedAttributeValueHolderInterface)this._persistence_namespace_vh.clone();
        }
        if (this._persistence_derivedComponent_vh != null) {
            this._persistence_derivedComponent_vh = (WeavedAttributeValueHolderInterface)this._persistence_derivedComponent_vh.clone();
        }
        this._persistence_listener = null;
        this._persistence_fetchGroup = null;
        this._persistence_session = null;
        this._persistence_primaryKey = null;
        return this;
    }

    public Object _persistence_new(PersistenceObject persistenceObject) {
        return new ParameterBo();
    }

    public Object _persistence_get(String string) {
        if (string == "parameterType") {
            return this.parameterType;
        }
        if (string == "componentCode") {
            return this.componentCode;
        }
        if (string == "description") {
            return this.description;
        }
        if (string == "component") {
            return this.component;
        }
        if (string == "name") {
            return this.name;
        }
        if (string == "namespace") {
            return this.namespace;
        }
        if (string == "evaluationOperatorCode") {
            return this.evaluationOperatorCode;
        }
        if (string == "namespaceCode") {
            return this.namespaceCode;
        }
        if (string == "parameterTypeCode") {
            return this.parameterTypeCode;
        }
        if (string == "derivedComponent") {
            return this.derivedComponent;
        }
        if (string == "applicationId") {
            return this.applicationId;
        }
        if (string == "value") {
            return this.value;
        }
        return super._persistence_get(string);
    }

    public void _persistence_set(String string, Object object) {
        if (string == "parameterType") {
            this.parameterType = (ParameterTypeBo)((Object)object);
            return;
        }
        if (string == "componentCode") {
            this.componentCode = (String)object;
            return;
        }
        if (string == "description") {
            this.description = (String)object;
            return;
        }
        if (string == "component") {
            this.component = (ComponentBo)((Object)object);
            return;
        }
        if (string == "name") {
            this.name = (String)object;
            return;
        }
        if (string == "namespace") {
            this.namespace = (NamespaceBo)((Object)object);
            return;
        }
        if (string == "evaluationOperatorCode") {
            this.evaluationOperatorCode = (String)object;
            return;
        }
        if (string == "namespaceCode") {
            this.namespaceCode = (String)object;
            return;
        }
        if (string == "parameterTypeCode") {
            this.parameterTypeCode = (String)object;
            return;
        }
        if (string == "derivedComponent") {
            this.derivedComponent = (DerivedComponentBo)((Object)object);
            return;
        }
        if (string == "applicationId") {
            this.applicationId = (String)object;
            return;
        }
        if (string == "value") {
            this.value = (String)object;
            return;
        }
        super._persistence_set(string, object);
    }

    protected void _persistence_initialize_parameterType_vh() {
        if (this._persistence_parameterType_vh == null) {
            this._persistence_parameterType_vh = new ValueHolder((Object)this.parameterType);
            this._persistence_parameterType_vh.setIsNewlyWeavedValueHolder(true);
        }
    }

    public WeavedAttributeValueHolderInterface _persistence_get_parameterType_vh() {
        ParameterTypeBo parameterTypeBo;
        this._persistence_initialize_parameterType_vh();
        if ((this._persistence_parameterType_vh.isCoordinatedWithProperty() || this._persistence_parameterType_vh.isNewlyWeavedValueHolder()) && (parameterTypeBo = this._persistence_get_parameterType()) != this._persistence_parameterType_vh.getValue()) {
            this._persistence_set_parameterType(parameterTypeBo);
        }
        return this._persistence_parameterType_vh;
    }

    public void _persistence_set_parameterType_vh(WeavedAttributeValueHolderInterface weavedAttributeValueHolderInterface) {
        this._persistence_parameterType_vh = weavedAttributeValueHolderInterface;
        if (weavedAttributeValueHolderInterface.isInstantiated()) {
            Object object;
            ParameterTypeBo parameterTypeBo = this._persistence_get_parameterType();
            if (parameterTypeBo != (object = weavedAttributeValueHolderInterface.getValue())) {
                this._persistence_set_parameterType((ParameterTypeBo)((Object)object));
            }
        } else {
            this.parameterType = null;
        }
    }

    public ParameterTypeBo _persistence_get_parameterType() {
        this._persistence_checkFetched("parameterType");
        this._persistence_initialize_parameterType_vh();
        this.parameterType = (ParameterTypeBo)((Object)this._persistence_parameterType_vh.getValue());
        return this.parameterType;
    }

    public void _persistence_set_parameterType(ParameterTypeBo parameterTypeBo) {
        this._persistence_checkFetchedForSet("parameterType");
        this._persistence_initialize_parameterType_vh();
        this.parameterType = (ParameterTypeBo)((Object)this._persistence_parameterType_vh.getValue());
        this._persistence_propertyChange("parameterType", (Object)this.parameterType, (Object)parameterTypeBo);
        this.parameterType = parameterTypeBo;
        this._persistence_parameterType_vh.setValue((Object)parameterTypeBo);
    }

    public String _persistence_get_componentCode() {
        this._persistence_checkFetched("componentCode");
        return this.componentCode;
    }

    public void _persistence_set_componentCode(String string) {
        this._persistence_checkFetchedForSet("componentCode");
        this._persistence_propertyChange("componentCode", this.componentCode, string);
        this.componentCode = string;
    }

    public String _persistence_get_description() {
        this._persistence_checkFetched("description");
        return this.description;
    }

    public void _persistence_set_description(String string) {
        this._persistence_checkFetchedForSet("description");
        this._persistence_propertyChange("description", this.description, string);
        this.description = string;
    }

    protected void _persistence_initialize_component_vh() {
        if (this._persistence_component_vh == null) {
            this._persistence_component_vh = new ValueHolder((Object)this.component);
            this._persistence_component_vh.setIsNewlyWeavedValueHolder(true);
        }
    }

    public WeavedAttributeValueHolderInterface _persistence_get_component_vh() {
        ComponentBo componentBo;
        this._persistence_initialize_component_vh();
        if ((this._persistence_component_vh.isCoordinatedWithProperty() || this._persistence_component_vh.isNewlyWeavedValueHolder()) && (componentBo = this._persistence_get_component()) != this._persistence_component_vh.getValue()) {
            this._persistence_set_component(componentBo);
        }
        return this._persistence_component_vh;
    }

    public void _persistence_set_component_vh(WeavedAttributeValueHolderInterface weavedAttributeValueHolderInterface) {
        this._persistence_component_vh = weavedAttributeValueHolderInterface;
        if (weavedAttributeValueHolderInterface.isInstantiated()) {
            Object object;
            ComponentBo componentBo = this._persistence_get_component();
            if (componentBo != (object = weavedAttributeValueHolderInterface.getValue())) {
                this._persistence_set_component((ComponentBo)((Object)object));
            }
        } else {
            this.component = null;
        }
    }

    public ComponentBo _persistence_get_component() {
        this._persistence_checkFetched("component");
        this._persistence_initialize_component_vh();
        this.component = (ComponentBo)((Object)this._persistence_component_vh.getValue());
        return this.component;
    }

    public void _persistence_set_component(ComponentBo componentBo) {
        this._persistence_checkFetchedForSet("component");
        this._persistence_initialize_component_vh();
        this.component = (ComponentBo)((Object)this._persistence_component_vh.getValue());
        this._persistence_propertyChange("component", (Object)this.component, (Object)componentBo);
        this.component = componentBo;
        this._persistence_component_vh.setValue((Object)componentBo);
    }

    public String _persistence_get_name() {
        this._persistence_checkFetched("name");
        return this.name;
    }

    public void _persistence_set_name(String string) {
        this._persistence_checkFetchedForSet("name");
        this._persistence_propertyChange("name", this.name, string);
        this.name = string;
    }

    protected void _persistence_initialize_namespace_vh() {
        if (this._persistence_namespace_vh == null) {
            this._persistence_namespace_vh = new ValueHolder((Object)this.namespace);
            this._persistence_namespace_vh.setIsNewlyWeavedValueHolder(true);
        }
    }

    public WeavedAttributeValueHolderInterface _persistence_get_namespace_vh() {
        NamespaceBo namespaceBo;
        this._persistence_initialize_namespace_vh();
        if ((this._persistence_namespace_vh.isCoordinatedWithProperty() || this._persistence_namespace_vh.isNewlyWeavedValueHolder()) && (namespaceBo = this._persistence_get_namespace()) != this._persistence_namespace_vh.getValue()) {
            this._persistence_set_namespace(namespaceBo);
        }
        return this._persistence_namespace_vh;
    }

    public void _persistence_set_namespace_vh(WeavedAttributeValueHolderInterface weavedAttributeValueHolderInterface) {
        this._persistence_namespace_vh = weavedAttributeValueHolderInterface;
        if (weavedAttributeValueHolderInterface.isInstantiated()) {
            Object object;
            NamespaceBo namespaceBo = this._persistence_get_namespace();
            if (namespaceBo != (object = weavedAttributeValueHolderInterface.getValue())) {
                this._persistence_set_namespace((NamespaceBo)((Object)object));
            }
        } else {
            this.namespace = null;
        }
    }

    public NamespaceBo _persistence_get_namespace() {
        this._persistence_checkFetched("namespace");
        this._persistence_initialize_namespace_vh();
        this.namespace = (NamespaceBo)((Object)this._persistence_namespace_vh.getValue());
        return this.namespace;
    }

    public void _persistence_set_namespace(NamespaceBo namespaceBo) {
        this._persistence_checkFetchedForSet("namespace");
        this._persistence_initialize_namespace_vh();
        this.namespace = (NamespaceBo)((Object)this._persistence_namespace_vh.getValue());
        this._persistence_propertyChange("namespace", (Object)this.namespace, (Object)namespaceBo);
        this.namespace = namespaceBo;
        this._persistence_namespace_vh.setValue((Object)namespaceBo);
    }

    public String _persistence_get_evaluationOperatorCode() {
        this._persistence_checkFetched("evaluationOperatorCode");
        return this.evaluationOperatorCode;
    }

    public void _persistence_set_evaluationOperatorCode(String string) {
        this._persistence_checkFetchedForSet("evaluationOperatorCode");
        this._persistence_propertyChange("evaluationOperatorCode", this.evaluationOperatorCode, string);
        this.evaluationOperatorCode = string;
    }

    public String _persistence_get_namespaceCode() {
        this._persistence_checkFetched("namespaceCode");
        return this.namespaceCode;
    }

    public void _persistence_set_namespaceCode(String string) {
        this._persistence_checkFetchedForSet("namespaceCode");
        this._persistence_propertyChange("namespaceCode", this.namespaceCode, string);
        this.namespaceCode = string;
    }

    public String _persistence_get_parameterTypeCode() {
        this._persistence_checkFetched("parameterTypeCode");
        return this.parameterTypeCode;
    }

    public void _persistence_set_parameterTypeCode(String string) {
        this._persistence_checkFetchedForSet("parameterTypeCode");
        this._persistence_propertyChange("parameterTypeCode", this.parameterTypeCode, string);
        this.parameterTypeCode = string;
    }

    protected void _persistence_initialize_derivedComponent_vh() {
        if (this._persistence_derivedComponent_vh == null) {
            this._persistence_derivedComponent_vh = new ValueHolder((Object)this.derivedComponent);
            this._persistence_derivedComponent_vh.setIsNewlyWeavedValueHolder(true);
        }
    }

    public WeavedAttributeValueHolderInterface _persistence_get_derivedComponent_vh() {
        DerivedComponentBo derivedComponentBo;
        this._persistence_initialize_derivedComponent_vh();
        if ((this._persistence_derivedComponent_vh.isCoordinatedWithProperty() || this._persistence_derivedComponent_vh.isNewlyWeavedValueHolder()) && (derivedComponentBo = this._persistence_get_derivedComponent()) != this._persistence_derivedComponent_vh.getValue()) {
            this._persistence_set_derivedComponent(derivedComponentBo);
        }
        return this._persistence_derivedComponent_vh;
    }

    public void _persistence_set_derivedComponent_vh(WeavedAttributeValueHolderInterface weavedAttributeValueHolderInterface) {
        this._persistence_derivedComponent_vh = weavedAttributeValueHolderInterface;
        if (weavedAttributeValueHolderInterface.isInstantiated()) {
            Object object;
            DerivedComponentBo derivedComponentBo = this._persistence_get_derivedComponent();
            if (derivedComponentBo != (object = weavedAttributeValueHolderInterface.getValue())) {
                this._persistence_set_derivedComponent((DerivedComponentBo)((Object)object));
            }
        } else {
            this.derivedComponent = null;
        }
    }

    public DerivedComponentBo _persistence_get_derivedComponent() {
        this._persistence_checkFetched("derivedComponent");
        this._persistence_initialize_derivedComponent_vh();
        this.derivedComponent = (DerivedComponentBo)((Object)this._persistence_derivedComponent_vh.getValue());
        return this.derivedComponent;
    }

    public void _persistence_set_derivedComponent(DerivedComponentBo derivedComponentBo) {
        this._persistence_checkFetchedForSet("derivedComponent");
        this._persistence_initialize_derivedComponent_vh();
        this.derivedComponent = (DerivedComponentBo)((Object)this._persistence_derivedComponent_vh.getValue());
        this._persistence_propertyChange("derivedComponent", (Object)this.derivedComponent, (Object)derivedComponentBo);
        this.derivedComponent = derivedComponentBo;
        this._persistence_derivedComponent_vh.setValue((Object)derivedComponentBo);
    }

    public String _persistence_get_applicationId() {
        this._persistence_checkFetched("applicationId");
        return this.applicationId;
    }

    public void _persistence_set_applicationId(String string) {
        this._persistence_checkFetchedForSet("applicationId");
        this._persistence_propertyChange("applicationId", this.applicationId, string);
        this.applicationId = string;
    }

    public String _persistence_get_value() {
        this._persistence_checkFetched("value");
        return this.value;
    }

    public void _persistence_set_value(String string) {
        this._persistence_checkFetchedForSet("value");
        this._persistence_propertyChange("value", this.value, string);
        this.value = string;
    }
}

