/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.schemaspy.ui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.File;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import net.sourceforge.schemaspy.ui.DbConfigTableModel;
import net.sourceforge.schemaspy.ui.DbTypeSelectorModel;
import net.sourceforge.schemaspy.ui.DirectoryCellEditor;
import net.sourceforge.schemaspy.ui.UiUtils;
import net.sourceforge.schemaspy.util.DbSpecificConfig;

public class DbConfigPanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    private JComboBox databaseTypeSelector;
    private final DbConfigTableModel model = new DbConfigTableModel();
    private JTable table;

    public DbConfigPanel() {
        this.initialize();
    }

    private void initialize() {
        this.table = new JTable(this.model){
            private static final long serialVersionUID = 1L;
            {
                this.setDefaultRenderer(Boolean.TYPE, this.getDefaultRenderer(Boolean.class));
                this.setDefaultEditor(Boolean.TYPE, this.getDefaultEditor(Boolean.class));
                this.setDefaultRenderer(Number.class, this.getDefaultRenderer(String.class));
                this.setDefaultEditor(Number.class, this.getDefaultEditor(String.class));
                DirectoryCellEditor directoryCellEditor = new DirectoryCellEditor(DbConfigPanel.this.model, new File("/"));
                this.setDefaultRenderer(File.class, directoryCellEditor);
                this.setDefaultEditor(File.class, directoryCellEditor);
            }

            @Override
            public TableCellRenderer getCellRenderer(int n, int n2) {
                TableCellRenderer tableCellRenderer = n2 == 0 ? super.getCellRenderer(n, n2) : this.getDefaultRenderer(DbConfigPanel.this.model.getClass(n));
                if (tableCellRenderer instanceof JComponent) {
                    ((JComponent)((Object)tableCellRenderer)).setToolTipText(DbConfigPanel.this.model.getDescription(n));
                }
                return tableCellRenderer;
            }

            @Override
            public TableCellEditor getCellEditor(int n, int n2) {
                return this.getDefaultEditor(DbConfigPanel.this.model.getClass(n));
            }
        };
        this.model.addTableModelListener(new TableModelListener(){

            @Override
            public void tableChanged(TableModelEvent tableModelEvent) {
                TableColumn tableColumn = DbConfigPanel.this.table.getColumnModel().getColumn(0);
                tableColumn.setPreferredWidth(UiUtils.getPreferredColumnWidth(DbConfigPanel.this.table, tableColumn) + 4);
                tableColumn.setMaxWidth(tableColumn.getPreferredWidth());
                DbConfigPanel.this.table.sizeColumnsToFit(0);
            }
        });
        this.setLayout(new BorderLayout());
        JScrollPane jScrollPane = new JScrollPane(this.table);
        jScrollPane.setViewportBorder(null);
        this.add((Component)jScrollPane, "Center");
        this.add((Component)this.getDatabaseTypeSelector(), "North");
    }

    private JComboBox getDatabaseTypeSelector() {
        if (this.databaseTypeSelector == null) {
            DbTypeSelectorModel dbTypeSelectorModel = new DbTypeSelectorModel("ora");
            this.databaseTypeSelector = new JComboBox(dbTypeSelectorModel);
            this.databaseTypeSelector.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent itemEvent) {
                    if (itemEvent.getStateChange() == 1) {
                        DbConfigPanel.this.model.setDbSpecificConfig((DbSpecificConfig)itemEvent.getItem());
                    }
                }
            });
            DbSpecificConfig dbSpecificConfig = (DbSpecificConfig)dbTypeSelectorModel.getSelectedItem();
            if (dbSpecificConfig != null) {
                this.model.setDbSpecificConfig(dbSpecificConfig);
            }
        }
        return this.databaseTypeSelector;
    }
}

