/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.schemaspy.view;

import java.io.IOException;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.TreeSet;
import net.sourceforge.schemaspy.model.Database;
import net.sourceforge.schemaspy.model.Routine;
import net.sourceforge.schemaspy.model.RoutineParameter;
import net.sourceforge.schemaspy.util.LineWriter;
import net.sourceforge.schemaspy.view.HtmlFormatter;

public class HtmlRoutinesPage
extends HtmlFormatter {
    private static HtmlRoutinesPage instance = new HtmlRoutinesPage();

    private HtmlRoutinesPage() {
    }

    public static HtmlRoutinesPage getInstance() {
        return instance;
    }

    public void write(Database database, LineWriter lineWriter) throws IOException {
        TreeSet<Routine> treeSet = new TreeSet<Routine>(database.getRoutines());
        this.writeHeader(database, treeSet, lineWriter);
        for (Routine routine : treeSet) {
            this.write(routine, lineWriter);
        }
        this.writeFooter(lineWriter);
    }

    private void writeHeader(Database database, Collection<Routine> collection, LineWriter lineWriter) throws IOException {
        this.writeHeader(database, null, "Procedures and Functions", lineWriter);
        lineWriter.writeln("<table width='100%'>");
        lineWriter.writeln(" <tr>");
        lineWriter.write("  <td class='container'>");
        this.writeGeneratedOn(database.getConnectTime(), lineWriter);
        lineWriter.writeln("  </td>");
        if (this.sourceForgeLogoEnabled()) {
            lineWriter.writeln("  <td class='container' align='right' valign='top' colspan='2'><a href='http://sourceforge.net' target='_blank'><img src='http://sourceforge.net/sflogo.php?group_id=137197&amp;type=1' alt='SourceForge.net' border='0' height='31' width='88'></a></td>");
        }
        lineWriter.writeln(" </tr>");
        lineWriter.writeln(" <tr>");
        lineWriter.writeln("  <td class='container'>");
        int n = 0;
        int n2 = 0;
        for (Routine routine : collection) {
            String string = routine.getType().toLowerCase();
            if (string.startsWith("proc")) {
                ++n;
                continue;
            }
            if (!string.startsWith("func")) continue;
            ++n2;
        }
        lineWriter.write("   <br><b>");
        lineWriter.write(database.getName());
        if (database.getSchema() != null) {
            lineWriter.write(46);
            lineWriter.write(database.getSchema());
        } else if (database.getCatalog() != null) {
            lineWriter.write(46);
            lineWriter.write(database.getCatalog());
        }
        lineWriter.write(" contains " + n + " procedures and " + n2 + " functions:");
        lineWriter.write("</b><br><div class='indent'>");
        for (Routine routine : collection) {
            lineWriter.write("<a href='#" + routine.getName() + "'>" + routine.getName() + "</a>&nbsp;&nbsp;");
        }
        lineWriter.writeln("</div>");
        lineWriter.writeln("  </td>");
        lineWriter.writeln(" </tr>");
        lineWriter.writeln(" <tr><td colspan='3'>");
    }

    private void write(Routine routine, LineWriter lineWriter) throws IOException {
        Object object;
        lineWriter.writeln("  <br><a id='" + routine.getName() + "'></a><hr>");
        lineWriter.write("  <br><code><b>" + routine.getType() + " " + routine.getName());
        lineWriter.write(40);
        List<RoutineParameter> list = routine.getParameters();
        Iterator<RoutineParameter> iterator = list.iterator();
        while (iterator.hasNext()) {
            object = iterator.next();
            if (((RoutineParameter)object).getMode() != null) {
                lineWriter.write(((RoutineParameter)object).getMode());
                lineWriter.write(32);
            }
            if (((RoutineParameter)object).getName() != null) {
                lineWriter.write(((RoutineParameter)object).getName());
                lineWriter.write(32);
            }
            if (((RoutineParameter)object).getType() != null) {
                lineWriter.write(((RoutineParameter)object).getType());
            }
            if (!iterator.hasNext()) continue;
            lineWriter.write(", ");
        }
        lineWriter.write(") ");
        if (routine.getReturnType() != null) {
            lineWriter.write("RETURNS ");
            lineWriter.writeln(routine.getReturnType());
        }
        lineWriter.writeln("</b><br>");
        object = "   &nbsp;&nbsp;&nbsp;";
        if (routine.getDefinitionLanguage() != null && routine.getDefinitionLanguage().length() > 0) {
            lineWriter.writeln((String)object + "LANGUAGE " + routine.getDefinitionLanguage() + "<br>");
        }
        if (routine.getType().toLowerCase().startsWith("func")) {
            lineWriter.write((String)object);
            if (!routine.isDeterministic()) {
                lineWriter.write("NOT ");
            }
            lineWriter.writeln("DETERMINISTIC<br>");
        }
        if (routine.getDataAccess() != null && routine.getDataAccess().length() > 0) {
            lineWriter.writeln((String)object + routine.getDataAccess() + "<br>");
        }
        if (routine.getSecurityType() != null && routine.getSecurityType().length() > 0) {
            lineWriter.writeln((String)object + "SQL SECURITY " + routine.getSecurityType() + "<br>");
        }
        if (routine.getComment() != null && routine.getComment().length() > 0) {
            lineWriter.writeln((String)object + "COMMENT '" + routine.getComment() + "'<br>");
        }
        lineWriter.writeln("</code>");
        if (routine.getDefinition() != null && routine.getDefinition().length() > 0) {
            lineWriter.writeln("<pre>");
            lineWriter.writeln(routine.getDefinition());
            lineWriter.writeln("</pre>");
        }
    }

    @Override
    protected void writeFooter(LineWriter lineWriter) throws IOException {
        lineWriter.writeln("</td></tr></table>");
        super.writeFooter(lineWriter);
    }

    @Override
    protected boolean isRoutinesPage() {
        return true;
    }
}

