<?xml version="1.0" encoding="UTF-8"?>
<!--
  #%L
  %%
  Copyright (C) 2014 - 2019 Kuali, Inc. - All Rights Reserved
  %%
  You may use and modify this code under the terms of the Kuali, Inc.
  Pre-Release License Agreement. You may not distribute it.
  
  You should have received a copy of the Kuali, Inc. Pre-Release License
  Agreement with this file. If not, please write to license@kuali.co.
  #L%
  -->

<xsl:stylesheet version="1.0"
	xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
	xmlns:HumanSubjectStudy="http://apply.grants.gov/forms/HumanSubjectStudy-V1.0"
	xmlns:att="http://apply.grants.gov/system/Attachments-V1.0"
	xmlns:codes="http://apply.grants.gov/system/UniversalCodes-V2.0"
	xmlns:fn="http://www.w3.org/2005/xpath-functions" xmlns:glob="http://apply.grants.gov/system/Global-V1.0"
	xmlns:globLib="http://apply.grants.gov/system/GlobalLibrary-V2.0"
	xmlns:xdt="http://www.w3.org/2005/xpath-datatypes" xmlns:xs="http://www.w3.org/2001/XMLSchema"
	xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" xmlns:header="http://apply.grants.gov/system/Header-V1.0"
	xmlns:footer="http://apply.grants.gov/system/Footer-V1.0" xmlns:fo="http://www.w3.org/1999/XSL/Format">
	
	<xsl:param name="studyNumber" />
	<xsl:variable name="studyTitle" select="HumanSubjectStudy:StudyTitle"/>

	<xsl:template match="HumanSubjectStudy:HumanSubjectStudy">
		<fo:root>
			<fo:layout-master-set>
				<fo:simple-page-master master-name="rest"
					page-height="11in" page-width="8.5in" margin-left="0.6in"
					margin-right="0.6in">
					<fo:region-body margin-top="0.5in" margin-bottom="0.6in" />
					<fo:region-before region-name="header" />
					<fo:region-after region-name="footer" extent="0.6in" />
				</fo:simple-page-master>
				<fo:page-sequence-master master-name="all-pages">
					<fo:repeatable-page-master-alternatives>
						<fo:conditional-page-master-reference
							master-reference="rest" page-position="rest" />
					</fo:repeatable-page-master-alternatives>
				</fo:page-sequence-master>
			</fo:layout-master-set>

			<!-- Study -->
			<fo:page-sequence master-reference="rest" format="1">

				<fo:static-content flow-name="footer">
					<fo:table width="100%" space-before.optimum="0pt"
						space-after.optimum="0pt" table-layout="fixed">
						<fo:table-column column-width="proportional-column-width(1)" />
						<fo:table-column column-width="proportional-column-width(1)" />
						<fo:table-body>
							<fo:table-row>
								<fo:table-cell hyphenate="true" language="en"
									padding-start="0pt" padding-end="0pt" padding-before="1pt"
									padding-after="1pt" display-align="before" text-align="left"
									border-style="solid" border-width="0pt" border-color="white">
									<fo:block>
										<fo:inline font-size="8px">
											Tracking Number:
											<xsl:value-of select="/*/*/footer:Grants_govTrackingNumber" />
										</fo:inline>
									</fo:block>
								</fo:table-cell>
								<fo:table-cell hyphenate="true" language="en"
									line-height="9pt" padding-start="0pt" padding-end="0pt"
									padding-before="1pt" padding-after="20pt" display-align="before"
									text-align="right" border-style="solid" border-width="0pt"
									border-color="white">
									<fo:block>
										<fo:inline font-size="8px">
											Funding Opportunity Number:
											<xsl:value-of select="/*/*/header:OpportunityID" />
										</fo:inline>
										<fo:inline font-size="8px">
											Received Date:
											<xsl:value-of select="/*/*/footer:ReceivedDateTime" />
										</fo:inline>
									</fo:block>
								</fo:table-cell>
							</fo:table-row>
						</fo:table-body>
					</fo:table>
				</fo:static-content>

				<fo:flow flow-name="xsl-region-body">
					<xsl:call-template name="humanSubjectStudiesSection2" />
				</fo:flow>
			</fo:page-sequence>
		</fo:root>
	</xsl:template>

	<!-- PHS Human Subjects and Clinical Trials Information -> Study -> Section 2 -->
	<xsl:template name="humanSubjectStudiesSection2">
		<fo:block>
			<fo:table width="100%" table-layout="fixed" 
				left="100pt" font-size="9px">
				<fo:table-column column-width="5%" />
				<fo:table-column column-width="15%" />
				<fo:table-column column-width="20%" />
				<fo:table-column column-width="20%" />
				<fo:table-column column-width="20%" />
				<fo:table-column column-width="20%" />

				<fo:table-body start-indent="0pt">
					<fo:table-row>
						<fo:table-cell number-columns-spanned="6">
							<fo:block padding="10pt" font-weight="bold" >
								<fo:inline font-size="10px" padding="4pt">
									<xsl:text>Section 2 - Study Population Characteristics</xsl:text> (Study <xsl:value-of select="$studyNumber" />)
								</fo:inline>
							</fo:block>
						</fo:table-cell>
					</fo:table-row>
					
					<!--  2.1 Conditions or Focus of Study -->
					<fo:table-row>
						<xsl:call-template name="label">
							<xsl:with-param name="number-columns-spanned" select="6" />
							<xsl:with-param name="label_text">
								2.1. Conditions or Focus of Study
							</xsl:with-param>
						</xsl:call-template>
					</fo:table-row>
					
					<xsl:for-each select="HumanSubjectStudy:StudyPopulationCharacteristics/HumanSubjectStudy:StudyConditions">
						<fo:table-row>
							<fo:table-cell number-columns-spanned="1"
								padding-start="18pt" 
								padding-before="3pt" padding-after="6pt" font-size="4px"  font-family="ZapfDingbats">
								<fo:block>&#x274D;</fo:block>
							</fo:table-cell>
							<xsl:call-template name="text-field">
								<xsl:with-param name="number-columns-spanned" select="5" />
								<xsl:with-param name="field_value" select="."/>
							</xsl:call-template>
						</fo:table-row>
					</xsl:for-each>					

					<!-- 2.2 Eligibility Criteria -->
					<fo:table-row>
						<xsl:call-template name="label">
							<xsl:with-param name="label_text">
								2.2. Eligibility Criteria
							</xsl:with-param>
						</xsl:call-template>
					</fo:table-row>
					
					<fo:table-row>
						<xsl:call-template name="text-field">
							<xsl:with-param name="padding-start" select="18" />
							<xsl:with-param name="number-columns-spanned" select="6" />
							<xsl:with-param name="field_value" select="HumanSubjectStudy:StudyPopulationCharacteristics/HumanSubjectStudy:EligibilityCriteria"/>
						</xsl:call-template>
					</fo:table-row>
					
					<fo:table-row>
						<xsl:call-template name="label">
							<xsl:with-param name="label_text">
								2.3. Age Limits
							</xsl:with-param>
						</xsl:call-template>
						<xsl:call-template name="nested_field">
						</xsl:call-template>
					</fo:table-row>			
			
					<fo:table-row>
						<xsl:call-template name="label">
							<xsl:with-param name="label_text">
								2.4. Inclusion of Women, Minorities, and Children
							</xsl:with-param>
						</xsl:call-template>
						<xsl:call-template name="text-field">
							<xsl:with-param name="field_value" select="HumanSubjectStudy:StudyPopulationCharacteristics/HumanSubjectStudy:InclusionOfWomenAndMinorities/HumanSubjectStudy:attFile/att:FileName"/>
						</xsl:call-template>
					</fo:table-row>

					<fo:table-row>
						<xsl:call-template name="label">
							<xsl:with-param name="label_text">
								2.5. Recruitment and Retention Plan
							</xsl:with-param>
						</xsl:call-template>
						<xsl:call-template name="text-field">
							<xsl:with-param name="field_value" select="HumanSubjectStudy:StudyPopulationCharacteristics/HumanSubjectStudy:RecruitmentAndRetentionPlan/HumanSubjectStudy:attFile/att:FileName"/>
						</xsl:call-template>
					</fo:table-row>
					
					<fo:table-row>
						<xsl:call-template name="label">
							<xsl:with-param name="label_text">
								2.6. Recruitment Status
							</xsl:with-param>
						</xsl:call-template>
						<xsl:call-template name="text-field">
							<xsl:with-param name="field_value" select="HumanSubjectStudy:StudyPopulationCharacteristics/HumanSubjectStudy:RecruitmentStatus"/>
						</xsl:call-template>
					</fo:table-row>
					
					<fo:table-row>
						<xsl:call-template name="label">
							<xsl:with-param name="label_text">
								2.7. Study Timeline
							</xsl:with-param>
						</xsl:call-template>
						<xsl:call-template name="text-field">
							<xsl:with-param name="field_value" select="HumanSubjectStudy:StudyPopulationCharacteristics/HumanSubjectStudy:StudyTimeline/HumanSubjectStudy:attFile/att:FileName"/>
						</xsl:call-template>
					</fo:table-row>
					
					<fo:table-row>
						<xsl:call-template name="label">
							<xsl:with-param name="label_text">
								2.8. Enrollment of First Subject
							</xsl:with-param>
						</xsl:call-template>
						<xsl:call-template name="formatDate">
							<xsl:with-param name="field_value" select="HumanSubjectStudy:StudyPopulationCharacteristics/HumanSubjectStudy:FirstSubjectEnrollment/HumanSubjectStudy:EnrollmentDate"/>
						</xsl:call-template>
						<xsl:call-template name="text-field1">
							<xsl:with-param name="field_value" select="HumanSubjectStudy:StudyPopulationCharacteristics/HumanSubjectStudy:FirstSubjectEnrollment/HumanSubjectStudy:AnticipatedActual"/>
						</xsl:call-template>
					</fo:table-row>
				</fo:table-body>
			</fo:table>
		</fo:block>
		<fo:block page-break-before="always">
			<fo:table width="100%" table-layout="fixed" 
				left="100pt" font-size="9px">
				<fo:table-column column-width="5%" />
				<fo:table-column column-width="15%" />
				<fo:table-column column-width="20%" />
				<fo:table-column column-width="20%" />
				<fo:table-column column-width="20%" />
				<fo:table-column column-width="20%" />

				<fo:table-body start-indent="0pt">
					<fo:table-row >
						<xsl:call-template name="bold_label">
							<xsl:with-param name="label_text">
								Inclusion Enrollment Reports
							</xsl:with-param>
						</xsl:call-template>
					</fo:table-row>
					
					<fo:table-row>
						<xsl:call-template name="ier_summary">
						</xsl:call-template>
					</fo:table-row>
				</fo:table-body>
			</fo:table>
		</fo:block>
	</xsl:template>
	 <!-- End of Section 1 -->
	 
	 
	<!-- Utility Templates -->
	<xsl:template name="ier_summary">
		<fo:table-cell number-columns-spanned="6"
			padding-start="3pt" padding-end="3pt" padding-before="1pt"
			padding-after="6pt" font-size="9px" font-family="arialuni">
			<fo:block>
				<fo:table width="100%" table-layout="fixed" border-style="solid"
							border-width="1pt" border-color="black">
					<fo:table-column column-width="20%" />
					<fo:table-column column-width="25%" />
					<fo:table-column column-width="55%" />
					
					<fo:table-body>
						<fo:table-row>
							<xsl:call-template name="table_header_cell">
								<xsl:with-param name="label_text">Entry#</xsl:with-param>
							</xsl:call-template>
							<xsl:call-template name="table_header_cell">
								<xsl:with-param name="label_text">Enrollment Location Type</xsl:with-param>
							</xsl:call-template>
							<xsl:call-template name="table_header_cell">
								<xsl:with-param name="label_text">Enrollment Location</xsl:with-param>
							</xsl:call-template>
						</fo:table-row>
						<xsl:choose>
							<xsl:when test="count(HumanSubjectStudy:StudyPopulationCharacteristics/HumanSubjectStudy:InclusionEnrollmentReport) > 0">
								<xsl:for-each select="HumanSubjectStudy:StudyPopulationCharacteristics/HumanSubjectStudy:InclusionEnrollmentReport">
								<xsl:variable name="nodeCount" select="position()"/>
								<fo:table-row>
									<xsl:call-template name="table_body_cell">
										<xsl:with-param name="label_text" select="concat('Study ', (concat($studyNumber, concat(', IER ', $nodeCount))))" />
									</xsl:call-template>
									<xsl:call-template name="table_body_cell">
										<xsl:with-param name="label_text" select="HumanSubjectStudy:EnrollmentLocationType"/>
									</xsl:call-template>
									<xsl:call-template name="table_body_cell">
										<xsl:with-param name="label_text" select="HumanSubjectStudy:EnrollmentLocations"/>
									</xsl:call-template>
								</fo:table-row>
								</xsl:for-each>
							</xsl:when>
							<xsl:otherwise>
								<fo:table-row>
									<fo:table-cell number-columns-spanned="3"
										padding="3pt" border-style="solid" border-width="1pt" border-color="black"  text-align="left" font-family="arialuni">
										<fo:block>The study does not have any IERs
										</fo:block>
									</fo:table-cell>
								</fo:table-row>
							</xsl:otherwise>
						</xsl:choose>
					</fo:table-body>
				</fo:table>
			</fo:block>
		</fo:table-cell>
	</xsl:template>
	
	<xsl:template name="table_header_cell">	
		<xsl:param name="label_text" />
		<fo:table-cell padding="3pt" border-style="solid"
			border-width="1pt" border-color="black" background-color="#EEEEEE">
			<fo:block>				
				<fo:inline font-weight="bold">
					<xsl:value-of select="$label_text" />
				</fo:inline>
			</fo:block>
		</fo:table-cell>
	</xsl:template>
	
	<xsl:template name="table_body_cell">
		<xsl:param name="label_text" />	
		<fo:table-cell padding="3pt" hyphenate="true" border-style="solid" border-width="1pt" border-color="black" page-break-inside="avoid">
			<fo:block>
				<xsl:value-of select="$label_text" />
			</fo:block>
		</fo:table-cell>
	</xsl:template>
	
	<!--  Create label with display text, ${label_text} -->
	<xsl:template name="label">
		<xsl:param name="number-columns-spanned" select="3" />
		<xsl:param name="label_text" />
		<fo:table-cell number-columns-spanned="{$number-columns-spanned}"
			padding-start="3pt" padding-end="3pt"
			padding-before="1pt" padding-after="6pt" font-family="arialuni">
			<fo:block>
				<xsl:value-of select="$label_text" />
			</fo:block>
		</fo:table-cell>
	</xsl:template>
	
	<xsl:template name="bold_label">
		<xsl:param name="number-columns-spanned" select="3" />
		<xsl:param name="label_text" />
		<fo:table-cell number-columns-spanned="{$number-columns-spanned}"
			padding-start="3pt" padding-end="3pt"
			padding-before="6pt" padding-after="6pt" font-weight="bold">
			<fo:block id="concat('section2_', $studyTitle)" >
				<xsl:value-of select="$label_text" />
			</fo:block>
		</fo:table-cell>
	</xsl:template>
	
	<!-- A generic field value area: $field_value will be displayed in the cell -->
	<xsl:template name="text-field">
		<xsl:param name="padding-start" select="3" />
		<xsl:param name="field_value" />
		<xsl:param name="number-columns-spanned" select="3" />
		
		<fo:table-cell number-columns-spanned="{$number-columns-spanned}"
			padding-start="{$padding-start}" padding-end="3pt"
			padding-before="1pt" padding-after="6pt" font-family="arialuni">
			<fo:block>
				<xsl:value-of select="$field_value" />
			</fo:block>
		</fo:table-cell>
	</xsl:template>

	<!-- A nested table with 4 columns -->
	<xsl:template name="nested_field">
		<fo:table-cell number-columns-spanned="3" 
			padding-start="3pt" padding-end="3pt" 
			padding-before="1pt" padding-after="6pt" font-family="arialuni">
			<fo:block>
				<fo:table width="100%" table-layout="fixed">
					<fo:table-column column-width="15%" />
					<fo:table-column column-width="35%" />
					<fo:table-column column-width="15%" />
					<fo:table-column column-width="35%" />
					<fo:table-body>
						<fo:table-row>
							<fo:table-cell><fo:block>Min Age:</fo:block></fo:table-cell>
							<fo:table-cell><fo:block><xsl:value-of select="HumanSubjectStudy:StudyPopulationCharacteristics/HumanSubjectStudy:AgeLimits/HumanSubjectStudy:MinimumAge" /></fo:block></fo:table-cell>
							<fo:table-cell><fo:block>Max Age:</fo:block></fo:table-cell>
							<fo:table-cell><fo:block><xsl:value-of select="HumanSubjectStudy:StudyPopulationCharacteristics/HumanSubjectStudy:AgeLimits/HumanSubjectStudy:MaximumAge" /></fo:block></fo:table-cell>
						</fo:table-row>
					</fo:table-body>
				</fo:table>
			</fo:block>
		</fo:table-cell>
	</xsl:template>
	
	<xsl:template name="formatDate">
   		<xsl:param name="padding-start" select="3" />
		<xsl:param name="field_value" />
		<xsl:param name="number-columns-spanned" select="1" />
		
		<fo:table-cell number-columns-spanned="{$number-columns-spanned}"
			padding-start="{$padding-start}" padding-end="3pt"
			padding-before="1pt" padding-after="6pt" font-family="arialuni">
			<fo:block>
				      <xsl:if test="$field_value != ''">
         					<xsl:value-of select="format-number(substring($field_value,6,2), '00')"/>
         					<xsl:text>/</xsl:text>
         					<xsl:value-of select="format-number(substring($field_value,9,2), '00')"/>
         					<xsl:text>/</xsl:text>
         					<xsl:value-of select="format-number(substring($field_value,1,4), '0000')"/>
         			</xsl:if>
			</fo:block>
		</fo:table-cell>
   </xsl:template>
   	<xsl:template name="text-field1">
		<xsl:param name="padding-start" select="3" />
		<xsl:param name="field_value" />
		<xsl:param name="number-columns-spanned" select="2" />
		
		<fo:table-cell number-columns-spanned="{$number-columns-spanned}"
			padding-start="{$padding-start}" padding-end="3pt"
			padding-before="1pt" padding-after="6pt" font-family="arialuni">
			<fo:block>
				<xsl:value-of select="$field_value" />
			</fo:block>
		</fo:table-cell>
	</xsl:template>
</xsl:stylesheet>
