/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.propdev.impl.s2s;

import java.sql.Timestamp;
import java.util.Date;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.Lob;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import javax.persistence.Transient;
import org.kuali.coeus.common.framework.attachment.KcAttachmentService;
import org.kuali.coeus.propdev.api.s2s.S2sApplicationContract;
import org.kuali.coeus.propdev.impl.s2s.S2sAppAttachments;
import org.kuali.coeus.sys.framework.model.KcPersistableBusinessObjectBase;
import org.kuali.coeus.sys.framework.service.KcServiceLocator;
import org.kuali.rice.core.api.datetime.DateTimeService;
import org.kuali.rice.krad.file.FileMeta;
import org.springframework.web.multipart.MultipartFile;

@Entity
@Table(name="S2S_APPLICATION")
public class S2sApplication
extends KcPersistableBusinessObjectBase
implements S2sApplicationContract,
FileMeta {
    @Id
    @Column(name="PROPOSAL_NUMBER")
    private String proposalNumber;
    @Column(name="APPLICATION")
    @Lob
    private String application;
    @Transient
    private transient String url;
    @Transient
    private transient DateTimeService dateTimeService;
    @Transient
    private transient KcAttachmentService kcAttachmentService;
    @OneToMany(orphanRemoval=true, cascade={CascadeType.ALL})
    @JoinColumn(name="PROPOSAL_NUMBER", referencedColumnName="PROPOSAL_NUMBER")
    private List<S2sAppAttachments> s2sAppAttachmentList;

    public String getProposalNumber() {
        return this.proposalNumber;
    }

    public void setProposalNumber(String proposalNumber) {
        this.proposalNumber = proposalNumber;
    }

    public String getApplication() {
        return this.application;
    }

    public void setApplication(String application) {
        this.application = application;
    }

    public List<S2sAppAttachments> getS2sAppAttachmentList() {
        return this.s2sAppAttachmentList;
    }

    public void setS2sAppAttachmentList(List<S2sAppAttachments> s2sAppAttachmentList) {
        this.s2sAppAttachmentList = s2sAppAttachmentList;
    }

    public void init(MultipartFile multipartFile) {
    }

    public String getId() {
        return this.getProposalNumber();
    }

    public void setId(String id) {
        this.setProposalNumber(id);
    }

    public String getName() {
        return "Grant Application.xml";
    }

    public void setName(String name) {
    }

    public String getContentType() {
        return "text/xml";
    }

    public void setContentType(String contentType) {
    }

    public Long getSize() {
        return this.application.length();
    }

    public void setSize(Long size) {
    }

    public String getSizeFormatted() {
        return this.getKcAttachmentService().formatFileSizeString(this.getSize());
    }

    public Date getDateUploaded() {
        return this.getUpdateTimestamp();
    }

    public void setDateUploaded(Date dateUploaded) {
        this.setUpdateTimestamp(new Timestamp(dateUploaded.getTime()));
    }

    public String getDateUploadedFormatted() {
        if (this.getUpdateTimestamp() != null) {
            return this.getDateTimeService().toString(new Date(this.getUpdateTimestamp().getTime()), "MM/dd/yyyy hh:mm a");
        }
        return "";
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public DateTimeService getDateTimeService() {
        if (this.dateTimeService == null) {
            this.dateTimeService = KcServiceLocator.getService(DateTimeService.class);
        }
        return this.dateTimeService;
    }

    public void setDateTimeService(DateTimeService dateTimeService) {
        this.dateTimeService = dateTimeService;
    }

    public KcAttachmentService getKcAttachmentService() {
        if (this.kcAttachmentService == null) {
            this.kcAttachmentService = KcServiceLocator.getService(KcAttachmentService.class);
        }
        return this.kcAttachmentService;
    }

    public void setKcAttachmentService(KcAttachmentService kcAttachmentService) {
        this.kcAttachmentService = kcAttachmentService;
    }
}

