/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.timeandmoney.document.authorization;

import java.util.Map;
import org.kuali.kra.timeandmoney.document.TimeAndMoneyDocument;
import org.kuali.rice.kim.api.identity.Person;
import org.kuali.rice.kns.document.authorization.TransactionalDocumentAuthorizerBase;
import org.kuali.rice.krad.bo.BusinessObject;
import org.kuali.rice.krad.document.Document;

public class TimeAndMoneyDocumentAuthorizer
extends TransactionalDocumentAuthorizerBase {
    public static final String CREATE_TIME_AND_MONEY_PERMISSION = "Create Time And Money Document";

    public boolean canRoute(Document document, Person user) {
        TimeAndMoneyDocument tmDocument = (TimeAndMoneyDocument)document;
        boolean canRoute = !this.isFinal(document) && !this.isProcessed(document) && this.hasPermission(tmDocument, user, "Submit Time And Money Document");
        return canRoute;
    }

    protected boolean isFinal(Document document) {
        return "F".equals(document.getDocumentHeader().getWorkflowDocument().getStatus().getCode());
    }

    protected boolean isProcessed(Document document) {
        boolean isProcessed = false;
        String status = document.getDocumentHeader().getWorkflowDocument().getStatus().getCode();
        if (status.equalsIgnoreCase("P")) {
            isProcessed = true;
        }
        return isProcessed;
    }

    protected void addRoleQualification(Object primaryBusinessObjectOrDocument, Map<String, String> attributes) {
        super.addRoleQualification(primaryBusinessObjectOrDocument, attributes);
        TimeAndMoneyDocument timeAndMoneyDocument = (TimeAndMoneyDocument)primaryBusinessObjectOrDocument;
        if (timeAndMoneyDocument.getAward() != null && timeAndMoneyDocument.getAward().getLeadUnit() != null) {
            attributes.put("unitNumber", timeAndMoneyDocument.getAward().getLeadUnit().getUnitNumber());
        } else {
            attributes.put("unitNumber", "*");
        }
    }

    public boolean hasCreatePermission(TimeAndMoneyDocument timeAndMoneyDocument, Person user) {
        boolean retVal = this.hasPermission(timeAndMoneyDocument, user, CREATE_TIME_AND_MONEY_PERMISSION);
        return retVal;
    }

    private boolean hasPermission(TimeAndMoneyDocument timeAndMoneyDocument, Person user, String permissionName) {
        return this.isAuthorized((BusinessObject)timeAndMoneyDocument, "KC-T", permissionName, user.getPrincipalId());
    }
}

