/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kew.rule;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.kuali.rice.core.api.exception.RiceIllegalStateException;
import org.kuali.rice.kew.api.KewApiServiceLocator;
import org.kuali.rice.kew.engine.RouteContext;
import org.kuali.rice.kew.engine.node.NodeState;
import org.kuali.rice.kew.engine.node.RouteNode;
import org.kuali.rice.kew.engine.node.RouteNodeInstance;
import org.kuali.rice.kew.routeheader.DocumentRouteHeaderValue;
import org.kuali.rice.kew.rule.Rule;
import org.kuali.rice.kew.rule.RuleImpl;
import org.kuali.rice.kew.rule.RuleSelector;
import org.kuali.rice.kew.util.Utilities;

public class NamedRuleSelector
implements RuleSelector {
    public static final String RULE_NAME_CFG_KEY = "ruleName";

    protected String getName(RouteContext context, DocumentRouteHeaderValue routeHeader, RouteNodeInstance nodeInstance, String selectionCriterion, Timestamp effectiveDate) {
        String ruleName = null;
        RouteNode routeNodeDef = nodeInstance.getRouteNode();
        NodeState ns = nodeInstance.getNodeState("__RULE_NAME__");
        if (ns != null) {
            ruleName = ns.getValue();
        } else {
            Map<String, String> routeNodeConfig = Utilities.getKeyValueCollectionAsMap(routeNodeDef.getConfigParams());
            ruleName = routeNodeConfig.get(RULE_NAME_CFG_KEY);
        }
        return ruleName;
    }

    @Override
    public List<Rule> selectRules(RouteContext context, DocumentRouteHeaderValue routeHeader, RouteNodeInstance nodeInstance, String selectionCriterion, Timestamp effectiveDate) {
        String ruleName = this.getName(context, routeHeader, nodeInstance, selectionCriterion, effectiveDate);
        if (ruleName == null) {
            throw new RiceIllegalStateException("No 'ruleName' configuration parameter present on route node definition: " + nodeInstance.getRouteNode());
        }
        org.kuali.rice.kew.api.rule.Rule ruleDef = KewApiServiceLocator.getRuleService().getRuleByName(ruleName);
        if (ruleDef == null) {
            throw new RiceIllegalStateException("No rule found with name '" + ruleName + "'");
        }
        ArrayList<Rule> rules = new ArrayList<Rule>(1);
        rules.add(new RuleImpl(ruleDef));
        return rules;
    }
}

