/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.script;

import java.io.IOException;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.elasticsearch.ResourceNotFoundException;
import org.elasticsearch.Version;
import org.elasticsearch.cluster.Diff;
import org.elasticsearch.cluster.DiffableUtils;
import org.elasticsearch.cluster.NamedDiff;
import org.elasticsearch.cluster.metadata.MetaData;
import org.elasticsearch.common.ParsingException;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.common.logging.DeprecationLogger;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.ToXContentFragment;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.script.StoredScriptSource;

public final class ScriptMetaData
implements MetaData.Custom,
Writeable,
ToXContentFragment {
    private static final DeprecationLogger DEPRECATION_LOGGER = new DeprecationLogger(LogManager.getLogger(ScriptMetaData.class));
    public static final String TYPE = "stored_scripts";
    private final Map<String, StoredScriptSource> scripts;

    static ScriptMetaData putStoredScript(ScriptMetaData previous, String id, StoredScriptSource source) {
        Builder builder = new Builder(previous);
        builder.storeScript(id, source);
        return builder.build();
    }

    static ScriptMetaData deleteStoredScript(ScriptMetaData previous, String id) {
        Builder builder = new Builder(previous);
        builder.deleteScript(id);
        return builder.build();
    }

    public static ScriptMetaData fromXContent(XContentParser parser) throws IOException {
        HashMap<String, StoredScriptSource> scripts = new HashMap<String, StoredScriptSource>();
        String id = null;
        XContentParser.Token token = parser.currentToken();
        if (token == null) {
            token = parser.nextToken();
        }
        if (token != XContentParser.Token.START_OBJECT) {
            throw new ParsingException(parser.getTokenLocation(), "unexpected token [" + token + "], expected [{]", new Object[0]);
        }
        token = parser.nextToken();
        while (token != XContentParser.Token.END_OBJECT) {
            switch (token) {
                case FIELD_NAME: {
                    id = parser.currentName();
                    break;
                }
                case VALUE_STRING: {
                    StoredScriptSource exists;
                    if (id == null) {
                        throw new ParsingException(parser.getTokenLocation(), "unexpected token [" + token + "], expected [<id>, <code>, {]", new Object[0]);
                    }
                    int split = id.indexOf(35);
                    if (split == -1) {
                        throw new IllegalArgumentException("illegal stored script id [" + id + "], does not contain lang");
                    }
                    String lang = id.substring(0, split);
                    id = id.substring(split + 1);
                    StoredScriptSource source = new StoredScriptSource(lang, parser.text(), Collections.emptyMap());
                    if (source.getSource().isEmpty()) {
                        if (source.getLang().equals("mustache")) {
                            DEPRECATION_LOGGER.deprecated("empty templates should no longer be used", new Object[0]);
                        } else {
                            DEPRECATION_LOGGER.deprecated("empty scripts should no longer be used", new Object[0]);
                        }
                    }
                    if ((exists = (StoredScriptSource)scripts.get(id)) == null) {
                        scripts.put(id, source);
                    } else if (!exists.getLang().equals(lang)) {
                        throw new IllegalArgumentException("illegal stored script, id [" + id + "] used for multiple scripts with different languages [" + exists.getLang() + "] and [" + lang + "]; scripts using the old namespace of [lang#id] as a stored script id will have to be updated to use only the new namespace of [id]");
                    }
                    id = null;
                    break;
                }
                case START_OBJECT: {
                    if (id == null) {
                        throw new ParsingException(parser.getTokenLocation(), "unexpected token [" + token + "], expected [<id>, <code>, {]", new Object[0]);
                    }
                    StoredScriptSource exists = (StoredScriptSource)scripts.get(id);
                    StoredScriptSource source = StoredScriptSource.fromXContent(parser, true);
                    if (exists == null) {
                        scripts.put(id, source);
                    } else if (!exists.getLang().equals(source.getLang())) {
                        throw new IllegalArgumentException("illegal stored script, id [" + id + "] used for multiple scripts with different languages [" + exists.getLang() + "] and [" + source.getLang() + "]; scripts using the old namespace of [lang#id] as a stored script id will have to be updated to use only the new namespace of [id]");
                    }
                    id = null;
                    break;
                }
                default: {
                    throw new ParsingException(parser.getTokenLocation(), "unexpected token [" + token + "], expected [<id>, <code>, {]", new Object[0]);
                }
            }
            token = parser.nextToken();
        }
        return new ScriptMetaData(scripts);
    }

    public static NamedDiff<MetaData.Custom> readDiffFrom(StreamInput in) throws IOException {
        return new ScriptMetadataDiff(in);
    }

    ScriptMetaData(Map<String, StoredScriptSource> scripts) {
        this.scripts = Collections.unmodifiableMap(scripts);
    }

    public ScriptMetaData(StreamInput in) throws IOException {
        HashMap<String, StoredScriptSource> scripts = new HashMap<String, StoredScriptSource>();
        int size = in.readVInt();
        for (int i = 0; i < size; ++i) {
            StoredScriptSource source;
            String id = in.readString();
            if (in.getVersion().before(Version.V_5_3_0)) {
                int split = id.indexOf(35);
                if (split == -1) {
                    throw new IllegalArgumentException("illegal stored script id [" + id + "], does not contain lang");
                }
                source = new StoredScriptSource(in);
                source = new StoredScriptSource(id.substring(0, split), source.getSource(), Collections.emptyMap());
            } else {
                source = new StoredScriptSource(in);
            }
            scripts.put(id, source);
        }
        this.scripts = Collections.unmodifiableMap(scripts);
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        if (out.getVersion().onOrAfter(Version.V_5_3_0)) {
            out.writeVInt(this.scripts.size());
            for (Map.Entry<String, StoredScriptSource> entry : this.scripts.entrySet()) {
                out.writeString(entry.getKey());
                entry.getValue().writeTo(out);
            }
        } else {
            HashMap<String, StoredScriptSource> filtered = new HashMap<String, StoredScriptSource>();
            for (Map.Entry<String, StoredScriptSource> entry : this.scripts.entrySet()) {
                if (!entry.getKey().contains("#")) continue;
                filtered.put(entry.getKey(), entry.getValue());
            }
            out.writeVInt(filtered.size());
            for (Map.Entry<String, StoredScriptSource> entry : filtered.entrySet()) {
                out.writeString(entry.getKey());
                entry.getValue().writeTo(out);
            }
        }
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        for (Map.Entry<String, StoredScriptSource> entry : this.scripts.entrySet()) {
            builder.field(entry.getKey());
            entry.getValue().toXContent(builder, params);
        }
        return builder;
    }

    @Override
    public Diff<MetaData.Custom> diff(MetaData.Custom before) {
        return new ScriptMetadataDiff((ScriptMetaData)before, this);
    }

    @Override
    public String getWriteableName() {
        return TYPE;
    }

    @Override
    public Version getMinimalSupportedVersion() {
        return Version.CURRENT.minimumCompatibilityVersion();
    }

    @Override
    public EnumSet<MetaData.XContentContext> context() {
        return MetaData.ALL_CONTEXTS;
    }

    Map<String, StoredScriptSource> getStoredScripts() {
        return this.scripts;
    }

    StoredScriptSource getStoredScript(String id) {
        return this.scripts.get(id);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ScriptMetaData that = (ScriptMetaData)o;
        return this.scripts.equals(that.scripts);
    }

    public int hashCode() {
        return this.scripts.hashCode();
    }

    public String toString() {
        return "ScriptMetaData{scripts=" + this.scripts + '}';
    }

    static final class ScriptMetadataDiff
    implements NamedDiff<MetaData.Custom> {
        final Diff<Map<String, StoredScriptSource>> pipelines;

        ScriptMetadataDiff(ScriptMetaData before, ScriptMetaData after) {
            this.pipelines = DiffableUtils.diff(before.scripts, after.scripts, DiffableUtils.getStringKeySerializer());
        }

        ScriptMetadataDiff(StreamInput in) throws IOException {
            this.pipelines = DiffableUtils.readJdkMapDiff(in, DiffableUtils.getStringKeySerializer(), StoredScriptSource::new, StoredScriptSource::readDiffFrom);
        }

        @Override
        public String getWriteableName() {
            return ScriptMetaData.TYPE;
        }

        @Override
        public MetaData.Custom apply(MetaData.Custom part) {
            return new ScriptMetaData(this.pipelines.apply(((ScriptMetaData)part).scripts));
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            this.pipelines.writeTo(out);
        }
    }

    public static final class Builder {
        private final Map<String, StoredScriptSource> scripts;

        public Builder(ScriptMetaData previous) {
            this.scripts = previous == null ? new HashMap<String, StoredScriptSource>() : new HashMap(previous.scripts);
        }

        public Builder storeScript(String id, StoredScriptSource source) {
            this.scripts.put(id, source);
            return this;
        }

        public Builder deleteScript(String id) {
            StoredScriptSource deleted = this.scripts.remove(id);
            if (deleted == null) {
                throw new ResourceNotFoundException("stored script [" + id + "] does not exist and cannot be deleted", new Object[0]);
            }
            return this;
        }

        public ScriptMetaData build() {
            return new ScriptMetaData(this.scripts);
        }
    }
}

