/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.common.notification.impl;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.kuali.coeus.common.api.rolodex.RolodexContract;
import org.kuali.coeus.common.api.rolodex.RolodexService;
import org.kuali.coeus.common.framework.person.KcPerson;
import org.kuali.coeus.common.framework.person.KcPersonService;
import org.kuali.coeus.common.notification.impl.NotificationContext;
import org.kuali.coeus.common.notification.impl.bo.KcNotification;
import org.kuali.coeus.common.notification.impl.bo.NotificationType;
import org.kuali.coeus.common.notification.impl.bo.NotificationTypeRecipient;
import org.kuali.coeus.common.notification.impl.service.KcNotificationService;
import org.kuali.coeus.sys.framework.model.KcPersistableBusinessObjectBase;
import org.kuali.coeus.sys.framework.service.KcServiceLocator;
import org.kuali.rice.kim.api.role.Role;
import org.kuali.rice.kim.api.role.RoleService;
import org.kuali.rice.kim.api.services.KimApiServiceLocator;

public class NotificationHelper<T extends NotificationContext>
implements Serializable {
    private static final long serialVersionUID = -3405035537522284062L;
    private NotificationTypeRecipient newNotificationRecipient;
    private List<NotificationTypeRecipient> notificationRecipients;
    private KcNotification notification;
    private Integer notificationStep;
    private T notificationContext;
    private String newRoleId;
    private String newPersonId;
    private String newRolodexId;
    private transient KcNotificationService notificationService;
    private transient RoleService roleService;
    private transient KcPersonService kcPersonService;
    private transient RolodexService rolodexService;

    public NotificationHelper() {
        this.setNewNotificationRecipient(new NotificationTypeRecipient());
        this.setNotificationRecipients(new ArrayList<NotificationTypeRecipient>());
        this.setNotification(new KcNotification());
    }

    public Integer getNotificationStep() {
        return this.notificationStep;
    }

    public void setNotificationStep(Integer notificationStep) {
        this.notificationStep = notificationStep;
    }

    public NotificationTypeRecipient getNewNotificationRecipient() {
        return this.newNotificationRecipient;
    }

    public void setNewNotificationRecipient(NotificationTypeRecipient newNotificationRecipient) {
        this.newNotificationRecipient = newNotificationRecipient;
    }

    public List<NotificationTypeRecipient> getNotificationRecipients() {
        return this.notificationRecipients;
    }

    public void setNotificationRecipients(List<NotificationTypeRecipient> notificationRecipients) {
        this.notificationRecipients = notificationRecipients;
    }

    public KcNotification getNotification() {
        return this.notification;
    }

    public void setNotification(KcNotification notification) {
        this.notification = notification;
    }

    public T getNotificationContext() {
        return this.notificationContext;
    }

    public void setNotificationContext(T notificationContext) {
        this.notificationContext = notificationContext;
    }

    public String getNewRoleId() {
        return this.newRoleId;
    }

    public void setNewRoleId(String newRoleId) {
        this.newRoleId = newRoleId;
        this.newPersonId = null;
        this.newRolodexId = null;
    }

    public String getNewPersonId() {
        return this.newPersonId;
    }

    public void setNewPersonId(String newPersonId) {
        this.newRoleId = null;
        this.newPersonId = newPersonId;
        this.newRolodexId = null;
    }

    public String getNewRolodexId() {
        return this.newRolodexId;
    }

    public void setNewRolodexId(String newRolodexId) {
        this.newRoleId = null;
        this.newPersonId = null;
        this.newRolodexId = newRolodexId;
    }

    public void initializeDefaultValues(T context) {
        this.getNotificationRecipients().clear();
        NotificationType notificationType = this.getNotificationService().getNotificationType((NotificationContext)context);
        if (notificationType != null) {
            for (NotificationTypeRecipient notificationRecipient : notificationType.getNotificationTypeRecipients()) {
                notificationRecipient.setFullName(notificationRecipient.getRoleName());
                this.getNotificationRecipients().add(notificationRecipient);
            }
        }
        this.setNotification(this.getNotificationService().createNotificationObject((NotificationContext)context));
        this.setNotificationContext(context);
    }

    public void prepareView() {
        if (StringUtils.isNotBlank((CharSequence)this.getNewRoleId())) {
            Role role = this.getRoleService().getRole(this.getNewRoleId());
            String roleName = role.getNamespaceCode() + ":" + role.getName();
            this.getNewNotificationRecipient().setRoleName(roleName);
            this.getNewNotificationRecipient().setPersonId(null);
            this.getNewNotificationRecipient().setRolodexId(null);
            this.getNewNotificationRecipient().setFullName(roleName);
        } else if (StringUtils.isNotBlank((CharSequence)this.getNewPersonId())) {
            this.getNewNotificationRecipient().setRoleName(null);
            KcPerson person = this.getKcPersonService().getKcPersonByPersonId(this.getNewPersonId());
            this.getNewNotificationRecipient().setPersonId(person.getPersonId());
            this.getNewNotificationRecipient().setFullName(person.getFullName());
            this.getNewNotificationRecipient().setRolodexId(null);
        } else if (StringUtils.isNotBlank((CharSequence)this.getNewRolodexId())) {
            this.getNewNotificationRecipient().setRoleName(null);
            this.getNewNotificationRecipient().setPersonId(null);
            RolodexContract rolodex = this.getRolodexService().getRolodex(Integer.valueOf(this.getNewRolodexId()));
            this.getNewNotificationRecipient().setRolodexId(rolodex.getRolodexId().toString());
            this.getNewNotificationRecipient().setFullName(rolodex.getFullName());
        }
    }

    public boolean getPromptUserForNotificationEditor(T context) {
        boolean promptUser = false;
        NotificationType notificationType = this.getNotificationService().getNotificationType((NotificationContext)context);
        if (notificationType != null && notificationType.isActive() && notificationType.getPromptUser()) {
            promptUser = true;
        }
        return promptUser;
    }

    public void sendNotification() {
        this.getNotificationService().sendNotification((NotificationContext)this.notificationContext, this.notification, this.notificationRecipients);
    }

    public void sendNotificationAndPersist(KcNotification notification, KcPersistableBusinessObjectBase object) {
        notification.setMessage(this.getNotification().getMessage());
        notification.setSubject(this.getNotification().getSubject());
        this.getNotificationService().sendNotificationAndPersist((NotificationContext)this.notificationContext, notification, this.notificationRecipients, object);
    }

    public KcNotificationService getNotificationService() {
        if (this.notificationService == null) {
            this.notificationService = KcServiceLocator.getService(KcNotificationService.class);
        }
        return this.notificationService;
    }

    public void setNotificationService(KcNotificationService notificationService) {
        this.notificationService = notificationService;
    }

    public KcPersonService getKcPersonService() {
        if (this.kcPersonService == null) {
            this.kcPersonService = KcServiceLocator.getService(KcPersonService.class);
        }
        return this.kcPersonService;
    }

    public void setKcPersonService(KcPersonService kcPersonService) {
        this.kcPersonService = kcPersonService;
    }

    public RolodexService getRolodexService() {
        if (this.rolodexService == null) {
            this.rolodexService = KcServiceLocator.getService(RolodexService.class);
        }
        return this.rolodexService;
    }

    public void setRolodexService(RolodexService rolodexService) {
        this.rolodexService = rolodexService;
    }

    public RoleService getRoleService() {
        if (this.roleService == null) {
            this.roleService = KimApiServiceLocator.getRoleService();
        }
        return this.roleService;
    }

    public void setRoleService(RoleService roleService) {
        this.roleService = roleService;
    }
}

