/*
 * Decompiled with CFR 0.152.
 */
package org.joda.time.contrib.jsptag;

import java.io.IOException;
import java.text.DateFormat;
import java.util.Locale;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.JspTagException;
import javax.servlet.jsp.tagext.BodyTagSupport;
import javax.servlet.jsp.tagext.Tag;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.joda.time.contrib.jsptag.DateTimeZoneSupport;
import org.joda.time.contrib.jsptag.Resources;
import org.joda.time.contrib.jsptag.Util;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;

public abstract class ParseDateTimeSupport
extends BodyTagSupport {
    protected String value;
    protected boolean valueSpecified;
    protected String pattern;
    protected String style;
    protected DateTimeZone dateTimeZone;
    protected Locale locale;
    private String var;
    private int scope;

    public ParseDateTimeSupport() {
        this.init();
    }

    private void init() {
        this.value = null;
        this.valueSpecified = false;
        this.pattern = null;
        this.style = null;
        this.dateTimeZone = null;
        this.locale = null;
        this.scope = 1;
    }

    public void setVar(String string) {
        this.var = string;
    }

    public void setScope(String string) {
        this.scope = Util.getScope(string);
    }

    public int doEndTag() throws JspException {
        DateTimeZone dateTimeZone;
        String string = null;
        if (this.valueSpecified) {
            string = this.value;
        } else if (this.bodyContent != null && this.bodyContent.getString() != null) {
            string = this.bodyContent.getString().trim();
        }
        if (string == null || string.equals("")) {
            if (this.var != null) {
                this.pageContext.removeAttribute(this.var, this.scope);
            }
            return 6;
        }
        DateTimeFormatter dateTimeFormatter = this.pattern != null ? DateTimeFormat.forPattern((String)this.pattern) : (this.style != null ? DateTimeFormat.forStyle((String)this.style) : DateTimeFormat.fullDateTime());
        Locale locale = this.locale;
        if (locale == null) {
            locale = Util.getFormattingLocale(this.pageContext, (Tag)this, true, DateFormat.getAvailableLocales());
        }
        if (locale != null) {
            dateTimeFormatter = dateTimeFormatter.withLocale(locale);
        }
        if ((dateTimeZone = this.dateTimeZone) == null) {
            dateTimeZone = DateTimeZoneSupport.getDateTimeZone(this.pageContext, (Tag)this);
        }
        if (dateTimeZone != null) {
            dateTimeFormatter = dateTimeFormatter.withZone(dateTimeZone);
        }
        DateTime dateTime = null;
        try {
            dateTime = dateTimeFormatter.parseDateTime(string);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new JspException(Resources.getMessage("PARSE_DATE_PARSE_ERROR", string), (Throwable)illegalArgumentException);
        }
        if (this.var != null) {
            this.pageContext.setAttribute(this.var, (Object)dateTime, this.scope);
        } else {
            try {
                this.pageContext.getOut().print((Object)dateTime);
            }
            catch (IOException iOException) {
                throw new JspTagException(iOException.toString(), (Throwable)iOException);
            }
        }
        return 6;
    }

    public void release() {
        this.init();
    }
}

