/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.common.budget.impl.personnel;

import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.kuali.coeus.common.budget.api.personnel.BudgetPersonContract;
import org.kuali.coeus.common.budget.api.personnel.BudgetPersonnelDetailsContract;
import org.kuali.coeus.common.budget.framework.core.Budget;
import org.kuali.coeus.common.budget.framework.core.BudgetForm;
import org.kuali.coeus.common.budget.framework.core.BudgetParent;
import org.kuali.coeus.common.budget.framework.core.CostElement;
import org.kuali.coeus.common.budget.framework.personnel.BudgetPerson;
import org.kuali.coeus.common.budget.framework.personnel.BudgetPersonService;
import org.kuali.coeus.common.budget.framework.personnel.BudgetPersonnelDetails;
import org.kuali.coeus.common.budget.framework.personnel.ValidCeJobCode;
import org.kuali.coeus.common.budget.impl.core.CostElementValuesFinder;
import org.kuali.coeus.common.framework.person.KcPerson;
import org.kuali.coeus.common.framework.person.KcPersonService;
import org.kuali.coeus.common.framework.person.attr.PersonAppointment;
import org.kuali.coeus.common.framework.rolodex.PersonRolodex;
import org.kuali.coeus.propdev.api.person.ProposalPersonContract;
import org.kuali.coeus.sys.api.model.ScaleTwoDecimal;
import org.kuali.coeus.sys.framework.gv.GlobalVariableService;
import org.kuali.rice.core.api.util.KeyValue;
import org.kuali.rice.coreservice.framework.parameter.ParameterService;
import org.kuali.rice.kns.util.KNSGlobalVariables;
import org.kuali.rice.krad.data.DataObjectService;
import org.kuali.rice.krad.service.BusinessObjectService;
import org.kuali.rice.krad.util.ObjectUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;

@Component(value="budgetPersonService")
public class BudgetPersonServiceImpl
implements BudgetPersonService {
    @Autowired
    @Qualifier(value="parameterService")
    private ParameterService parameterService;
    @Autowired
    @Qualifier(value="businessObjectService")
    private BusinessObjectService businessObjectService;
    @Autowired
    @Qualifier(value="kcPersonService")
    private KcPersonService kcPersonService;
    @Autowired
    @Qualifier(value="dataObjectService")
    private DataObjectService dataObjectService;
    @Autowired
    @Qualifier(value="globalVariableService")
    private GlobalVariableService globalVariableService;

    @Override
    public void addBudgetPerson(Budget budget, BudgetPerson budgetPerson) {
        if (budgetPerson.getPersonId() != null) {
            this.addBudgetEmployee(budget, budgetPerson);
        } else {
            this.populateBudgetPersonData(budget, budgetPerson);
            budget.addBudgetPerson(budgetPerson);
        }
    }

    protected void populateBudgetPersonData(Budget budget, BudgetPerson budgetPerson) {
        budgetPerson.setBudgetId(budget.getBudgetId());
        budgetPerson.setBudget(budget);
        budgetPerson.setPersonSequenceNumber(budget.getNextValue("personSequenceNumber"));
        this.populatePersonDefaultDataIfEmpty(budget, budgetPerson);
    }

    @Override
    public void populateBudgetPersonDefaultDataIfEmpty(Budget budget) {
        for (BudgetPerson budgetPerson : budget.getBudgetPersons()) {
            this.populatePersonDefaultDataIfEmpty(budget, budgetPerson);
        }
    }

    @Override
    public void synchBudgetPersonsToProposal(Budget budget) {
        BudgetParent budgetParent = budget.getBudgetParent();
        for (PersonRolodex personRolodex : budgetParent.getPersonRolodexList()) {
            if (personRolodex.isOtherSignificantContributorFlag()) continue;
            boolean present = false;
            for (BudgetPerson budgetPerson : budget.getBudgetPersons()) {
                if (personRolodex.getPersonId() != null && personRolodex.getPersonId().equals(budgetPerson.getPersonId())) {
                    present = true;
                    break;
                }
                if (personRolodex.getRolodexId() == null || !personRolodex.getRolodexId().equals(budgetPerson.getRolodexId())) continue;
                present = true;
                break;
            }
            if (present) continue;
            if (personRolodex.getPersonId() != null) {
                this.addBudgetEmployee(budget, new BudgetPerson(personRolodex));
                continue;
            }
            BudgetPerson newBudgetPerson = new BudgetPerson(personRolodex);
            this.populateBudgetPersonData(budget, newBudgetPerson);
            budget.addBudgetPerson(newBudgetPerson);
        }
        this.reconcilePersonnelRoles(budget);
    }

    protected void reconcilePersonnelRoles(Budget budget) {
        List<BudgetPerson> budgetPersons = budget.getBudgetPersons();
        for (BudgetPerson budgetPerson : budgetPersons) {
            PersonRolodex person = this.getBudgetPersonRolodex(budget, budgetPerson);
            if (person == null) continue;
            budgetPerson.setRole(person.getInvestigatorRoleDescription());
            budgetPerson.setPersonRolodex(person);
        }
    }

    private String getDefaultJobCode() {
        return this.getParameterService().getParameterValueAsString(Budget.class, "budgetPersonDefaultJobCode");
    }

    protected void addBudgetEmployee(Budget budget, BudgetPerson budgetPerson) {
        KcPerson kcPerson = this.getKcPersonService().getKcPersonByPersonId(budgetPerson.getPersonId());
        List<PersonAppointment> appointments = kcPerson.getExtendedAttributes().getPersonAppointments();
        boolean added = false;
        String defaultJobCode = this.getDefaultJobCode();
        for (PersonAppointment appointment : appointments) {
            if (!this.isAppointmentApplicableToBudget(budget, appointment)) continue;
            BudgetPerson newBudgetPerson = new BudgetPerson();
            newBudgetPerson.setPersonId(budgetPerson.getPersonId());
            newBudgetPerson.setPersonName(budgetPerson.getPersonName());
            newBudgetPerson.setNonEmployeeFlag(budgetPerson.getNonEmployeeFlag());
            if (StringUtils.isEmpty((CharSequence)appointment.getJobCode())) {
                newBudgetPerson.setJobCode(defaultJobCode);
            } else {
                newBudgetPerson.setJobCode(appointment.getJobCode());
            }
            newBudgetPerson.setJobTitle(appointment.getJobTitle());
            newBudgetPerson.setCalculationBase(appointment.getSalary());
            BudgetParent proposal = budget.getBudgetParent();
            budgetPerson.setEffectiveDate(proposal.getRequestedStartDateInitial());
            newBudgetPerson.setAppointmentType(appointment.getAppointmentType());
            newBudgetPerson.setAppointmentTypeCode(appointment.getTypeCode());
            newBudgetPerson.setSalaryAnniversaryDate(kcPerson.getExtendedAttributes().getSalaryAnniversaryDate());
            this.populateBudgetPersonData(budget, newBudgetPerson);
            budget.addBudgetPerson(newBudgetPerson);
            added = true;
        }
        if (!added) {
            this.populateBudgetPersonData(budget, budgetPerson);
            budgetPerson.setJobCode(defaultJobCode);
            budgetPerson.setSalaryAnniversaryDate(kcPerson.getExtendedAttributes().getSalaryAnniversaryDate());
            budget.addBudgetPerson(budgetPerson);
        }
    }

    protected boolean isAppointmentApplicableToBudget(Budget budget, PersonAppointment appointment) {
        Calendar budgetStart = Calendar.getInstance();
        Calendar budgetEnd = Calendar.getInstance();
        Calendar apptStart = Calendar.getInstance();
        Calendar apptEnd = Calendar.getInstance();
        budgetStart.setTime(budget.getStartDate());
        budgetEnd.setTime(budget.getEndDate());
        if (appointment.getStartDate() != null) {
            apptStart.setTime(appointment.getStartDate());
        } else {
            apptStart.setTime(budget.getStartDate());
        }
        if (appointment.getEndDate() != null) {
            apptEnd.setTime(appointment.getEndDate());
        } else {
            apptEnd.setTime(budget.getEndDate());
        }
        return budgetStart.before(apptEnd) && budgetEnd.after(apptStart);
    }

    protected void populatePersonDefaultDataIfEmpty(Budget budget, BudgetPerson budgetPerson) {
        BudgetParent proposal = budget.getBudgetParent();
        if (proposal != null && ObjectUtils.isNull((Object)budgetPerson.getEffectiveDate())) {
            budgetPerson.setEffectiveDate(proposal.getRequestedStartDateInitial());
        }
        if (ObjectUtils.isNull((Object)budgetPerson.getCalculationBase())) {
            budgetPerson.setCalculationBase(new ScaleTwoDecimal(this.parameterService.getParameterValueAsString(Budget.class, "budgetPersonDefaultCalculationBase")));
        }
        if (StringUtils.isBlank((CharSequence)budgetPerson.getAppointmentTypeCode())) {
            budgetPerson.setAppointmentTypeCode(this.parameterService.getParameterValueAsString(Budget.class, "budgetPersonDefaultAppointmentType"));
        }
        this.refreshPersonAppointmentType(budgetPerson);
        if (StringUtils.isBlank((CharSequence)budgetPerson.getJobCode())) {
            budgetPerson.setJobCode(this.getDefaultJobCode());
        }
    }

    private void refreshPersonAppointmentType(BudgetPerson budgetPerson) {
        if (StringUtils.isNotEmpty((CharSequence)budgetPerson.getAppointmentTypeCode())) {
            this.getDataObjectService().wrap((Object)budgetPerson).fetchRelationship("appointmentType");
        }
    }

    public ParameterService getParameterService() {
        return this.parameterService;
    }

    public void setParameterService(ParameterService parameterService) {
        this.parameterService = parameterService;
    }

    @Override
    public boolean proposalPersonEqualsBudgetPerson(ProposalPersonContract proposalPerson, BudgetPersonnelDetailsContract budgetPersonnelDetails) {
        boolean equal = false;
        if (proposalPerson != null && budgetPersonnelDetails != null) {
            String budgetPersonId = budgetPersonnelDetails.getPersonId();
            if (proposalPerson.getPersonId() != null && proposalPerson.getPersonId().equals(budgetPersonId) || proposalPerson.getRolodexId() != null && proposalPerson.getRolodexId().toString().equals(budgetPersonId)) {
                equal = true;
            }
        }
        return equal;
    }

    public BusinessObjectService getBusinessObjectService() {
        return this.businessObjectService;
    }

    public void setBusinessObjectService(BusinessObjectService businessObjectService) {
        this.businessObjectService = businessObjectService;
    }

    protected KcPersonService getKcPersonService() {
        return this.kcPersonService;
    }

    public void setKcPersonService(KcPersonService kcPersonService) {
        this.kcPersonService = kcPersonService;
    }

    public DataObjectService getDataObjectService() {
        return this.dataObjectService;
    }

    public void setDataObjectService(DataObjectService dataObjectService) {
        this.dataObjectService = dataObjectService;
    }

    @Override
    public void refreshBudgetPerson(BudgetPerson budgetPerson) {
        this.refreshPersonAppointmentType(budgetPerson);
    }

    @Override
    public PersonRolodex getBudgetPersonRolodex(Budget budget, BudgetPersonContract budgetPerson) {
        BudgetParent budgetParent = budget.getBudgetParent();
        PersonRolodex personRolodex = null;
        if (budgetParent != null) {
            for (PersonRolodex personRolodex2 : budgetParent.getPersonRolodexList()) {
                if (personRolodex2.getPersonId() != null && personRolodex2.getPersonId().equals(budgetPerson.getPersonId())) {
                    personRolodex = personRolodex2;
                    break;
                }
                if (personRolodex2.getRolodexId() == null || !personRolodex2.getRolodexId().equals(budgetPerson.getRolodexId())) continue;
                personRolodex = personRolodex2;
                break;
            }
        }
        return personRolodex;
    }

    @Override
    public List<ValidCeJobCode> getApplicableCostElements(Budget budget, String personSequenceNumber) {
        return this.getValidCeJobCodes(budget, personSequenceNumber);
    }

    protected List<ValidCeJobCode> getApplicableCostElements(Long budgetId, String personSequenceNumber) {
        BudgetForm form = (BudgetForm)KNSGlobalVariables.getKualiForm();
        return this.getValidCeJobCodes(form.getBudget(), personSequenceNumber);
    }

    protected List<ValidCeJobCode> getValidCeJobCodes(Budget budget, String personSequenceNumber) {
        List validCostElements = null;
        String jobCodeValidationEnabledInd = this.parameterService.getParameterValueAsString(Budget.class, "JOBCODE_VALIDATION_ENABLED");
        if (StringUtils.isNotEmpty((CharSequence)jobCodeValidationEnabledInd) && jobCodeValidationEnabledInd.equals("Y")) {
            BudgetPerson budgetPerson = null;
            for (BudgetPersonnelDetails detail : budget.getBudgetPersonnelDetailsList()) {
                if (!detail.getBudgetPerson().getBudgetId().equals(budget.getBudgetId()) || !detail.getBudgetPerson().getPersonSequenceNumber().equals(personSequenceNumber)) continue;
                budgetPerson = detail.getBudgetPerson();
                break;
            }
            if (budgetPerson != null && StringUtils.isNotEmpty((CharSequence)budgetPerson.getJobCode())) {
                HashMap<String, String> fieldValues = new HashMap<String, String>();
                fieldValues.put("jobCode", budgetPerson.getJobCode().toUpperCase());
                validCostElements = (List)this.businessObjectService.findMatching(ValidCeJobCode.class, fieldValues);
            }
        }
        return validCostElements;
    }

    @Override
    public String getApplicableCostElementsForAjaxCall(Long budgetId, String personSequenceNumber, String budgetCategoryTypeCode) {
        Object resultStr = "";
        if (this.isAuthorizedToAccess(budgetCategoryTypeCode)) {
            List<ValidCeJobCode> validCostElements;
            if (StringUtils.isNotBlank((CharSequence)budgetCategoryTypeCode) && budgetCategoryTypeCode.contains(":")) {
                budgetCategoryTypeCode = StringUtils.split((String)budgetCategoryTypeCode, (String)":")[0];
            }
            if (CollectionUtils.isNotEmpty(validCostElements = this.getApplicableCostElements(budgetId, personSequenceNumber))) {
                for (ValidCeJobCode validCE : validCostElements) {
                    HashMap<String, String> fieldValues = new HashMap<String, String>();
                    fieldValues.put("costElement", validCE.getCostElement());
                    CostElement costElement = (CostElement)this.businessObjectService.findByPrimaryKey(CostElement.class, fieldValues);
                    resultStr = (String)resultStr + "," + validCE.getCostElement() + ";" + costElement.getDescription();
                }
                resultStr = (String)resultStr + ",ceLookup;false";
            } else {
                CostElementValuesFinder ceValuesFinder = new CostElementValuesFinder();
                ceValuesFinder.setBudgetCategoryTypeCode(budgetCategoryTypeCode);
                List<KeyValue> allPersonnelCostElements = ceValuesFinder.getKeyValues();
                for (KeyValue keyValue : allPersonnelCostElements) {
                    if (!StringUtils.isNotEmpty((CharSequence)keyValue.getKey().toString())) continue;
                    resultStr = (String)resultStr + "," + keyValue.getKey() + ";" + keyValue.getValue();
                }
                resultStr = (String)resultStr + ",ceLookup;true";
            }
        }
        return resultStr;
    }

    private boolean isAuthorizedToAccess(String budgetCategoryTypeCode) {
        boolean isAuthorized = true;
        if (budgetCategoryTypeCode.contains(":") && this.globalVariableService.getUserSession() != null) {
            Map editModes;
            Object formObj;
            String[] invalues = StringUtils.split((String)budgetCategoryTypeCode, (String)":");
            String docFormKey = invalues[1];
            isAuthorized = StringUtils.isBlank((CharSequence)docFormKey) ? false : ((formObj = this.globalVariableService.getUserSession().retrieveObject(docFormKey)) == null || !(formObj instanceof BudgetForm) ? false : BooleanUtils.toBoolean((String)((String)(editModes = ((BudgetForm)formObj).getEditingMode()).get("fullEntry"))) || BooleanUtils.toBoolean((String)((String)editModes.get("viewOnly"))) || BooleanUtils.toBoolean((String)((String)editModes.get("modifyBudgtes"))) || BooleanUtils.toBoolean((String)((String)editModes.get("viewBudgets"))) || BooleanUtils.toBoolean((String)((String)editModes.get("addBudget"))));
        }
        return isAuthorized;
    }

    protected GlobalVariableService getGlobalVariableService() {
        return this.globalVariableService;
    }

    public void setGlobalVariableService(GlobalVariableService globalVariableService) {
        this.globalVariableService = globalVariableService;
    }
}

