/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.personmasschange.service.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.collections4.CollectionUtils;
import org.kuali.kra.personmasschange.bo.PersonMassChange;
import org.kuali.kra.personmasschange.service.SubawardPersonMassChangeService;
import org.kuali.kra.personmasschange.service.impl.MassPersonChangeServiceBase;
import org.kuali.kra.subaward.bo.SubAward;
import org.kuali.kra.subaward.bo.SubAwardContact;
import org.kuali.rice.krad.bo.PersistableBusinessObject;
import org.springframework.stereotype.Component;

@Component(value="subawardPersonMassChangeService")
public class SubawardPersonMassChangeServiceImpl
extends MassPersonChangeServiceBase
implements SubawardPersonMassChangeService {
    private static final String SUBAWARD_CODE = "subAwardCode";
    private static final String SEQUENCE_NUMBER = "sequenceNumber";
    private static final String SUBAWARD = "subaward";
    private static final String SUBAWARD_WARNINGS = "subawardWarnings";

    @Override
    public List<SubAward> getSubawardChangeCandidates(PersonMassChange personMassChange) {
        ArrayList<SubAward> subawardChangeCandidates = new ArrayList<SubAward>();
        ArrayList<SubAward> subawards = new ArrayList<SubAward>();
        if (personMassChange.getSubawardPersonMassChange().requiresChange()) {
            subawards.addAll(this.getSubawards(personMassChange));
        }
        for (SubAward subaward : subawards) {
            if (!this.isSubawardChangeCandidate(personMassChange, subaward)) continue;
            subawardChangeCandidates.add(subaward);
        }
        for (SubAward subawardChangeCandidate : subawardChangeCandidates) {
            if (subawardChangeCandidate.getSubAwardDocument().getPessimisticLocks().isEmpty()) continue;
            this.reportSoftError(subawardChangeCandidate);
        }
        return subawardChangeCandidates;
    }

    private List<SubAward> getSubawards(PersonMassChange personMassChange) {
        ArrayList<SubAward> subawards = new ArrayList<SubAward>();
        Collection allSubawards = this.getBusinessObjectService().findAll(SubAward.class);
        if (personMassChange.isChangeAllSequences()) {
            subawards.addAll(allSubawards);
        } else {
            subawards.addAll(this.getLatestSubawards(allSubawards));
        }
        return subawards;
    }

    private List<SubAward> getLatestSubawards(Collection<SubAward> subawards) {
        ArrayList<SubAward> latestSubawards = new ArrayList<SubAward>();
        for (String uniqueSubawardCode : this.getUniqueSubawardCodes(subawards)) {
            HashMap<String, String> fieldValues = new HashMap<String, String>();
            fieldValues.put(SUBAWARD_CODE, uniqueSubawardCode);
            Collection uniqueSubawards = this.getBusinessObjectService().findMatchingOrderBy(SubAward.class, fieldValues, SEQUENCE_NUMBER, false);
            if (uniqueSubawards.isEmpty()) continue;
            latestSubawards.add((SubAward)CollectionUtils.get((Iterable)uniqueSubawards, (int)0));
        }
        return latestSubawards;
    }

    private Set<String> getUniqueSubawardCodes(Collection<SubAward> subawards) {
        HashSet<String> uniqueSubawardIds = new HashSet<String>();
        for (SubAward subaward : subawards) {
            uniqueSubawardIds.add(subaward.getSubAwardCode());
        }
        return uniqueSubawardIds;
    }

    private boolean isSubawardChangeCandidate(PersonMassChange personMassChange, SubAward subaward) {
        boolean isSubawardChangeCandidate = false;
        String requisitionerId = subaward.getRequisitionerId();
        List<SubAwardContact> contacts = subaward.getSubAwardContactsList();
        if (personMassChange.getSubawardPersonMassChange().isRequisitioner()) {
            isSubawardChangeCandidate |= this.isRequisitionerChangeCandidate(personMassChange, requisitionerId);
        }
        if (personMassChange.getSubawardPersonMassChange().isContact()) {
            isSubawardChangeCandidate |= this.isContactCandidate(personMassChange, contacts);
        }
        return isSubawardChangeCandidate;
    }

    private boolean isRequisitionerChangeCandidate(PersonMassChange personMassChange, String requisitionerId) {
        return this.isPersonIdMassChange(personMassChange, requisitionerId);
    }

    private boolean isContactCandidate(PersonMassChange personMassChange, List<SubAwardContact> contacts) {
        boolean isContactChangeCandidate = false;
        for (SubAwardContact subawardContact : contacts) {
            if (!this.isRolodexIdMassChange(personMassChange, subawardContact.getRolodexId())) continue;
            isContactChangeCandidate = true;
            break;
        }
        return isContactChangeCandidate;
    }

    @Override
    public void performPersonMassChange(PersonMassChange personMassChange, List<SubAward> subawardChangeCandidates) {
        for (SubAward subawardChangeCandidate : subawardChangeCandidates) {
            if (!subawardChangeCandidate.getSubAwardDocument().getPessimisticLocks().isEmpty()) continue;
            this.performRequistionerPersonMassChange(personMassChange, subawardChangeCandidate);
            this.performContactMassChange(personMassChange, subawardChangeCandidate);
        }
    }

    private void performRequistionerPersonMassChange(PersonMassChange personMassChange, SubAward subaward) {
        if (personMassChange.getSubawardPersonMassChange().isRequisitioner()) {
            subaward.setRequisitionerId(personMassChange.getReplacerPersonId());
            this.getBusinessObjectService().save((PersistableBusinessObject)subaward);
        }
    }

    private void performContactMassChange(PersonMassChange personMassChange, SubAward subaward) {
        if (personMassChange.getSubawardPersonMassChange().isContact()) {
            for (SubAwardContact subawardContact : subaward.getSubAwardContactsList()) {
                if (!this.isRolodexIdMassChange(personMassChange, subawardContact.getRolodexId())) continue;
                subawardContact.setRolodexId(personMassChange.getReplacerRolodexId());
                this.getBusinessObjectService().save((PersistableBusinessObject)subawardContact);
            }
        }
    }

    private void reportSoftError(SubAward subaward) {
        String subawardCode = subaward.getSubAwardCode();
        this.errorReporter.reportSoftError("personMassChangeDocumentLocked", "error.personMassChange.document.locked", SUBAWARD, subawardCode);
    }

    @Override
    protected String getDocumentId(PersistableBusinessObject parent) {
        return ((SubAward)parent).getSubAwardCode();
    }

    @Override
    protected String getDocumentName() {
        return SUBAWARD;
    }

    @Override
    protected String getWarningKey() {
        return SUBAWARD_WARNINGS;
    }
}

