/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.common.impl.person.signature;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.kuali.coeus.common.framework.person.signature.PersonSignature;
import org.kuali.coeus.common.framework.person.signature.PersonSignatureModule;
import org.kuali.coeus.sys.framework.rule.KcMaintenanceDocumentRuleBase;
import org.kuali.coeus.sys.framework.service.KcServiceLocator;
import org.kuali.coeus.sys.framework.validation.ErrorReporter;
import org.kuali.rice.kns.document.MaintenanceDocument;

public class ValidPersonSignatureModuleMaintenanceDocumentRule
extends KcMaintenanceDocumentRuleBase {
    private static final String PERSON_SIGNATURE_ID_INVALID_ERROR_KEY = "error.invalid.personSignature.invalid.personSignatureId";

    protected boolean processCustomRouteDocumentBusinessRules(MaintenanceDocument document) {
        return this.isPersonSignatureModuleValidForSave(document);
    }

    public boolean processCustomSaveDocumentBusinessRules(MaintenanceDocument document) {
        return this.isPersonSignatureModuleValidForSave(document);
    }

    public boolean processCustomApproveDocumentBusinessRules(MaintenanceDocument document) {
        return this.isPersonSignatureModuleValidForSave(document);
    }

    public boolean isPersonSignatureModuleValidForSave(MaintenanceDocument document) {
        boolean result = super.isDocumentValidForSave(document);
        result &= this.isSignatureIdValid(document);
        return result &= this.isNotDuplicateSignatureId(document);
    }

    private boolean isSignatureIdValid(MaintenanceDocument document) {
        boolean isValid = true;
        PersonSignatureModule personSignatureModule = (PersonSignatureModule)document.getNewMaintainableObject().getDataObject();
        HashMap<String, Long> keyMap = new HashMap<String, Long>();
        keyMap.put("personSignatureId", personSignatureModule.getPersonSignatureId());
        isValid = this.checkExistenceFromTable(PersonSignature.class, keyMap, "personSignatureId", "Person Signature Id");
        return isValid;
    }

    private boolean isNotDuplicateSignatureId(MaintenanceDocument document) {
        boolean isValid = true;
        PersonSignatureModule personSignatureModule = (PersonSignatureModule)document.getNewMaintainableObject().getDataObject();
        HashMap<String, Object> fieldValues = new HashMap<String, Object>();
        fieldValues.put("personSignatureId", personSignatureModule.getPersonSignatureId());
        fieldValues.put("moduleCode", personSignatureModule.getModuleCode());
        if (document.isNew()) {
            isValid = this.getBoService().countMatching(PersonSignatureModule.class, fieldValues) == 0;
        } else if (document.isEdit()) {
            isValid = this.isRecordUpdateValid(fieldValues, personSignatureModule);
        }
        if (!isValid) {
            ErrorReporter errorReporter = KcServiceLocator.getService(ErrorReporter.class);
            errorReporter.reportError("document.newMaintainableObject.personSignatureId", PERSON_SIGNATURE_ID_INVALID_ERROR_KEY, new String[0]);
        }
        return isValid;
    }

    private boolean isRecordUpdateValid(Map<String, Object> fieldValues, PersonSignatureModule mdocPersonSignatureModule) {
        boolean isRecordUpdateValid = false;
        List authorizedSignatures = (List)this.getBoService().findMatching(PersonSignatureModule.class, fieldValues);
        if (authorizedSignatures.isEmpty()) {
            isRecordUpdateValid = true;
        } else {
            PersonSignatureModule dbPersonSignatureModule = (PersonSignatureModule)authorizedSignatures.get(0);
            Long dbPersonSignatureModuleId = dbPersonSignatureModule.getPersonSignatureModuleId();
            if (mdocPersonSignatureModule.getPersonSignatureModuleId().equals(dbPersonSignatureModuleId)) {
                isRecordUpdateValid = true;
            }
        }
        return isRecordUpdateValid;
    }
}

