/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.subaward.bo;

import java.util.Objects;
import org.kuali.coeus.common.framework.rolodex.Rolodex;
import org.kuali.coeus.sys.framework.service.KcServiceLocator;
import org.kuali.kra.award.home.ContactType;
import org.kuali.kra.subaward.bo.SubAwardAssociate;
import org.kuali.rice.coreservice.framework.parameter.ParameterService;

public class SubAwardContact
extends SubAwardAssociate {
    private static final long serialVersionUID = 1L;
    private static final String SUB_FINANCIAL = "Sub Financial";
    private static final String SUB_ADMIN = "Sub Administrative";
    private static final String SUB_AUTH = "Sub Authorized Official";
    private static final String PRIME_FINANCIAL = "Prime Financial";
    private static final String PRIME_ADMIN = "Prime Administrative";
    private static final String PRIME_AUTH = "Prime Authorized Official";
    private static final String PI = "Principal Investigator";
    private Integer subAwardContactId;
    private Long subAwardId;
    private String subAwardCode;
    private String contactTypeCode;
    private Integer rolodexId;
    private String rolodexName;
    private String sponsorCode;
    private String organization;
    private String addressLine1;
    private String addressLine2;
    private String addressLine3;
    private String city;
    private String county;
    private String state;
    private String postalCode;
    private String countryCode;
    private String phoneNumber;
    private String emailAddress;
    private String faxNumber;
    private String comments;
    private ContactType contactType;
    private Rolodex rolodex;
    private transient ParameterService parameterService;

    public SubAwardContact() {
    }

    public SubAwardContact(Rolodex rolodex) {
        this.rolodex = rolodex;
    }

    public Integer getSubAwardContactId() {
        return this.subAwardContactId;
    }

    public void setSubAwardContactId(Integer subAwardContactId) {
        this.subAwardContactId = subAwardContactId;
    }

    @Override
    public Long getSubAwardId() {
        return this.subAwardId;
    }

    @Override
    public void setSubAwardId(Long subAwardId) {
        this.subAwardId = subAwardId;
    }

    @Override
    public String getSubAwardCode() {
        return this.subAwardCode;
    }

    @Override
    public void setSubAwardCode(String subAwardCode) {
        this.subAwardCode = subAwardCode;
    }

    public String getContactTypeCode() {
        return this.contactTypeCode;
    }

    public void setContactTypeCode(String contactTypeCode) {
        this.contactTypeCode = contactTypeCode;
    }

    public Integer getRolodexId() {
        return this.rolodexId;
    }

    public void setRolodexId(Integer rolodexId) {
        this.rolodexId = rolodexId;
    }

    public ContactType getContactType() {
        return this.contactType;
    }

    public void setContactType(ContactType contactType) {
        this.contactType = contactType;
    }

    public Rolodex getRolodex() {
        if (this.rolodex == null || !Objects.equals(this.rolodex.getRolodexId(), this.rolodexId) && this.rolodexId != null) {
            this.refreshRolodex();
        }
        return this.rolodex;
    }

    public void setRolodex(Rolodex rolodex) {
        this.rolodex = rolodex;
    }

    public String getRolodexName() {
        return this.rolodexName;
    }

    public void setRolodexName(String rolodexName) {
        this.rolodexName = rolodexName;
    }

    public String getSponsorCode() {
        return this.sponsorCode;
    }

    public void setSponsorCode(String sponsorCode) {
        this.sponsorCode = sponsorCode;
    }

    public String getOrganization() {
        return this.organization;
    }

    public void setOrganization(String organization) {
        this.organization = organization;
    }

    public String getAddressLine1() {
        return this.addressLine1;
    }

    public void setAddressLine1(String addressLine1) {
        this.addressLine1 = addressLine1;
    }

    public String getAddressLine2() {
        return this.addressLine2;
    }

    public void setAddressLine2(String addressLine2) {
        this.addressLine2 = addressLine2;
    }

    public String getAddressLine3() {
        return this.addressLine3;
    }

    public void setAddressLine3(String addressLine3) {
        this.addressLine3 = addressLine3;
    }

    public String getCity() {
        return this.city;
    }

    public void setCity(String city) {
        this.city = city;
    }

    public String getCounty() {
        return this.county;
    }

    public void setCounty(String county) {
        this.county = county;
    }

    public String getState() {
        return this.state;
    }

    public void setState(String state) {
        this.state = state;
    }

    public String getPostalCode() {
        return this.postalCode;
    }

    public void setPostalCode(String postalCode) {
        this.postalCode = postalCode;
    }

    public String getCountryCode() {
        return this.countryCode;
    }

    public void setCountryCode(String countryCode) {
        this.countryCode = countryCode;
    }

    public String getPhoneNumber() {
        return this.phoneNumber;
    }

    public void setPhoneNumber(String phoneNumber) {
        this.phoneNumber = phoneNumber;
    }

    public String getEmailAddress() {
        return this.emailAddress;
    }

    public void setEmailAddress(String emailAddress) {
        this.emailAddress = emailAddress;
    }

    public String getFaxNumber() {
        return this.faxNumber;
    }

    public void setFaxNumber(String faxNumber) {
        this.faxNumber = faxNumber;
    }

    public String getComments() {
        return this.comments;
    }

    public void setComments(String comments) {
        this.comments = comments;
    }

    public String getFdpType() {
        if (this.contactTypeCode.equals(this.getParameterService().getParameterValueAsString("KC-SUBAWARD", "Document", "FDP_Sub_Administrative_Contact_Code"))) {
            return SUB_ADMIN;
        }
        if (this.contactTypeCode.equals(this.getParameterService().getParameterValueAsString("KC-SUBAWARD", "Document", "FDP_Sub_Financial_Contact_Code"))) {
            return SUB_FINANCIAL;
        }
        if (this.contactTypeCode.equals(this.getParameterService().getParameterValueAsString("KC-SUBAWARD", "Document", "FDP_Sub_Authorized_Official_Code"))) {
            return SUB_AUTH;
        }
        if (this.contactTypeCode.equals(this.getParameterService().getParameterValueAsString("KC-SUBAWARD", "Document", "FDP_Prime_Administrative_Contact_Code"))) {
            return PRIME_ADMIN;
        }
        if (this.contactTypeCode.equals(this.getParameterService().getParameterValueAsString("KC-SUBAWARD", "Document", "FDP_Prime_Financial_Contact_Code"))) {
            return PRIME_FINANCIAL;
        }
        if (this.contactTypeCode.equals(this.getParameterService().getParameterValueAsString("KC-SUBAWARD", "Document", "FDP_Prime_Authorized_Official_Code"))) {
            return PRIME_AUTH;
        }
        if ("-99".equals(this.contactTypeCode)) {
            return PI;
        }
        return null;
    }

    @Override
    public void resetPersistenceState() {
        this.subAwardContactId = null;
    }

    protected void refreshRolodex() {
        this.refreshReferenceObject("rolodex");
    }

    public ParameterService getParameterService() {
        if (this.parameterService == null) {
            this.parameterService = KcServiceLocator.getService(ParameterService.class);
        }
        return this.parameterService;
    }
}

