/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.ksb.messaging.serviceproxies;

import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.xml.namespace.QName;
import org.apache.commons.lang3.StringUtils;
import org.kuali.rice.core.api.config.property.ConfigurationService;
import org.kuali.rice.ksb.api.bus.Endpoint;
import org.kuali.rice.ksb.api.bus.ServiceBus;
import org.kuali.rice.ksb.api.bus.ServiceConfiguration;
import org.kuali.rice.ksb.api.messaging.AsyncCapableService;
import org.kuali.rice.ksb.api.messaging.AsynchronousCall;
import org.kuali.rice.ksb.api.messaging.CallMetadata;
import org.kuali.rice.ksb.messaging.MessageServiceInvoker;
import org.kuali.rice.ksb.messaging.PersistedMessageBO;
import org.kuali.rice.ksb.messaging.service.MessageQueueService;
import org.kuali.rice.ksb.messaging.serviceproxies.MessageSender;

public class AsyncCapableServiceImpl
implements AsyncCapableService {
    private ServiceBus serviceBus;
    private MessageQueueService messageQueueService;
    private ConfigurationService configurationService;

    public void executeCall(QName qname, String applicationId, String value1, String value2, CallMetadata callMetadata, Runnable synchronousCall) {
        if (qname == null) {
            throw new IllegalArgumentException("qname is null");
        }
        if (callMetadata == null) {
            throw new IllegalArgumentException("callMetadata is null");
        }
        if (synchronousCall == null) {
            throw new IllegalArgumentException("synchronousCall is null");
        }
        if (this.messagingOn()) {
            List configs = this.findApplicableEndpoints(qname, applicationId).stream().map(Endpoint::getServiceConfiguration).collect(Collectors.toList());
            boolean queue = configs.stream().anyMatch(ServiceConfiguration::isQueue);
            Stream<PersistedMessageBO> messages = queue ? configs.stream().findFirst().stream().map(config -> this.toMessage((ServiceConfiguration)config, value1, value2, new AsynchronousCall(callMetadata.getParamTypes(), callMetadata.getArguments(), config, callMetadata.getMethodName()))) : configs.stream().map(config -> this.toMessage((ServiceConfiguration)config, value1, value2, new AsynchronousCall(callMetadata.getParamTypes(), callMetadata.getArguments(), config, callMetadata.getMethodName())));
            List<PersistedMessageBO> savedMessages = messages.map(message -> this.getMessageQueueService().save((PersistedMessageBO)message)).collect(Collectors.toList());
            savedMessages.forEach(this::sendMessage);
        } else {
            synchronousCall.run();
        }
    }

    private void sendMessage(PersistedMessageBO message) {
        if (this.asyncModeOn()) {
            this.sendMessageAsynchronous(message);
        } else {
            this.sendMessageImmediate(message);
        }
    }

    private void sendMessageAsynchronous(PersistedMessageBO message) {
        MessageSender.sendMessage(message);
    }

    private void sendMessageImmediate(PersistedMessageBO message) {
        new MessageServiceInvoker(message).run();
    }

    private PersistedMessageBO toMessage(ServiceConfiguration serviceConfiguration, String value1, String value2, AsynchronousCall callData) {
        PersistedMessageBO message = PersistedMessageBO.buildMessage(serviceConfiguration, callData);
        message.setQueueStatus("R");
        message.setValue1(StringUtils.substring((String)value1, (int)0, (int)2000));
        message.setValue2(StringUtils.substring((String)value2, (int)0, (int)2000));
        return message;
    }

    private List<Endpoint> findApplicableEndpoints(QName qname, String applicationId) {
        return StringUtils.isBlank((CharSequence)applicationId) ? this.getAllEndpoints(qname) : this.getEndpointsForAppId(qname, applicationId);
    }

    private List<Endpoint> getAllEndpoints(QName qname) {
        return this.getServiceBus().getEndpoints(qname);
    }

    private List<Endpoint> getEndpointsForAppId(QName qname, String applicationId) {
        return this.getServiceBus().getEndpoints(qname).stream().filter(e -> e.getServiceConfiguration().getApplicationId().equals(applicationId)).collect(Collectors.toList());
    }

    private boolean asyncModeOn() {
        return !"synchronous".equals(this.getConfigurationService().getPropertyValueAsString("message.delivery"));
    }

    private boolean messagingOn() {
        return !this.getConfigurationService().getPropertyValueAsBoolean("message.off");
    }

    public ServiceBus getServiceBus() {
        return this.serviceBus;
    }

    public void setServiceBus(ServiceBus serviceBus) {
        this.serviceBus = serviceBus;
    }

    public MessageQueueService getMessageQueueService() {
        return this.messageQueueService;
    }

    public void setMessageQueueService(MessageQueueService messageQueueService) {
        this.messageQueueService = messageQueueService;
    }

    public ConfigurationService getConfigurationService() {
        return this.configurationService;
    }

    public void setConfigurationService(ConfigurationService configurationService) {
        this.configurationService = configurationService;
    }
}

