/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.javax.persistence.osgi;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.persistence.EntityManagerFactory;
import javax.persistence.PersistenceException;
import javax.persistence.spi.LoadState;
import javax.persistence.spi.PersistenceProvider;
import javax.persistence.spi.PersistenceProviderResolver;
import javax.persistence.spi.PersistenceUnitInfo;
import javax.persistence.spi.ProviderUtil;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;
import org.osgi.service.jpa.EntityManagerFactoryBuilder;

public class OSGiProviderResolver
implements PersistenceProviderResolver,
PersistenceProvider {
    BundleContext ctx;

    public OSGiProviderResolver(BundleContext ctx) {
        this.ctx = ctx;
    }

    @Override
    public List<PersistenceProvider> getPersistenceProviders() {
        ArrayList<PersistenceProvider> listOfOurself = new ArrayList<PersistenceProvider>();
        listOfOurself.add(this);
        return listOfOurself;
    }

    @Override
    public void clearCachedProviders() {
    }

    @Override
    public EntityManagerFactory createEntityManagerFactory(String unitName, Map props) {
        return props == null || props.isEmpty() ? this.lookupEMF(unitName) : this.lookupEMFBuilder(unitName, props);
    }

    @Override
    public EntityManagerFactory createContainerEntityManagerFactory(PersistenceUnitInfo info, Map props) {
        return null;
    }

    @Override
    public ProviderUtil getProviderUtil() {
        return new ForwardingProviderUtil();
    }

    public EntityManagerFactory lookupEMF(String unitName) {
        this.debug("Persistence class - lookupEMF, punit=", unitName);
        String filter = null;
        ServiceReference[] refs = null;
        try {
            filter = "(osgi.unit.name=" + unitName + ")";
            refs = this.ctx.getServiceReferences(EntityManagerFactory.class.getName(), filter);
        }
        catch (InvalidSyntaxException isEx) {
            new PersistenceException("Implementation error - incorrect filter specified while looking up EMF", isEx);
        }
        if (refs != null && refs.length != 0) {
            this.debug("Persistence class - lookupEMF, found service ", unitName, " in registry");
            return (EntityManagerFactory)this.ctx.getService(refs[0]);
        }
        this.debug("Persistence class - lookupEMF, *** EMF service ", unitName, " not found in registry ***");
        return null;
    }

    public EntityManagerFactory lookupEMFBuilder(String unitName, Map<?, ?> props) {
        this.debug("Persistence class - lookupEMFBuilder, punit=", unitName);
        String filter = null;
        ServiceReference[] refs = null;
        try {
            filter = "(osgi.unit.name=" + unitName + ")";
            refs = this.ctx.getServiceReferences(EntityManagerFactoryBuilder.class.getName(), filter);
        }
        catch (InvalidSyntaxException isEx) {
            new PersistenceException("Implementation error - incorrect filter specified while looking up EMF", isEx);
        }
        if (refs != null && refs.length != 0) {
            this.debug("Persistence class - lookupEMFBuilder, found service ", unitName, " in registry");
            EntityManagerFactoryBuilder builder = (EntityManagerFactoryBuilder)this.ctx.getService(refs[0]);
            return builder.createEntityManagerFactory(props);
        }
        this.debug("Persistence class - lookupEMFBuilder, *** EMFBuilder service ", unitName, " not found in registry ***");
        return null;
    }

    public Collection<PersistenceProvider> lookupProviders() {
        this.debug("Persistence class - lookupProviders");
        HashSet<PersistenceProvider> providers = new HashSet<PersistenceProvider>();
        ServiceReference[] refs = null;
        try {
            refs = this.ctx.getServiceReferences(PersistenceProvider.class.getName(), null);
        }
        catch (InvalidSyntaxException invalidSyntaxException) {
            // empty catch block
        }
        if (refs != null) {
            ServiceReference[] serviceReferenceArray = refs;
            int n = refs.length;
            int n2 = 0;
            while (n2 < n) {
                ServiceReference ref = serviceReferenceArray[n2];
                providers.add((PersistenceProvider)this.ctx.getService(ref));
                ++n2;
            }
        }
        return providers;
    }

    protected void debug(String ... msgs) {
        if (System.getProperty("JPA_DEBUG") != null) {
            StringBuilder sb = new StringBuilder();
            String[] stringArray = msgs;
            int n = msgs.length;
            int n2 = 0;
            while (n2 < n) {
                String msg = stringArray[n2];
                sb.append(msg);
                ++n2;
            }
            System.out.println(sb.toString());
        }
    }

    @Override
    public void generateSchema(PersistenceUnitInfo info, Map map) {
    }

    @Override
    public boolean generateSchema(String persistenceUnitName, Map map) {
        return false;
    }

    public class ForwardingProviderUtil
    implements ProviderUtil {
        @Override
        public LoadState isLoadedWithReference(Object entity, String attributeName) {
            Collection<PersistenceProvider> providers = OSGiProviderResolver.this.lookupProviders();
            for (PersistenceProvider provider : providers) {
                LoadState loadstate = provider.getProviderUtil().isLoadedWithReference(entity, attributeName);
                if (loadstate == LoadState.UNKNOWN) continue;
                return loadstate;
            }
            return LoadState.UNKNOWN;
        }

        @Override
        public LoadState isLoadedWithoutReference(Object entity, String attributeName) {
            Collection<PersistenceProvider> providers = OSGiProviderResolver.this.lookupProviders();
            for (PersistenceProvider provider : providers) {
                LoadState loadstate = provider.getProviderUtil().isLoadedWithoutReference(entity, attributeName);
                if (loadstate == LoadState.UNKNOWN) continue;
                return loadstate;
            }
            return LoadState.UNKNOWN;
        }

        @Override
        public LoadState isLoaded(Object entity) {
            Collection<PersistenceProvider> providers = OSGiProviderResolver.this.lookupProviders();
            for (PersistenceProvider provider : providers) {
                LoadState loadstate = provider.getProviderUtil().isLoaded(entity);
                if (loadstate == LoadState.UNKNOWN) continue;
                return loadstate;
            }
            return LoadState.UNKNOWN;
        }
    }
}

