/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.ksb.security.admin;

import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class ExportServlet
extends HttpServlet {
    private static final long serialVersionUID = 3234778044685975458L;
    private static final String MIME_TYPE = "application/octet-stream";
    public static final String CLIENT_KEYSTORE_DATA = "ClientKeyStoreData";

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        byte[] clientKeyStoreData = (byte[])request.getSession().getAttribute(CLIENT_KEYSTORE_DATA);
        request.getSession().removeAttribute(CLIENT_KEYSTORE_DATA);
        if (clientKeyStoreData == null) {
            throw new ServletException("No keystore file was specified.");
        }
        response.setContentType(MIME_TYPE);
        response.setContentLength(clientKeyStoreData.length);
        response.setHeader("Content-disposition", "attachment; filename=" + this.extractFileName(request));
        response.getOutputStream().write(clientKeyStoreData);
        response.getOutputStream().close();
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.doPost(request, response);
    }

    private String extractFileName(HttpServletRequest request) {
        String path = request.getPathInfo();
        int index = path.lastIndexOf(47);
        if (index >= 0) {
            path = path.substring(index + 1);
        }
        return path;
    }

    public static final String generateExportPath(String keystoreFileName, HttpServletRequest request) {
        String basePath = request.getScheme() + "://" + request.getServerName() + ":" + request.getServerPort() + request.getContextPath();
        return basePath + "/exportsecurity/" + keystoreFileName;
    }
}

