/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krad.datadictionary.validation.constraint;

import org.apache.commons.lang.StringUtils;
import org.kuali.rice.krad.datadictionary.parse.BeanTag;
import org.kuali.rice.krad.datadictionary.parse.BeanTagAttribute;
import org.kuali.rice.krad.datadictionary.validation.constraint.ValidCharactersPatternConstraint;

@BeanTag(name="utf8AnyCharacterPatternConstraint", parent="UTF8AnyCharacterPatternConstraint")
public class UTF8AnyCharacterPatternConstraint
extends ValidCharactersPatternConstraint {
    protected boolean allowWhitespace = false;
    protected boolean omitNewline = false;

    @BeanTagAttribute(name="allowWhitespace")
    public boolean getAllowWhitespace() {
        return this.allowWhitespace;
    }

    public void setAllowWhitespace(boolean allowWhitespace) {
        this.allowWhitespace = allowWhitespace;
    }

    @Override
    protected String getRegexString() {
        StringBuffer regexString = new StringBuffer("[");
        regexString.append("\\u0000-\\uFFFF");
        if (this.allowWhitespace) {
            regexString.append("\\t\\v\\040");
            if (!this.omitNewline) {
                regexString.append("\\f\\r\\n");
            }
        }
        regexString.append("]");
        return regexString.toString();
    }

    @Override
    public String getMessageKey() {
        String messageKey = super.getMessageKey();
        if (StringUtils.isNotEmpty((String)messageKey)) {
            return messageKey;
        }
        if (!this.allowWhitespace) {
            return "validation.noWhitespace";
        }
        return "validation.utf8AnyCharacterPattern";
    }

    @BeanTagAttribute(name="omitNewline")
    public boolean isOmitNewline() {
        return this.omitNewline;
    }

    public void setOmitNewline(boolean omitNewline) {
        this.omitNewline = omitNewline;
    }
}

