/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.common.budget.impl.nonpersonnel;

import org.kuali.coeus.common.budget.framework.calculator.BudgetCalculationService;
import org.kuali.coeus.common.budget.framework.core.Budget;
import org.kuali.coeus.common.budget.framework.nonpersonnel.BudgetDirectCostLimitEvent;
import org.kuali.coeus.common.budget.framework.nonpersonnel.BudgetLineItem;
import org.kuali.coeus.common.budget.framework.nonpersonnel.BudgetPeriodCostLimitEvent;
import org.kuali.coeus.common.budget.framework.period.BudgetPeriod;
import org.kuali.coeus.common.framework.ruleengine.KcBusinessRule;
import org.kuali.coeus.common.framework.ruleengine.KcEventMethod;
import org.kuali.coeus.common.framework.ruleengine.KcEventResult;
import org.kuali.coeus.sys.api.model.ScaleTwoDecimal;
import org.kuali.coeus.sys.framework.gv.GlobalVariableService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;

@KcBusinessRule(value="budgetCostLimitRule")
public class BudgetCostLimitRule {
    @Autowired
    @Qualifier(value="globalVariableService")
    private GlobalVariableService globalVariableService;
    @Autowired
    @Qualifier(value="budgetCalculationService")
    private BudgetCalculationService budgetCalculationService;

    @KcEventMethod
    public KcEventResult processBudgetPeriodCostLimit(BudgetPeriodCostLimitEvent event) {
        KcEventResult result = new KcEventResult();
        result.getMessageMap().addToErrorPath(event.getErrorPath());
        this.checkPeriodSyncToLimitErrors(event, result);
        this.checkPeriodTotalCost(event, result);
        result.getMessageMap().removeFromErrorPath(event.getErrorPath());
        return result;
    }

    @KcEventMethod
    public KcEventResult processBudgetDriectCostLimit(BudgetDirectCostLimitEvent event) {
        KcEventResult result = new KcEventResult();
        result.getMessageMap().addToErrorPath(event.getErrorPath());
        this.checkDirectSyncToLimitErrors(event, result);
        this.checkTotalDirectCost(event, result);
        result.getMessageMap().removeFromErrorPath(event.getErrorPath());
        return result;
    }

    protected void checkPeriodSyncToLimitErrors(BudgetPeriodCostLimitEvent event, KcEventResult result) {
        ScaleTwoDecimal costLimit = event.getBudgetPeriod().getTotalCostLimit();
        this.checkSyncToLimitErrors(event.getBudget(), event.getBudgetPeriod(), event.getBudgetLineItem(), result, costLimit);
    }

    protected void checkDirectSyncToLimitErrors(BudgetDirectCostLimitEvent event, KcEventResult result) {
        ScaleTwoDecimal directCostLimit = event.getBudgetPeriod().getDirectCostLimit();
        this.checkSyncToLimitErrors(event.getBudget(), event.getBudgetPeriod(), event.getBudgetLineItem(), result, directCostLimit);
    }

    protected void checkSyncToLimitErrors(Budget budget, BudgetPeriod budgetPeriod, BudgetLineItem budgetLineItem, KcEventResult result, ScaleTwoDecimal costLimit) {
        String personnelCategoryTypeCode = this.getBudgetCalculationService().getPersonnelBudgetCategoryTypeCode();
        if (budgetLineItem.getBudgetCategory().getBudgetCategoryTypeCode().equals(personnelCategoryTypeCode) && !budgetLineItem.getBudgetPersonnelDetailsList().isEmpty()) {
            result.getMessageMap().putError("lineItemCost", "personnelLineItem.exists", new String[0]);
            result.setSuccess(false);
        }
        if (this.isProposalBudget(budget) && costLimit.equals((Object)ScaleTwoDecimal.ZERO)) {
            result.getMessageMap().putError("lineItemCost", "error.sync.to.zero.limit", new String[0]);
            result.setSuccess(false);
        }
    }

    protected void checkPeriodTotalCost(BudgetPeriodCostLimitEvent event, KcEventResult result) {
        Budget budget = event.getBudget();
        BudgetPeriod budgetPeriod = event.getBudgetPeriod();
        this.getBudgetCalculationService().calculateBudgetPeriod(budget, budgetPeriod);
        ScaleTwoDecimal periodTotal = budgetPeriod.getTotalCost();
        ScaleTwoDecimal costLimit = budgetPeriod.getTotalCostLimit();
        if (periodTotal.equals((Object)costLimit)) {
            result.getMessageMap().putError("lineItemCost", "total.cost.already.sync", new String[0]);
            result.setSuccess(false);
        }
    }

    protected void checkTotalDirectCost(BudgetDirectCostLimitEvent event, KcEventResult result) {
        Budget budget = event.getBudget();
        BudgetPeriod budgetPeriod = event.getBudgetPeriod();
        ScaleTwoDecimal directCostLimit = budgetPeriod.getDirectCostLimit();
        this.getBudgetCalculationService().calculateBudgetPeriod(budget, budgetPeriod);
        ScaleTwoDecimal periodDirectTotal = budgetPeriod.getTotalDirectCost();
        directCostLimit = budgetPeriod.getDirectCostLimit();
        if (periodDirectTotal.equals((Object)directCostLimit)) {
            result.getMessageMap().putError("lineItemCost", "total.direct.cost.already.sync", new String[0]);
            result.setSuccess(false);
        }
    }

    protected boolean isProposalBudget(Budget budget) {
        return budget.isProposalBudget();
    }

    public GlobalVariableService getGlobalVariableService() {
        return this.globalVariableService;
    }

    public void setGlobalVariableService(GlobalVariableService globalVariableService) {
        this.globalVariableService = globalVariableService;
    }

    public BudgetCalculationService getBudgetCalculationService() {
        return this.budgetCalculationService;
    }

    public void setBudgetCalculationService(BudgetCalculationService budgetCalculationService) {
        this.budgetCalculationService = budgetCalculationService;
    }
}

