/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.propdev.impl.s2s;

import gov.grants.apply.services.applicantwebservices_v2.GetApplicationZipResponse;
import gov.grants.apply.services.applicantwebservices_v2.GetOpportunityListResponse;
import gov.grants.apply.services.applicantwebservices_v2.GetSubmissionListResponse;
import gov.grants.apply.services.applicantwebservices_v2.SubmitApplicationResponse;
import gov.grants.apply.system.applicantcommonelements_v1.OpportunityDetails;
import gov.grants.apply.system.applicantcommonelements_v1.SubmissionDetails;
import java.io.File;
import java.io.IOException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.mail.util.ByteArrayDataSource;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;
import org.joda.time.ReadablePeriod;
import org.joda.time.Years;
import org.kuali.coeus.instprop.api.admin.ProposalAdminDetailsService;
import org.kuali.coeus.instprop.api.sponsor.InstPropSponsorService;
import org.kuali.coeus.propdev.api.core.ProposalDevelopmentDocumentContract;
import org.kuali.coeus.propdev.api.s2s.S2SConfigurationService;
import org.kuali.coeus.propdev.api.s2s.S2sFormConfigurationContract;
import org.kuali.coeus.propdev.api.s2s.S2sFormConfigurationService;
import org.kuali.coeus.propdev.api.s2s.S2sOpportunityContract;
import org.kuali.coeus.propdev.api.s2s.S2sProviderContract;
import org.kuali.coeus.propdev.api.s2s.S2sProviderService;
import org.kuali.coeus.propdev.impl.core.DevelopmentProposal;
import org.kuali.coeus.propdev.impl.core.ProposalDevelopmentDocument;
import org.kuali.coeus.propdev.impl.s2s.S2sAppAttachments;
import org.kuali.coeus.propdev.impl.s2s.S2sAppSubmission;
import org.kuali.coeus.propdev.impl.s2s.S2sApplication;
import org.kuali.coeus.propdev.impl.s2s.S2sFileDto;
import org.kuali.coeus.propdev.impl.s2s.S2sOppForms;
import org.kuali.coeus.propdev.impl.s2s.S2sOpportunity;
import org.kuali.coeus.propdev.impl.s2s.S2sOpportunityCfda;
import org.kuali.coeus.propdev.impl.s2s.S2sProvider;
import org.kuali.coeus.propdev.impl.s2s.S2sSubmissionService;
import org.kuali.coeus.propdev.impl.s2s.connect.OpportunitySchemaParserService;
import org.kuali.coeus.propdev.impl.s2s.connect.S2SConnectorService;
import org.kuali.coeus.propdev.impl.s2s.connect.S2sCommunicationException;
import org.kuali.coeus.s2sgen.api.generate.AttachmentData;
import org.kuali.coeus.s2sgen.api.generate.FormGenerationResults;
import org.kuali.coeus.s2sgen.api.generate.FormGeneratorService;
import org.kuali.coeus.sys.api.model.KcFile;
import org.kuali.coeus.sys.framework.service.KcServiceLocator;
import org.kuali.rice.core.api.criteria.Predicate;
import org.kuali.rice.core.api.criteria.PredicateFactory;
import org.kuali.rice.core.api.criteria.QueryByCriteria;
import org.kuali.rice.core.api.criteria.QueryResults;
import org.kuali.rice.coreservice.framework.parameter.ParameterService;
import org.kuali.rice.krad.data.DataObjectService;
import org.kuali.rice.krad.data.PersistenceOption;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;

@Component(value="s2sSubmissionService")
public class S2sSubmissionServiceImpl
implements S2sSubmissionService {
    private static final Logger LOG = LogManager.getLogger(S2sSubmissionServiceImpl.class);
    private static final String PREVENT_MULTIPLE_S2S_SUBMISSIONS = "PREVENT_MULTIPLE_S2S_SUBMISSIONS";
    private static final DateTime INCREASED_YEAR_STORAGE_DATE = new DateTime().withDate(2015, 4, 22);
    private static final Years INCREASED_STORAGE = Years.years((int)5);
    @Autowired
    @Qualifier(value="proposalAdminDetailsService")
    private ProposalAdminDetailsService proposalAdminDetailsService;
    @Autowired
    @Qualifier(value="instPropSponsorService")
    private InstPropSponsorService instPropSponsorService;
    @Autowired
    @Qualifier(value="formGeneratorService")
    private FormGeneratorService formGeneratorService;
    @Autowired
    @Qualifier(value="s2sProviderService")
    private S2sProviderService s2sProviderService;
    @Autowired
    @Qualifier(value="s2SConfigurationService")
    private S2SConfigurationService s2SConfigurationService;
    @Autowired
    @Qualifier(value="opportunitySchemaParserService")
    private OpportunitySchemaParserService opportunitySchemaParserService;
    @Autowired
    @Qualifier(value="s2sFormConfigurationService")
    private S2sFormConfigurationService s2sFormConfigurationService;
    @Autowired
    @Qualifier(value="dataObjectService")
    private DataObjectService dataObjectService;
    @Autowired
    @Qualifier(value="parameterService")
    private ParameterService parameterService;

    private Optional<SubmissionDetails> retrieveSubmissionDetails(S2sOpportunity s2sOpportunity, S2sAppSubmission appSubmission) throws IllegalArgumentException, S2sCommunicationException {
        GetSubmissionListResponse fallbackResponse;
        if (appSubmission.getReceivedDate() != null && !this.isStatusStillAvailable(appSubmission.getReceivedDate())) {
            return Optional.empty();
        }
        GetSubmissionListResponse initialResponse = this.getS2sConnectorService(s2sOpportunity).getSubmissionList(s2sOpportunity.getOpportunityId(), appSubmission.getGgTrackingId(), s2sOpportunity.getPackageId(), null, null, appSubmission.getProposalNumber());
        if (initialResponse != null && CollectionUtils.isNotEmpty(initialResponse.getSubmissionDetails())) {
            return Optional.of(initialResponse.getSubmissionDetails().get(0));
        }
        if (StringUtils.isNotBlank((CharSequence)appSubmission.getGgTrackingId()) && (fallbackResponse = this.getS2sConnectorService(s2sOpportunity).getSubmissionList(null, appSubmission.getGgTrackingId(), null, null, null, appSubmission.getProposalNumber())) != null && CollectionUtils.isNotEmpty(fallbackResponse.getSubmissionDetails())) {
            return Optional.of(fallbackResponse.getSubmissionDetails().get(0));
        }
        return Optional.empty();
    }

    @Override
    public void refreshSubmission(S2sOpportunity s2sOpportunity, S2sAppSubmission appSubmission) throws IllegalArgumentException, S2sCommunicationException {
        if (s2sOpportunity == null) {
            throw new IllegalArgumentException("s2sOpportunity cannot be null");
        }
        if (appSubmission == null) {
            throw new IllegalArgumentException("appSubmission cannot be null");
        }
        boolean modified = false;
        Optional<SubmissionDetails> optDetails = this.retrieveSubmissionDetails(s2sOpportunity, appSubmission);
        if (optDetails.isPresent()) {
            boolean newReceiveDatePresent;
            SubmissionDetails details = optDetails.get();
            if (!Objects.equals(appSubmission.getAgencyTrackingId(), details.getAgencyTrackingNumber())) {
                appSubmission.setAgencyTrackingId(details.getAgencyTrackingNumber());
                modified = true;
            }
            boolean receivedDateChanged = appSubmission.getReceivedDate() != null && details.getReceivedDateTime() != null && !Objects.equals(appSubmission.getReceivedDate().getTime(), details.getReceivedDateTime().toGregorianCalendar().getTime().getTime());
            boolean bl = newReceiveDatePresent = appSubmission.getReceivedDate() == null && details.getReceivedDateTime() != null;
            if (receivedDateChanged || newReceiveDatePresent) {
                appSubmission.setReceivedDate(new Timestamp(details.getReceivedDateTime().toGregorianCalendar().getTime().getTime()));
                modified = true;
            }
            if (details.getGrantsGovApplicationStatus() != null && !Objects.equals(appSubmission.getStatus(), details.getGrantsGovApplicationStatus().value())) {
                appSubmission.setStatus(details.getGrantsGovApplicationStatus().value());
                modified = true;
            }
        }
        if (StringUtils.isNotBlank((CharSequence)appSubmission.getComments())) {
            appSubmission.setComments("");
            modified = true;
        }
        if (modified) {
            appSubmission.setLastModifiedDate(new Timestamp(DateTime.now().getMillis()));
            this.dataObjectService.save((Object)appSubmission, new PersistenceOption[0]);
        }
        this.saveSponsorProposalNumber(s2sOpportunity.getDevelopmentProposal(), appSubmission.getAgencyTrackingId());
    }

    private boolean isStatusStillAvailable(Date submittedDate) {
        DateTime receivedDate = new DateTime((Object)submittedDate);
        return !receivedDate.isBefore((ReadableInstant)INCREASED_YEAR_STORAGE_DATE) && !receivedDate.isBefore((ReadableInstant)DateTime.now().minus((ReadablePeriod)INCREASED_STORAGE));
    }

    protected void saveSponsorProposalNumber(DevelopmentProposal developmentProposal, String agencyTrackingId) {
        if (StringUtils.isNotBlank((CharSequence)agencyTrackingId)) {
            if (StringUtils.isBlank((CharSequence)developmentProposal.getSponsorProposalNumber())) {
                developmentProposal.setSponsorProposalNumber(agencyTrackingId);
                developmentProposal = (DevelopmentProposal)this.getDataObjectService().save((Object)developmentProposal, new PersistenceOption[0]);
            }
            this.proposalAdminDetailsService.findProposalAdminDetailsByPropDevNumber(developmentProposal.getProposalNumber()).stream().filter(pad -> pad.getInstProposalId() != null).forEach(pad -> this.instPropSponsorService.updateSponsorProposalNumber(pad.getInstProposalId(), agencyTrackingId));
        }
    }

    private boolean doubleSubmissionViolation(String proposalNumber) {
        QueryResults submissions;
        if (this.getParameterService().getParameterValueAsBoolean("KC-S2S", "All", PREVENT_MULTIPLE_S2S_SUBMISSIONS).booleanValue() && (submissions = this.getDataObjectService().findMatching(S2sAppSubmission.class, QueryByCriteria.Builder.create().setPredicates(new Predicate[]{PredicateFactory.and((Predicate[])new Predicate[]{PredicateFactory.equal((String)"proposalNumber", (Object)proposalNumber), PredicateFactory.isNotNull((String)"ggTrackingId")})}).build())).getResults().stream().anyMatch(submission -> StringUtils.isNotBlank((CharSequence)submission.getGgTrackingId()))) {
            if (LOG.isInfoEnabled()) {
                LOG.info("Proposal Number: " + proposalNumber + " is already submitted.");
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean submitApplication(ProposalDevelopmentDocument pdDoc) throws S2sCommunicationException {
        DevelopmentProposal proposal = pdDoc.getDevelopmentProposal();
        String proposalNumber = proposal.getProposalNumber();
        if (this.doubleSubmissionViolation(proposalNumber)) {
            return true;
        }
        FormGenerationResults result = this.generateAndValidateForms(pdDoc);
        if (result.isValid()) {
            String xmlForSubmission = result.getApplicationXml();
            List<AttachmentData> attachmentsForSubmission = result.getAttachments().stream().filter(org.kuali.coeus.sys.framework.util.CollectionUtils.distinctByKey(AttachmentData::getContentId)).collect(Collectors.toList());
            this.logDuplicateContentIds(proposalNumber, result.getAttachments(), attachmentsForSubmission);
            Map<String, DataHandler> attachments = attachmentsForSubmission.stream().map(attachment -> org.kuali.coeus.sys.framework.util.CollectionUtils.entry(attachment.getContentId(), new DataHandler((DataSource)new ByteArrayDataSource(attachment.getContent(), attachment.getContentType())))).collect(org.kuali.coeus.sys.framework.util.CollectionUtils.entriesToMap());
            S2SConnectorService connectorService = this.getS2sConnectorService(proposal.getS2sOpportunity());
            SubmitApplicationResponse response = connectorService.submitApplication(xmlForSubmission, attachments, proposalNumber);
            this.saveSubmissionDetails(proposal, response, xmlForSubmission, attachmentsForSubmission);
            return true;
        }
        LOG.error("Submission errors exist that were not prevented by ProposalDevelopmentGrantsGovAuditRule.  Proposal Number: " + proposalNumber + " Errors: " + result.getErrors());
        return false;
    }

    private FormGenerationResults generateAndValidateForms(ProposalDevelopmentDocument pdDoc) {
        return pdDoc.getDevelopmentProposal().isMultiProjectParent() ? this.getFormGeneratorService().generateAndValidateMPForms((ProposalDevelopmentDocumentContract)pdDoc, pdDoc.getHierarchyChildren()) : this.getFormGeneratorService().generateAndValidateForms((ProposalDevelopmentDocumentContract)pdDoc);
    }

    @Override
    public Optional<KcFile> getApplicationZip(S2sOpportunity s2sOpportunity, S2sAppSubmission appSubmission) throws IllegalArgumentException, S2sCommunicationException {
        if (s2sOpportunity == null) {
            throw new IllegalArgumentException("s2sOpportunity cannot be null");
        }
        if (appSubmission == null) {
            throw new IllegalArgumentException("appSubmission cannot be null");
        }
        String proposalNumber = s2sOpportunity.getProposalNumber();
        S2SConnectorService connectorService = this.getS2sConnectorService(s2sOpportunity);
        GetApplicationZipResponse response = connectorService.getApplicationZip(appSubmission.getGgTrackingId(), proposalNumber);
        if (response != null && response.getFileDataHandler() != null) {
            DataHandler handler = response.getFileDataHandler();
            try {
                return Optional.of(new S2sFileDto(handler.getName() != null ? handler.getName() : "Grant Submission.zip", handler.getContentType(), handler.getInputStream().readAllBytes()));
            }
            catch (IOException e) {
                throw new S2sCommunicationException(e);
            }
        }
        return Optional.empty();
    }

    private void logDuplicateContentIds(String proposalNumber, List<AttachmentData> resultAttachments, List<AttachmentData> attachmentsForSubmission) {
        if (LOG.isWarnEnabled() && resultAttachments.size() != attachmentsForSubmission.size()) {
            LOG.warn("Proposal " + proposalNumber + " has duplicate contentIds " + resultAttachments.stream().map(AttachmentData::getContentId).collect(Collectors.toList()));
        }
    }

    protected ArrayList<S2sOpportunity> convertToArrayList(String source, GetOpportunityListResponse resList) {
        ArrayList<S2sOpportunity> convList = new ArrayList<S2sOpportunity>();
        if (resList == null || CollectionUtils.isEmpty(resList.getOpportunityDetails())) {
            return convList;
        }
        for (OpportunityDetails opportunityInfo : resList.getOpportunityDetails()) {
            convList.add(this.convert2S2sOpportunity(source, opportunityInfo));
        }
        return convList;
    }

    protected S2sOpportunity convert2S2sOpportunity(String providerCode, OpportunityDetails oppInfo) {
        S2sOpportunity s2Opportunity = new S2sOpportunity();
        s2Opportunity.setClosingDate(oppInfo.getClosingDate() == null ? null : this.endOfDay(oppInfo.getClosingDate().toGregorianCalendar()));
        s2Opportunity.setCompetitionId(oppInfo.getCompetitionID());
        s2Opportunity.setCompetitionTitle(oppInfo.getCompetitionTitle());
        s2Opportunity.setPackageId(oppInfo.getPackageID());
        s2Opportunity.setInstructionUrl(oppInfo.getInstructionsURL());
        s2Opportunity.setOpeningDate(oppInfo.getOpeningDate() == null ? null : this.endOfDay(oppInfo.getOpeningDate().toGregorianCalendar()));
        s2Opportunity.setOpportunityId(oppInfo.getFundingOpportunityNumber());
        s2Opportunity.setOpportunityTitle(oppInfo.getFundingOpportunityTitle());
        s2Opportunity.setSchemaUrl(oppInfo.getSchemaURL());
        s2Opportunity.setProviderCode(providerCode);
        s2Opportunity.setOfferingAgency(oppInfo.getOfferingAgency());
        s2Opportunity.setAgencyContactInfo(oppInfo.getAgencyContactInfo());
        s2Opportunity.setMultiProject(oppInfo.isIsMultiProject());
        s2Opportunity.setS2sOpportunityCfdas(Optional.ofNullable(oppInfo.getCFDADetails()).orElse(Collections.emptyList()).stream().filter(Objects::nonNull).filter(cdfaDetail -> StringUtils.isNotBlank((CharSequence)cdfaDetail.getNumber())).map(cdfaDetail -> {
            S2sOpportunityCfda cfda = new S2sOpportunityCfda();
            cfda.setCfdaNumber(cdfaDetail.getNumber());
            cfda.setCfdaDescription(cdfaDetail.getTitle());
            return cfda;
        }).collect(Collectors.toList()));
        return s2Opportunity;
    }

    private GregorianCalendar endOfDay(GregorianCalendar date) {
        date.set(11, 23);
        date.set(12, 59);
        date.set(13, 59);
        return date;
    }

    @Override
    public List<S2sOpportunity> searchOpportunity(String providerCode, String cfdaNumber, String opportunityId, String competitionId, String packageId) throws S2sCommunicationException {
        opportunityId = StringUtils.isBlank((CharSequence)(opportunityId = StringUtils.upperCase((String)opportunityId))) ? null : opportunityId;
        cfdaNumber = StringUtils.isBlank((CharSequence)cfdaNumber) ? null : cfdaNumber;
        competitionId = StringUtils.upperCase((String)competitionId);
        competitionId = StringUtils.isBlank((CharSequence)competitionId) ? null : competitionId;
        S2sProviderContract provider = this.s2sProviderService.findS2SProviderByCode(providerCode);
        if (provider == null) {
            throw new S2sCommunicationException("An invalid provider code was provided when attempting to search for opportunities.");
        }
        S2SConnectorService connectorService = (S2SConnectorService)KcServiceLocator.getService(provider.getConnectorServiceName());
        if (connectorService == null) {
            throw new S2sCommunicationException("The connector service '" + provider.getConnectorServiceName() + "' required by '" + provider.getDescription() + "' S2S provider is not configured.");
        }
        return this.convertToArrayList(provider.getCode(), connectorService.getOpportunityList(cfdaNumber, opportunityId, competitionId, packageId));
    }

    protected List<S2sOppForms> parseOpportunityForms(S2sOpportunity opportunity) throws S2sCommunicationException {
        boolean sendOverallSchemaUrl = opportunity.isMultiProject() && "Overall".equalsIgnoreCase(opportunity.getComponentType());
        this.setOpportunityContent(opportunity);
        return this.opportunitySchemaParserService.getForms(opportunity.getProposalNumber(), sendOverallSchemaUrl ? opportunity.getOverallSchemaUrl() : opportunity.getSchemaUrl());
    }

    @Override
    public List<String> setMandatoryForms(DevelopmentProposal proposal, S2sOpportunity s2sOpportunity) {
        ArrayList<String> missingMandatoryForms = new ArrayList<String>();
        s2sOpportunity.setS2sProvider((S2sProvider)this.getDataObjectService().find(S2sProvider.class, (Object)s2sOpportunity.getProviderCode()));
        List<S2sOppForms> s2sOppForms = this.parseOpportunityForms(s2sOpportunity);
        if (s2sOppForms != null) {
            for (S2sOppForms s2sOppForm : s2sOppForms) {
                S2sFormConfigurationContract cfg = this.getS2sFormConfigurationService().findS2sFormConfigurationByFormName(s2sOppForm.getFormName());
                if (cfg != null) {
                    proposal.getS2sUserAttachedForms().stream().filter(form -> StringUtils.equals((CharSequence)form.getNamespace(), (CharSequence)s2sOppForm.getOppNameSpace())).findFirst().ifPresent(form -> s2sOppForm.setUserAttachedForm(true));
                    s2sOppForm.setAvailable(s2sOppForm.getAvailable() != false && (cfg.isActive() || s2sOppForm.getUserAttachedForm() != false));
                }
                if (!s2sOppForm.getMandatory().booleanValue() || s2sOppForm.getAvailable().booleanValue()) continue;
                missingMandatoryForms.add(s2sOppForm.getFormName());
            }
        }
        if (CollectionUtils.isEmpty(missingMandatoryForms)) {
            if (s2sOppForms != null) {
                s2sOppForms.sort((arg0, arg1) -> {
                    int result = arg0.getMandatory().compareTo(arg1.getMandatory()) * -1;
                    if (result == 0) {
                        result = arg0.getFormName().compareTo(arg1.getFormName());
                    }
                    return result;
                });
            }
            s2sOpportunity.setS2sOppForms(s2sOppForms);
        }
        return missingMandatoryForms;
    }

    @Override
    public void setOpportunityContent(S2sOpportunity opportunity) {
        String opportunityContent = this.getOpportunitySchemaParserService().fetchSchema(opportunity.getSchemaUrl());
        opportunity.setOpportunity(opportunityContent);
    }

    protected void saveSubmissionDetails(DevelopmentProposal proposal, SubmitApplicationResponse response, String xmlForSubmission, List<AttachmentData> attachmentsForSubmission) {
        if (response != null) {
            String proposalNumber = proposal.getProposalNumber();
            S2sAppSubmission appSubmission = new S2sAppSubmission();
            appSubmission.setStatus("Submitted to S2S");
            appSubmission.setComments("");
            List<S2sAppAttachments> s2sAppAttachmentList = attachmentsForSubmission.stream().map(attachment -> {
                S2sAppAttachments appAttachments = new S2sAppAttachments();
                appAttachments.setContentId(attachment.getContentId());
                appAttachments.setProposalNumber(proposalNumber);
                appAttachments.setContentType(attachment.getContentType());
                appAttachments.setHashCode(attachment.getHashValue());
                appAttachments.setData(attachment.getContent());
                appAttachments.setName(attachment.getFileName());
                return appAttachments;
            }).collect(Collectors.toList());
            S2sApplication application = new S2sApplication();
            application.setApplication(xmlForSubmission);
            application.setProposalNumber(proposalNumber);
            application.setS2sAppAttachmentList(s2sAppAttachmentList);
            ArrayList<S2sApplication> s2sApplicationList = new ArrayList<S2sApplication>();
            s2sApplicationList.add(application);
            appSubmission.setGgTrackingId(response.getGrantsGovTrackingNumber());
            appSubmission.setReceivedDate(new Timestamp(response.getReceivedDateTime().toGregorianCalendar().getTimeInMillis()));
            appSubmission.setS2sApplication((S2sApplication)s2sApplicationList.get(0));
            appSubmission.setProposalNumber(proposalNumber);
            List<S2sAppSubmission> appList = proposal.getS2sAppSubmission();
            int submissionNumber = 1;
            for (S2sAppSubmission submittedApplication : appList) {
                if (submittedApplication.getSubmissionNumber() < submissionNumber) continue;
                ++submissionNumber;
            }
            appSubmission.setSubmissionNumber(submissionNumber);
            this.getDataObjectService().save((Object)appSubmission, new PersistenceOption[0]);
            proposal.refreshReferenceObject("s2sAppSubmission");
        }
    }

    @Override
    public File getGrantsGovSavedFile(DevelopmentProposal proposal) throws IOException {
        String loggingDirectory = this.s2SConfigurationService.getValueAsString("print.xml.directory");
        String opportunityId = proposal.getS2sOpportunity().getOpportunityId();
        String proposalnumber = proposal.getProposalNumber();
        String exportDate = StringUtils.replaceChars((String)proposal.getUpdateTimestamp().toString(), (String)":", (String)"_");
        exportDate = StringUtils.replaceChars((String)exportDate, (String)" ", (String)".");
        if (StringUtils.isNotBlank((CharSequence)loggingDirectory)) {
            File directory = new File(loggingDirectory);
            if (!directory.exists()) {
                directory.createNewFile();
            }
            return new File(loggingDirectory + opportunityId + "." + proposalnumber + "." + exportDate + ".zip");
        }
        return null;
    }

    protected S2SConnectorService getS2sConnectorService(S2sOpportunityContract s2sOpportunity) {
        return (S2SConnectorService)KcServiceLocator.getService(s2sOpportunity.getS2sProvider().getConnectorServiceName());
    }

    public ProposalAdminDetailsService getProposalAdminDetailsService() {
        return this.proposalAdminDetailsService;
    }

    public void setProposalAdminDetailsService(ProposalAdminDetailsService proposalAdminDetailsService) {
        this.proposalAdminDetailsService = proposalAdminDetailsService;
    }

    public InstPropSponsorService getInstPropSponsorService() {
        return this.instPropSponsorService;
    }

    public void setInstPropSponsorService(InstPropSponsorService instPropSponsorService) {
        this.instPropSponsorService = instPropSponsorService;
    }

    public FormGeneratorService getFormGeneratorService() {
        return this.formGeneratorService;
    }

    public void setFormGeneratorService(FormGeneratorService formGeneratorService) {
        this.formGeneratorService = formGeneratorService;
    }

    public S2sProviderService getS2sProviderService() {
        return this.s2sProviderService;
    }

    public void setS2sProviderService(S2sProviderService s2sProviderService) {
        this.s2sProviderService = s2sProviderService;
    }

    public S2SConfigurationService getS2SConfigurationService() {
        return this.s2SConfigurationService;
    }

    public void setS2SConfigurationService(S2SConfigurationService s2SConfigurationService) {
        this.s2SConfigurationService = s2SConfigurationService;
    }

    public OpportunitySchemaParserService getOpportunitySchemaParserService() {
        return this.opportunitySchemaParserService;
    }

    public void setOpportunitySchemaParserService(OpportunitySchemaParserService opportunitySchemaParserService) {
        this.opportunitySchemaParserService = opportunitySchemaParserService;
    }

    public DataObjectService getDataObjectService() {
        return this.dataObjectService;
    }

    public void setDataObjectService(DataObjectService dataObjectService) {
        this.dataObjectService = dataObjectService;
    }

    public S2sFormConfigurationService getS2sFormConfigurationService() {
        return this.s2sFormConfigurationService;
    }

    public void setS2sFormConfigurationService(S2sFormConfigurationService s2sFormConfigurationService) {
        this.s2sFormConfigurationService = s2sFormConfigurationService;
    }

    public ParameterService getParameterService() {
        return this.parameterService;
    }

    public void setParameterService(ParameterService parameterService) {
        this.parameterService = parameterService;
    }
}

