/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krad.uif.element;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.kuali.rice.krad.datadictionary.parse.BeanTag;
import org.kuali.rice.krad.datadictionary.parse.BeanTagAttribute;
import org.kuali.rice.krad.messages.MessageService;
import org.kuali.rice.krad.service.KRADServiceLocatorWeb;
import org.kuali.rice.krad.uif.element.ProgressBar;
import org.kuali.rice.krad.uif.util.LifecycleElement;

@BeanTag(name="stepProgressBar-bean", parent="Uif-StepProgressBar")
public class StepProgressBar
extends ProgressBar {
    private static final long serialVersionUID = 1053164737424481519L;
    private Map<String, String> steps = new LinkedHashMap<String, String>();
    private List<String> stepLabelClasses;
    private List<String> accessibilityText = new ArrayList<String>();
    private String currentStep;
    private String completeStep;
    private Integer verticalHeight;
    private Integer verticalStepHeight;

    public StepProgressBar() {
        this.stepLabelClasses = new ArrayList<String>();
    }

    @Override
    public void performFinalize(Object model, LifecycleElement parent) {
        int totalSteps;
        if (this.getPercentComplete() != null && this.currentStep == null) {
            this.calculateCurrentStepFromPercentage();
        } else if (this.currentStep != null) {
            this.setPercentComplete(null);
        }
        super.performFinalize(model, parent);
        MessageService messageService = KRADServiceLocatorWeb.getMessageService();
        String cssDimension = "width: ";
        if (this.isVertical()) {
            cssDimension = "height: ";
            this.addStyleClass("uif-stepProgressBar-vertical");
        }
        if ((totalSteps = this.steps.size()) == 0) {
            throw new RuntimeException("At least one step is required for a StepProgressBar: " + this.getId() + " with parent: " + parent.getId());
        }
        boolean explicitlySetPercentages = CollectionUtils.isNotEmpty(this.getSegmentPercentages());
        boolean explicitlySetClasses = CollectionUtils.isNotEmpty(this.getSegmentClasses());
        if (explicitlySetPercentages && explicitlySetClasses && this.getSegmentClasses().size() != this.getSegmentPercentages().size()) {
            throw new RuntimeException("If segmentPercentages are set on a StepProgressBar type, and segmentClasses are also set, the lists MUST contain the same number of items");
        }
        this.populateProgressBarRenderingLists(totalSteps, cssDimension, explicitlySetPercentages, explicitlySetClasses);
        if (this.isVertical() && this.getVerticalHeight() == null) {
            this.setVerticalHeight(this.getSegmentSizes().size() * this.verticalStepHeight);
        }
        if (this.currentStep != null && this.currentStep.equals(this.completeStep)) {
            this.addAriaAttribute("valuenow", Integer.toString(this.steps.size()));
            this.addAriaAttribute("valuetext", messageService.getMessageText("accessibility.progressBar.complete"));
        }
        this.addAriaAttribute("valuemin", "0");
        this.addAriaAttribute("valuemax", Integer.toString(totalSteps));
    }

    private String calculateCurrentStepFromPercentage() {
        if (this.getPercentComplete() == 0) {
            return "";
        }
        if (this.getPercentComplete() == 100) {
            return this.completeStep;
        }
        int size = this.steps.size();
        double currentStep = Math.ceil(size * this.getPercentComplete());
        String key = "";
        Iterator<String> stepIterator = this.steps.keySet().iterator();
        int step = 0;
        while (stepIterator.hasNext() && (double)step <= currentStep) {
            key = stepIterator.next();
            ++step;
        }
        this.setPercentComplete(null);
        return key;
    }

    public void populateProgressBarRenderingLists(int totalSteps, String cssDimension, boolean explicitlySetPercentages, boolean explicitlySetClasses) {
        MessageService messageService = KRADServiceLocatorWeb.getMessageService();
        double percentage = Math.floor(100 / totalSteps);
        double percentTotal = 0.0;
        boolean currentStepFound = false;
        if (StringUtils.isBlank((CharSequence)this.currentStep) || !this.steps.containsKey(this.currentStep) && !this.currentStep.equals(this.completeStep)) {
            currentStepFound = true;
        }
        Iterator<String> stepIterator = this.steps.keySet().iterator();
        for (int step = 0; stepIterator.hasNext() && step <= totalSteps; ++step) {
            double stepPercentage;
            String stepKey = stepIterator.next();
            if (explicitlySetPercentages) {
                Integer percentageValue = this.getSegmentPercentages().get(step);
                stepPercentage = percentageValue.intValue();
                percentTotal += (double)percentageValue.intValue();
            } else {
                stepPercentage = percentage;
                percentTotal += percentage;
            }
            if (!stepIterator.hasNext() && percentTotal < 100.0) {
                stepPercentage = percentage + (100.0 - percentTotal);
                percentTotal = 100.0;
            }
            String dimensionValue = stepPercentage + "%";
            String cssClasses = "progress-bar progress-bar-success";
            String labelCssClasses = "uif-step complete";
            String srText = messageService.getMessageText("accessibility.progressBar.completeStep");
            if (stepKey.equals(this.currentStep)) {
                currentStepFound = true;
                cssClasses = "progress-bar progress-bar-info";
                labelCssClasses = "uif-step active";
                srText = messageService.getMessageText("accessibility.progressBar.currentStep");
                this.addAriaAttribute("valuenow", Integer.toString(step));
                this.addAriaAttribute("valuetext", srText + this.steps.get(stepKey));
            } else if (currentStepFound) {
                cssClasses = "progress-bar progress-bar-empty";
                labelCssClasses = "uif-step";
                srText = messageService.getMessageText("accessibility.progressBar.futureStep");
            }
            this.getSegmentSizes().add(cssDimension + dimensionValue);
            if (!explicitlySetClasses) {
                this.getSegmentClasses().add(cssClasses);
            }
            this.getStepLabelClasses().add(labelCssClasses);
            this.accessibilityText.add(srText);
        }
    }

    @BeanTagAttribute(name="steps", type=BeanTagAttribute.AttributeType.MAPVALUE)
    public Map<String, String> getSteps() {
        return this.steps;
    }

    public void setSteps(Map<String, String> steps) {
        this.steps = steps;
    }

    public Collection<String> getStepCollection() {
        return this.steps.values();
    }

    public List<String> getStepLabelClasses() {
        return this.stepLabelClasses;
    }

    public List<String> getAccessibilityText() {
        return this.accessibilityText;
    }

    @BeanTagAttribute(name="currentStep")
    public String getCurrentStep() {
        return this.currentStep;
    }

    public void setCurrentStep(String currentStep) {
        this.currentStep = currentStep;
    }

    @BeanTagAttribute(name="completeStep")
    public String getCompleteStep() {
        return this.completeStep;
    }

    public void setCompleteStep(String completeStep) {
        this.completeStep = completeStep;
    }

    @BeanTagAttribute(name="verticalHeight")
    public Integer getVerticalHeight() {
        return this.verticalHeight;
    }

    public void setVerticalHeight(Integer verticalHeight) {
        this.verticalHeight = verticalHeight;
    }

    @BeanTagAttribute(name="verticalStepHeight")
    public Integer getVerticalStepHeight() {
        return this.verticalStepHeight;
    }

    public void setVerticalStepHeight(Integer verticalStepHeight) {
        this.verticalStepHeight = verticalStepHeight;
    }
}

