<%--
  #%L
  %%
  Copyright (C) 2005 - 2025 Kuali, Inc. - All Rights Reserved
  %%
  You may use and modify this code under the terms of the Kuali, Inc.
  Pre-Release License Agreement. You may not distribute it.
  
  You should have received a copy of the Kuali, Inc. Pre-Release License
  Agreement with this file. If not, please write to license@kuali.co.
  #L%
  --%>

<%@ include file="/kr/WEB-INF/jsp/tldHeader.jsp"%>


<%@ attribute name="noteObject" required="true" type="org.kuali.kra.infrastructure.KraNotepadInterface" %>
<%@ attribute name="noteParmeterString" required="true"%>
<%@ attribute name="viewRestrictedNotes" required="true" type="java.lang.Boolean" %>
<%@ attribute name="statusIndex" required="true"%>
<%@ attribute name="modifyPermission" required="true" type="java.lang.Boolean" %>
<%@ attribute name="hasAdministratorRole" required="true" type="java.lang.Boolean" %>
<%@ attribute name="action" required="true"%>
<%@ attribute name="isAddLine" required="true" type="java.lang.Boolean" %>
<%@ attribute name="showUpdate" required="false" type="java.lang.Boolean" %>

<c:set var="notesAttributes" value="${DataDictionary.AwardNotepad.attributes}" />

<c:if test="${!noteObject.restrictedView || (viewRestrictedNotes && noteObject.restrictedView)}">
	<tr>
		<th class="infoline">
			<c:choose>
				<c:when test="${isAddLine }">
					Add:
				</c:when>
				<c:otherwise>
					<c:out value="${statusIndex + 1}" />
				</c:otherwise>
			</c:choose>
			
		</th>
		<td valign="middle">
			<c:out value="${noteObject.createUserFullName }"/>
			<Br /> 
			<kul:htmlControlAttribute property="${noteParmeterString }.createTimestamp" attributeEntry="${notesAttributes.updateTimestamp}" readOnly="true" />
			
			
		</td>
		<td valign="middle">
			<c:out value="${noteObject.updateUserFullName }"/>
			<Br /> 
			<kul:htmlControlAttribute property="${noteParmeterString }.updateTimestamp" attributeEntry="${notesAttributes.updateTimestamp}" readOnly="true" />
		</td>
		<td valign="middle">
			<div align="center">
				<kul:htmlControlAttribute property="${noteParmeterString }.noteTopic" attributeEntry="${notesAttributes.noteTopic}" 
					readOnly="${!modifyPermission || !noteObject.editable}" />
			</div>
		</td>
		<td valign="middle">
			<div align="left">
				<c:choose> 
					<c:when test="${!modifyPermission || !noteObject.editable}">
						<c:set var="displaySize" value="120"/>
						<c:choose>
				            <c:when test="${fn:length(noteObject.comments) > displaySize}">
			                	  ${fn:substring(noteObject.comments,0,displaySize - 1)}...
			                	  
			                	  <html:hidden property="${noteParmeterString }.comments" write="false" styleId="${noteParmeterString }.comments" />
			                	  <kul:expandedTextArea textAreaFieldName="${noteParmeterString }.comments" action="${action }" 
			                	  	textAreaLabel="${notesAttributes.comments.label}"  readOnly="true" />
			                	  
			                </c:when>
				            <c:otherwise>
			                	  ${noteObject.comments}
			                </c:otherwise>
			            </c:choose>
					</c:when>
					<c:otherwise>
						<kul:htmlControlAttribute property="${noteParmeterString }.comments" attributeEntry="${notesAttributes.comments}" />
					</c:otherwise>
				</c:choose>
			</div>
		</td>
		
		<td valign="middle">
			<div align="center">
				<kul:htmlControlAttribute property="${noteParmeterString }.restrictedView" attributeEntry="${notesAttributes.restrictedView}" 
					readOnly="${!modifyPermission || ((!viewRestrictedNotes || !noteObject.editable) && !hasAdministratorRole)}" />
					
			</div>
		</td>
		<td>
			<div align=center>
				<nobr>
					<c:choose>
						<c:when test="${isAddLine }">
							<html:image property="methodToCall.addNote.anchor${tabKey}" src='${ConfigProperties.kra.externalizable.images.url}tinybutton-add1.gif' styleClass="tinybutton"/>
						</c:when>
						<c:otherwise>
							<c:choose>
								<c:when test="${modifyPermission}">
									<c:if test="${!noteObject.editable}">
										<html:image property="methodToCall.editNote.line${statusIndex}.anchor${tabKey}" src='${ConfigProperties.kra.externalizable.images.url}tinybutton-edit1.gif'
											styleClass='tinybutton' />
										&nbsp;	
		  	        				</c:if>
		  	        				<html:image property="methodToCall.deleteNote.line${statusIndex}.anchor${tabKey}" src='${ConfigProperties.kra.externalizable.images.url}tinybutton-delete1.gif' 
		  	        					styleClass="tinybutton" />
		  	        			</c:when>
								<c:when test="${showUpdate}">
									<html:image property="methodToCall.updateNotes.line${statusIndex}.anchor${tabKey}" src='${ConfigProperties.kra.externalizable.images.url}tinybutton-updateview.gif'
											styleClass='tinybutton' />
									&nbsp;	
		  	        			</c:when>
								<c:otherwise>
						   			&nbsp;
		    					</c:otherwise>
							</c:choose>
						</c:otherwise>
					</c:choose>
				</nobr>
			</div>
		</td>
	</tr>
</c:if>
