/*-
 * #%L
 * %%
 * Copyright (C) 2005 - 2025 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

var Kc = Kc || {};
Kc.PropDev.s2s = Kc.PropDev.s2s || {};
(function (namespace, $) {

    namespace.fetchForms = function(downloadToken, formKey) {
        var startTime = new Date().getTime();
        var fileDownloadCheckTimer = window.setInterval(function () {
            if (new Date().getTime() - startTime > (60000 * 2)) {
                window.clearInterval(fileDownloadCheckTimer);
                $.cookie('fileDownloadToken', null);
                $('#downloadMessage p').text('Error: form retrieval timed out.');
                $('#PropDev-OpportunityPrintFormsDialog-Section_header span').text('Error...');
                $('#downloadMessage').removeClass('alert-info').addClass('alert-danger');
            } else {
                var kualiDownloadToken = $.cookie('KualiDownloadToken');
                if (kualiDownloadToken === downloadToken) {
                    window.clearInterval(fileDownloadCheckTimer);
                    $.cookie('fileDownloadToken', null);
                    $('#PropDev-OpportunityPrintFormsDialog-Section-Close-Button').click();
                }

                $.ajax({
                    global: false,
                    url: 'proposalDevelopment?methodToCall=checkForms&formKey=' + formKey,
                    type: 'GET',
                    success: function requestFile() {
                        $('#PropDev-OpportunityPage').add('iframe').hide().attr('src', 'proposalDevelopment?methodToCall=fetchForms&formKey=' + formKey)
                    },
                    error: function swallow() { }
                });
            }

        }, 5000);
        $('#PropDev-OpportunityPrintFormsDialog-Section-Close-Button').click(function clear() {
            window.clearInterval(fileDownloadCheckTimer);
            $.cookie('fileDownloadToken', null);
        })
    };
    namespace.fetchPackage = function(downloadToken, formKey) {
        var startTime = new Date().getTime();
        var fileDownloadCheckTimer = window.setInterval(function () {
            if (new Date().getTime() - startTime > (60000 * 2)){
                window.clearInterval(fileDownloadCheckTimer);
                $.cookie('fileDownloadToken', null);
                $('#downloadMessage p').text('Error: package retrieval timed out.');
                $('#PropDev-OpportunityPrintPackageDialog-Section_header span').text('Error...');
                $('#downloadMessage').removeClass('alert-info').addClass('alert-danger');
            } else {
                var kualiDownloadToken = $.cookie('KualiDownloadToken');
                if (kualiDownloadToken === downloadToken) {
                    window.clearInterval(fileDownloadCheckTimer);
                    $.cookie('fileDownloadToken', null);
                    $('#PropDev-OpportunityPrintPackageDialog-Section-Close-Button').click();
                }

                $.ajax({
                    global: false,
                    url: 'proposalDevelopment?methodToCall=checkPackage&formKey=' + formKey,
                    type: 'GET',
                    success: function requestFile() {
                        $('#PropDev-OpportunityPage').add('iframe').hide().attr('src', 'proposalDevelopment?methodToCall=fetchPackage&formKey=' + formKey)
                    },
                    error: function swallow() { }
                });
            }
        }, 5000);
        $('#PropDev-OpportunityPrintPackageDialog-Section-Close-Button').click(function clear() {
            window.clearInterval(fileDownloadCheckTimer);
            $.cookie('fileDownloadToken', null);
        })
    };
    namespace.revisionToggle = function(object) {
        if ($(object).find('select').find(":selected").val() == "E") {
            $("input[name='document.developmentProposal.s2sOpportunity.revisionOtherDescription']").parent("div").show();
        } else {
            $("input[name='document.developmentProposal.s2sOpportunity.revisionOtherDescription']").parent("div").hide();
            $("input[name='document.developmentProposal.s2sOpportunity.revisionOtherDescription']").val("");
        }
    };
    namespace.selectAllIncludedForms = function(document) {
    	var count = 0;
        var include = true;
        $.each(document, function(index, element) {
            if(element.type == 'checkbox') {
    			if (element.name == 'document.developmentProposal.s2sOpportunity.s2sOppForms['+count+'].include') {
    				include = element.checked;
                }
                if (element.name == 'document.developmentProposal.s2sOpportunity.s2sOppForms['+count+'].selectToPrint') {
                    if(element.disabled == true) {
                    	element.checked = false;
                    } else if(include == false) {
                    	element.checked = false;
                    } else {
                    	element.checked = true;
                    }
                    include = true;
                    count++;
                }
            }
    	});
    };
})(Kc.PropDev.s2s, jQuery);
