<%--
  #%L
  %%
  Copyright (C) 2005 - 2026 Kuali, Inc. - All Rights Reserved
  %%
  You may use and modify this code under the terms of the Kuali, Inc.
  Pre-Release License Agreement. You may not distribute it.
  You should have received a copy of the Kuali, Inc. Pre-Release License
  Agreement with this file. If not, please write to license@kuali.co.
  #L%
  --%>
<%@ include file="/WEB-INF/jsp/kraTldHeader.jsp"%>
<%@ include file="/WEB-INF/jsp/kraExconTldHeader.jsp" %>
<html lang="en">
<head>
    <title>Visual Compliance Search Results</title>
</head>
<body>
<c:set var="readOnly" value="${not KualiForm.editingMode['fullEntry']}" scope="request" />

<div align="center"><h1>Visual Compliance Screening Results</h1></div>
<hr>
<c:choose>
    <c:when test="${KualiForm.exconProjectRPSResultsBean != null}">
        <c:set target="${KualiForm.exconProjectRPSResultsBean}" property="currentResult" value="${param['line']}" />
        <c:set var="resultSet" value="${KualiForm.exconProjectRPSResultsBean.rpsResultContentObject}" />
    </c:when>
    <c:otherwise>
        <c:set target="${KualiForm.exconIntlShipmentBean}" property="currentResult" value="${param['line']}" />
        <c:set var="resultSet" value="${KualiForm.exconIntlShipmentBean.rpsResultContentObject}" />
    </c:otherwise>
</c:choose>
<c:if test='${resultSet.nomatch.value == "1"}'>
    <div align="center"><h2>No Match</h2></div>
</c:if>
<table cellspacing="1" cellpadding="5">
    <tr><th colspan="2"><b>${resultSet.errorstring.value}</b></th></tr>
    <tr><th align="right"><b>Name:</b></th><td>${resultSet.sname.value}</td></tr>
    <tr><th align="right"><b>Company:</b></th><td>${resultSet.scompany.value}</td></tr>
    <tr><th align="right"><b>Address:</b></th><td>${resultSet.saddress1.value}</td></tr>
    <tr><th align="right"><b>Country:</b></th><td>${resultSet.scountry.value}</td></tr>
</table>
<hr>
<table width="100%" cellspacing="1" cellpadding="5">
    <tr><th colspan="2" bgcolor="#d3d3d3">&nbsp;</th></tr>
    <c:forEach var="result" items="${resultSet.results.value.result}" varStatus="resultRowStatus">
        <tr><th bgcolor="#d3d3d3" width="10%"><b>Reference&nbsp;No.</b></th><td>${result.dpId.value}</td></tr>
        <tr><th bgcolor="#d3d3d3"><b>Description</b></th>
            <td>
                    ${result.name.value}<br>
                    ${result.street1.value}<br>
                    ${result.street2.value}<br>
                    ${result.city.value}<br>
                    ${result.state.value}<br>
                    ${result.country.value}
            </td>
        </tr>
        <tr><th bgcolor="#d3d3d3"><b>Notes</b></th><td>${result.notes.value}</td></tr>
        <tr><th bgcolor="#d3d3d3"><b>Federal&nbsp;Register</b></th><td>${result.frc.value}</td></tr>
        <tr><th bgcolor="#d3d3d3"><b>Source</b></th><td>${result.list.value}</td></tr>
        <tr><th colspan="2" bgcolor="#d3d3d3">&nbsp;</th></tr>
    </c:forEach>
</table>

<SCRIPT type="text/javascript">
    var kualiForm = document.forms['KualiForm'];
    var kualiElements = kualiForm.elements;
</SCRIPT>
<script language="javascript" src="scripts/kuali_application.js"></script>

</body>
</html>
