<%--
  #%L
  %%
  Copyright (C) 2005 - 2025 Kuali, Inc. - All Rights Reserved
  %%
  You may use and modify this code under the terms of the Kuali, Inc.
  Pre-Release License Agreement. You may not distribute it.
  
  You should have received a copy of the Kuali, Inc. Pre-Release License
  Agreement with this file. If not, please write to license@kuali.co.
  #L%
  --%>

<%@ include file="/kr/WEB-INF/jsp/tldHeader.jsp"%>

<c:set var="docRoleAttributes" value="${DataDictionary.PersonDocumentRole.attributes}" />
<c:set var="delegationMemberAttributes" value="${DataDictionary.RoleDocumentDelegationMember.attributes}" />
<c:set var="roleDocumentDelegationMemberQualifier" value="${DataDictionary.RoleDocumentDelegationMemberQualifier.attributes}" />

<kul:subtab lookedUpCollectionName="delegations" width="${tableWidth}" subTabTitle="Delegations" noShowHideButton="false">      
    <table cellpadding="0" cellspacing="0" summary="">
        <c:if test="${!readOnly}">	          	
          	<tr>
          		<th>&nbsp;</th> 
          		<kim:cell inquiry="${inquiry}" isLabel="true" textAlign="center" attributeEntry="${delegationMemberAttributes.roleMemberId}" noColon="true" /> 
            	<kim:cell inquiry="${inquiry}" isLabel="true" textAlign="center" attributeEntry="${delegationMemberAttributes.activeFromDate}" noColon="true" /> 
            	<kim:cell inquiry="${inquiry}" isLabel="true" textAlign="center" attributeEntry="${delegationMemberAttributes.activeToDate}" noColon="true" /> 
            	<kim:cell inquiry="${inquiry}" isLabel="true" textAlign="center" attributeEntry="${delegationMemberAttributes.delegationTypeCode}" noColon="true" /> 
           	<c:if test="${!readOnly}">	
              	<kul:htmlAttributeHeaderCell literalLabel="Actions" scope="col"/>
          	</c:if>	
          	</tr>     
          	
            <tr>
				<th class="infoline">Add:</th>

                <td align="left" valign="middle" class="infoline">
                <div align="center">
                	${KualiForm.newDelegationMember.roleBo.namespaceCode}&nbsp;${KualiForm.newDelegationMember.roleBo.name}&nbsp;&nbsp;${KualiForm.newDelegationMember.roleMemberNamespaceCode}&nbsp;${KualiForm.newDelegationMember.roleMemberName}
                	<kul:lookup boClassName="org.kuali.rice.kim.impl.role.RoleBo" lookupParameters="newDelegationMemberRoleId:id,newDelegationMember.roleBo.kimTypeId:kimTypeId,newDelegationMember.roleBo.name:name,newDelegationMember.roleBo.namespaceCode:namespaceCode,newDelegationMember.roleBo.kimRoleType.name:kimRoleType.name,newDelegationMember.roleBo.kimRoleType.serviceName:kimRoleType.serviceName" fieldConversions="id:newDelegationMemberRoleId,kimTypeId:newDelegationMember.roleBo.kimTypeId,name:newDelegationMember.roleBo.name,namespaceCode:newDelegationMember.roleBo.namespaceCode,kimRoleType.name:newDelegationMember.roleBo.kimRoleType.name,kimRoleType.serviceName:newDelegationMember.roleBo.kimRoleType.serviceName" anchor="${tabKey}" />

					<html:hidden property="newDelegationMember.roleBo.name" />
					<html:hidden property="newDelegationMember.roleBo.id" />
					<html:hidden property="newDelegationMember.roleBo.namespaceCode" />
					<html:hidden property="newDelegationMember.roleBo.kimTypeId" />
					<html:hidden property="newDelegationMember.roleBo.kimRoleType.name" />
					<html:hidden property="newDelegationMember.roleBo.kimRoleType.serviceName" />
					<html:hidden property="newDelegationMember.roleMemberId" />
	            </div>
				</td>
                <td align="left" valign="middle">
                	<div align="center"> <kul:htmlControlAttribute property="newDelegationMember.activeFromDate"  attributeEntry="${delegationMemberAttributes.activeToDate}"  datePicker="true" readOnly="${readOnly}" />
				</div>
				</td>

				</td>
                <td align="left" valign="middle">
                	<div align="center"> <kul:htmlControlAttribute property="newDelegationMember.activeToDate"  attributeEntry="${delegationMemberAttributes.activeToDate}"  datePicker="true" readOnly="${readOnly}" />
				</div>
				</td>
                <td align="left" valign="middle" class="infoline">
	                <div align="center">
	                	<kul:htmlControlAttribute property="newDelegationMember.delegationTypeCode" 
	                	attributeEntry="${delegationMemberAttributes.delegationTypeCode}" disabled="${readOnly}" />
		            </div>
				</td>
                <td class="infoline">
					<div align="center">
						<kul:kualiButton property="methodToCall.addDelegationMember.anchor${tabKey}"
									src="${ConfigProperties.kr.externalizable.images.url}tinybutton-add1.gif"
									label="Add" title="Add Delegation Member" styleClass="tinybutton small outline"/>
					</div>
                </td>
       		</tr>         
     	</c:if>       
        <c:forEach var="delegationMember" items="${KualiForm.document.delegationMembers}" varStatus="status">
        	<%-- add header label for each 'role' to see if it is less confusion for user --%>
          	<tr>
          		<th>&nbsp;</th> 
          		<kim:cell inquiry="${inquiry}" isLabel="true" textAlign="center" attributeEntry="${delegationMemberAttributes.roleMemberId}" noColon="true" /> 
            	<kim:cell inquiry="${inquiry}" isLabel="true" textAlign="center" attributeEntry="${delegationMemberAttributes.activeFromDate}" noColon="true" /> 
            	<kim:cell inquiry="${inquiry}" isLabel="true" textAlign="center" attributeEntry="${delegationMemberAttributes.activeToDate}" noColon="true" />
              <kim:cell inquiry="${inquiry}" isLabel="true" textAlign="center" attributeEntry="${delegationMemberAttributes.delegationTypeCode}" noColon="true" />
              <c:if test="${!readOnly}">
	              	<kul:htmlAttributeHeaderCell literalLabel="Actions" scope="col"/>
	          	</c:if>	
          	</tr>             	
	        <tr>
                <%-- TODO : try 'valign' to see if it helps user--%>
				<th rowspan="1" class="infoline" valign="top">
					<c:out value="${status.index+1}" />
				</th>
                <td align="left" valign="middle">
                	<div align="center"> 
           	        <b>Role:</b> ${KualiForm.document.delegationMembers[status.index].roleBo.namespaceCode}&nbsp;${KualiForm.document.delegationMembers[status.index].roleBo.name}&nbsp;&nbsp;<b>Role Member:</b>&nbsp;${KualiForm.document.delegationMembers[status.index].roleMemberNamespaceCode}&nbsp;${KualiForm.document.delegationMembers[status.index].roleMemberName}
				</div>
				</td>
				<kim:cell inquiry="${inquiry}" valign="middle" cellClass="infoline" textAlign="center" property="document.delegationMembers[${status.index}].activeFromDate"  attributeEntry="${delegationMemberAttributes.activeFromDate}" readOnly="${readOnly}" datePicker="true" />
				<kim:cell inquiry="${inquiry}" valign="middle" cellClass="infoline" textAlign="center" property="document.delegationMembers[${status.index}].activeToDate"  attributeEntry="${delegationMemberAttributes.activeToDate}" readOnly="${readOnly}" datePicker="true" />
				<kim:cell inquiry="${inquiry}" valign="middle" cellClass="infoline" textAlign="center" property="document.delegationMembers[${status.index}].delegationTypeCode"  attributeEntry="${delegationMemberAttributes.delegationTypeCode}" disabled="${readOnly}" readOnly="false" />
			
           		<c:if test="${!readOnly}">						
					<td>
						<div align=center>&nbsp;
							<kul:kualiButton property="methodToCall.deleteDelegationMember.line${status.index}.anchor${currentTabIndex}"
											 src="${ConfigProperties.kr.externalizable.images.url}tinybutton-delete1.gif"
											 disabledSrc="${ConfigProperties.kr.externalizable.images.url}tinybutton-delete2.gif"
											 label="Delete" title="Delete Delegation Member" styleClass="tinybutton small outline"
											 disabled="${role.edit or readOnlyEntity}" />
						</div>
	                </td>
	           </c:if>     
	      	</tr>
	        <c:if test="${fn:length(delegationMember.attributesHelper.definitions) != 0}">	
            	<tr>
	              <td colspan="7" style="padding:0px;">
	              	<kim:personDelegationMemberQualifier delegationMemberIdx="${status.index}" />
		          </td>
		        </tr>
			</c:if>	 
       	</c:forEach>                   
    </table>
</kul:subtab>
