<%--
  #%L
  %%
  Copyright (C) 2005 - 2026 Kuali, Inc. - All Rights Reserved
  %%
  You may use and modify this code under the terms of the Kuali, Inc.
  Pre-Release License Agreement. You may not distribute it.
  
  You should have received a copy of the Kuali, Inc. Pre-Release License
  Agreement with this file. If not, please write to license@kuali.co.
  #L%
  --%>
<%@ taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core" %>

<%@ include file="/WEB-INF/jsp/kraTldHeader.jsp"%>

<c:set var="subAwardTemplateInfoAttributes" value="${DataDictionary.SubAwardTemplateInfo.attributes}" />
<c:set var="attachments" value="${KualiForm.document.subAwardList[0].subAwardTemplateInfo}"/>
<kul:tab tabTitle="Compliance" defaultOpen="true" tabErrorKey="document.subAwardList[0].subAwardTemplateInfo[0].fcio*,
                                                               document.subAwardList[0].subAwardTemplateInfo[0].fcioSubrecPolicyCd*,
                                                               document.subAwardList[0].subAwardTemplateInfo[0].animalFlag*,
                                                               document.subAwardList[0].subAwardTemplateInfo[0].animalPteSendCd*,
                                                               document.subAwardList[0].subAwardTemplateInfo[0].animalPteNrCd*,
                                                               document.subAwardList[0].subAwardTemplateInfo[0].humanFlag*,
                                                               document.subAwardList[0].subAwardTemplateInfo[0].humanPteSendCd*,
                                                               document.subAwardList[0].subAwardTemplateInfo[0].humanPteNrCd*,
                                                               document.subAwardList[0].subAwardTemplateInfo[0].humanDataExchangeAgreeCd*,
                                                               document.subAwardList[0].subAwardTemplateInfo[0].humanDataExchangeTermsCd*,
                                                               document.subAwardList[0].subAwardTemplateInfo[0].dataSharingAttachment*,
                                                               document.subAwardList[0].subAwardTemplateInfo[0].dataSharingCd*">
	<div class="tab-container" align="center">
   		<h3>
   			<span class="subhead-left">Compliance</span>
   			<span class="subhead-right"><kul:help businessObjectClassName="org.kuali.kra.subaward.bo.SubAwardTemplateInfo"  altText="help"/></span>
        </h3>
        <table id="compliance-table" class="tab" cellpadding="4" cellspacing="0" summary="">
            <tr>
                <th><div style="text-align: right;"><kul:htmlAttributeLabel attributeEntry="${subAwardTemplateInfoAttributes.fcio}" labelFor="document.subAwardList[0].subAwardTemplateInfo[0].fcio"/></div></th>
                <td>
                    <kul:htmlControlAttribute property="document.subAwardList[0].subAwardTemplateInfo[0].fcio" readOnly="${readOnly}" attributeEntry="${subAwardTemplateInfoAttributes.fcio}" />
                </td>
                <th><div style="text-align: right;"><kul:htmlAttributeLabel attributeEntry="${subAwardTemplateInfoAttributes.fcioSubrecPolicyCd}" labelFor="document.subAwardList[0].subAwardTemplateInfo[0].fcioSubrecPolicyCd"/></div></th>
                <td>
                    <kul:htmlControlAttribute property="document.subAwardList[0].subAwardTemplateInfo[0].fcioSubrecPolicyCd" readOnly="${readOnly}" attributeEntry="${subAwardTemplateInfoAttributes.fcioSubrecPolicyCd}" />
                </td>
            </tr>

            <tr>
                <th>
                    <div style="text-align: right;"><kul:htmlAttributeLabel attributeEntry="${subAwardTemplateInfoAttributes.dataSharingCd}" labelFor="document.subAwardList[0].subAwardTemplateInfo[0].dataSharingCd"/></div>
                </th>
                <td>
                    <kul:htmlControlAttribute property="document.subAwardList[0].subAwardTemplateInfo[0].dataSharingCd" readOnly="${readOnly}"
                                              attributeEntry="${subAwardTemplateInfoAttributes.dataSharingCd}"/>
                </td>
                <th><div style="text-align: right;">&nbsp;</div></th>
                <td>
                    <div>&nbsp;</div>
                </td>
            </tr>

        </table>
        <kul:subtab width="100%" subTabTitle="Animals" noShowHideButton="true">
            <table id="animal-compliance-table" class="tab" cellpadding="4" cellspacing="0" summary="">
                <tr>
                    <th><div style="text-align: right;"><kul:htmlAttributeLabel attributeEntry="${subAwardTemplateInfoAttributes.animalFlag}" labelFor="document.subAwardList[0].subAwardTemplateInfo[0].animalFlag"/></div></th>
                    <td>
                        <kul:htmlControlAttribute property="document.subAwardList[0].subAwardTemplateInfo[0].animalFlag" readOnly="${readOnly}" attributeEntry="${subAwardTemplateInfoAttributes.animalFlag}" />
                    </td>
                    <th><div style="text-align: right;">&nbsp;</div></th>
                    <td>
                        <div>&nbsp;</div>
                    </td>
                </tr>
                <tr>
                    <th><div style="text-align: right;"><kul:htmlAttributeLabel attributeEntry="${subAwardTemplateInfoAttributes.animalPteSendCd}" labelFor="document.subAwardList[0].subAwardTemplateInfo[0].animalPteSendCd"/></div></th>
                    <td>
                        <kul:htmlControlAttribute property="document.subAwardList[0].subAwardTemplateInfo[0].animalPteSendCd" readOnly="${readOnly}" attributeEntry="${subAwardTemplateInfoAttributes.animalPteSendCd}" />
                    </td>
                    <th><div style="text-align: right;"><kul:htmlAttributeLabel attributeEntry="${subAwardTemplateInfoAttributes.animalPteNrCd}" labelFor="document.subAwardList[0].subAwardTemplateInfo[0].animalPteNrCd"/></div></th>
                    <td>
                        <kul:htmlControlAttribute property="document.subAwardList[0].subAwardTemplateInfo[0].animalPteNrCd" readOnly="${readOnly}" attributeEntry="${subAwardTemplateInfoAttributes.animalPteNrCd}" />
                    </td>
                </tr>
            </table>
        </kul:subtab>
        <kul:subtab width="100%" subTabTitle="Humans" noShowHideButton="true">
            <table id="human-compliance-table" class="tab" cellpadding="4" cellspacing="0" summary="">
                <tr>
                    <th>
                        <div style="text-align: right;"><kul:htmlAttributeLabel attributeEntry="${subAwardTemplateInfoAttributes.humanSubjects}" labelFor="document.subAwardList[0].subAwardTemplateInfo[0].humanSubjects"/></div>
                    </th>
                    <td>
                        <kul:htmlControlAttribute property="document.subAwardList[0].subAwardTemplateInfo[0].humanSubjects" readOnly="${readOnly}"
                                                  attributeEntry="${subAwardTemplateInfoAttributes.humanSubjects}"/>
                    </td>
                    <th>
                        <div class="hsExempt" style="text-align: right; display: ${attachments[0].humanSubjects == 'E' ? 'block' : 'none'};">
                            <kul:htmlAttributeLabel attributeEntry="${subAwardTemplateInfoAttributes.humanExemptDocumentation}" labelFor="document.subAwardList[0].subAwardTemplateInfo[0].humanExemptDocumentation"/>
                        </div>
                        <div class="hsTrials" style="text-align: right; display: ${attachments[0].humanSubjects == 'Y' ? 'block' : 'none'};">
                            <kul:htmlAttributeLabel attributeEntry="${subAwardTemplateInfoAttributes.includesClinicalTrials}" labelFor="document.subAwardList[0].subAwardTemplateInfo[0].includesClinicalTrials"/>
                        </div>
                        <div class="hsReason" style="text-align: right; display: ${attachments[0].humanSubjects == 'N' ? 'block' : 'none'};">
                            <kul:htmlAttributeLabel attributeEntry="${subAwardTemplateInfoAttributes.humanPteNrCd}" labelFor="document.subAwardList[0].subAwardTemplateInfo[0].humanPteNrCd"/>
                        </div>
                    </th>
                    <td>
                        <div class="hsExempt" style="display: ${attachments[0].humanSubjects == 'E' ? 'block' : 'none'};">
                            <kul:htmlControlAttribute property="document.subAwardList[0].subAwardTemplateInfo[0].humanExemptDocumentation"
                                                      readOnly="${readOnly}"
                                                      attributeEntry="${subAwardTemplateInfoAttributes.humanExemptDocumentation}"/>
                        </div>
                        <div class="hsTrials" style="display: ${attachments[0].humanSubjects == 'Y' ? 'block' : 'none'};">
                            <kul:htmlControlAttribute property="document.subAwardList[0].subAwardTemplateInfo[0].includesClinicalTrials"
                                                      readOnly="${readOnly}" attributeEntry="${subAwardTemplateInfoAttributes.includesClinicalTrials}"/>
                        </div>
                        <div class="hsReason" style="display: ${attachments[0].humanSubjects == 'N' ? 'block' : 'none'};">
                            <kul:htmlControlAttribute property="document.subAwardList[0].subAwardTemplateInfo[0].humanPteNrCd"
                                                      readOnly="${readOnly}" attributeEntry="${subAwardTemplateInfoAttributes.humanPteNrCd}"/>
                        </div>
                    </td>
                </tr>
                <tr>
                    <th><div style="text-align: right;"><kul:htmlAttributeLabel attributeEntry="${subAwardTemplateInfoAttributes.humanPteSendCd}" labelFor="document.subAwardList[0].subAwardTemplateInfo[0].humanPteSendCd"/></div></th>
                    <td>
                        <kul:htmlControlAttribute property="document.subAwardList[0].subAwardTemplateInfo[0].humanPteSendCd" readOnly="${readOnly}" attributeEntry="${subAwardTemplateInfoAttributes.humanPteSendCd}" />
                    </td>
                    <th><div style="text-align: right;"><kul:htmlAttributeLabel attributeEntry="${subAwardTemplateInfoAttributes.humanDataExchangeTermsCd}" labelFor="document.subAwardList[0].subAwardTemplateInfo[0].humanDataExchangeTermsCd"/></div></th>
                    <td>
                        <kul:htmlControlAttribute property="document.subAwardList[0].subAwardTemplateInfo[0].humanDataExchangeTermsCd" readOnly="${readOnly}" attributeEntry="${subAwardTemplateInfoAttributes.humanDataExchangeTermsCd}" />
                    </td>
                </tr>
                <tr>
                    <th><div style="text-align: right;"><kul:htmlAttributeLabel attributeEntry="${subAwardTemplateInfoAttributes.humanDataExchangeAgreeCd}" labelFor="document.subAwardList[0].subAwardTemplateInfo[0].humanDataExchangeAgreeCd"/></div></th>
                    <td>
                        <kul:htmlControlAttribute property="document.subAwardList[0].subAwardTemplateInfo[0].humanDataExchangeAgreeCd" readOnly="${readOnly}" attributeEntry="${subAwardTemplateInfoAttributes.humanDataExchangeAgreeCd}" />
                    </td>
                    <th>
                        <div style="text-align: right;">&nbsp;</div>
                    </th>
                    <td>
                        <div>&nbsp;</div>
                    </td>
                </tr>
            </table>
        </kul:subtab>
    </div>
</kul:tab>
	
<script type="application/javascript">
    !function($) {
        $(document).ready(function () {
            $("input[name$='document.subAwardList[0].subAwardTemplateInfo[0].humanSubjects']").click(function () {
                const selected = $(this).val();

                if (selected !== 'Y') {
                    $('div.hsTrials').hide();
                } else {
                    $('div.hsTrials').show();
                }
                if (selected !== 'E') {
                    $('div.hsExempt').hide();
                } else {
                    $('div.hsExempt').show();
                }
                if (selected !== 'N') {
                    $('div.hsReason').hide();
                } else {
                    $('div.hsReason').show();
                }
            });
        });
    }(window.jQuery);
</script>
