<#--
 #%L
 %%
 Copyright (C) 2005 - 2025 Kuali, Inc. - All Rights Reserved
 %%
 You may use and modify this code under the terms of the Kuali, Inc.
 Pre-Release License Agreement. You may not distribute it.
 
 You should have received a copy of the Kuali, Inc. Pre-Release License
 Agreement with this file. If not, please write to license@kuali.co.
 #L%
-->

<#--
Standard HTML Radio Input

-->
<#macro uif_radiobuttons control field>

    <#local attributes='class="${control.styleClassesAsString!}" ${control.simpleDataAttributes!} '/>

    <#if control.tabIndex < 0>
        <#local attributes='${attributes} tabindex="${control.tabIndex!}"' />
    </#if>

    <#if control.disabled>
        <#local attributes='${attributes} disabled="disabled"'/>
    </#if>

    <#if control.style?has_content>
        <#local attributes='${attributes} style="${control.style}"'/>
    </#if>

    <fieldset id="${field.id}_fieldset" aria-labelledby="${field.id}_label" class="${control.fieldsetClassesAsString}"
              data-type="RadioSet">
        <legend style="display: none">${field.label!}</legend>
        <@spring.bind path="KualiForm.${field.bindingInfo.bindingPath}"/>
        <#list control.richOptions as option>
            <#assign id="${control.id}_${option_index}">
            <#-- Determine if the option has a visible label text; if not, we will add an accessible name fallback -->
            <#assign _optVal = (option.value!"")?string />
            <#assign _labelText = _optVal?trim />
            <#assign _needsFallback = (!option.message.richMessage) && (_labelText?length == 0) />
            <span class="uif-tooltip">
                <input type="radio" id="${id}" name="${spring.status.expression}" value="${option.key?html}"<#if spring.stringStatusValue == option.key> checked="checked"</#if><#if option.disabled> disabled="disabled"</#if> ${attributes}<#if _needsFallback> aria-label="Select name" title="Select name"</#if><@spring.closeTag/>
                <#if option.message.richMessage>
                    <label for="${id}" onclick="handleRadioLabelClick('${id}',event); return false;"><@krad.template component=option.message/></label>
                <#else>
                    <label for="${id}"><#if _needsFallback><span class="sr-only">Select name</span><#else>${option.value!}</#if></label>
                </#if>
            </span>
            <#if option_has_next>
                ${control.delimiter!}
            </#if>
        </#list>
    </fieldset>

    <@krad.disable control=field.control type="radioGroup"/>

</#macro>
