<#--
 #%L
 %%
 Copyright (C) 2005 - 2025 Kuali, Inc. - All Rights Reserved
 %%
 You may use and modify this code under the terms of the Kuali, Inc.
 Pre-Release License Agreement. You may not distribute it.
 
 You should have received a copy of the Kuali, Inc. Pre-Release License
 Agreement with this file. If not, please write to license@kuali.co.
 #L%
-->

<#--
    Renders label and div, then invokes rendering of the KimLink component
 -->
<#macro uif_kimLinkField field>
  <@krad.div component=field>
    <#-- check to see if label exists and if it has been rendered in another field (grid layout)-->
    <#local renderLabel=field.label?has_content && !field.labelRendered/>
    <#-- render field label top -->
    <#if renderLabel>
      <@krad.template component=field.fieldLabel/>
    </#if>

    <#if field.disableLink>
      <#if field.link.iconClass??>
        <#if field.link.linkIconPlacement == 'ICON_ONLY'>
          <span class="${field.link.iconClass}"></span>
        <#else>
          <span>${field.link.linkText!}</span>
        </#if>
      <#else>
        <span>${field.link.linkText!}</span>
      </#if>
    <#else>
      <@krad.template component=field.link/>
    </#if>

  </@krad.div>
</#macro>
