<%--
  #%L
  %%
  Copyright (C) 2005 - 2026 Kuali, Inc. - All Rights Reserved
  %%
  You may use and modify this code under the terms of the Kuali, Inc.
  Pre-Release License Agreement. You may not distribute it.
  You should have received a copy of the Kuali, Inc. Pre-Release License
  Agreement with this file. If not, please write to license@kuali.co.
  #L%
  --%>
<%@ include file="/WEB-INF/jsp/kraTldHeader.jsp"%>
<%@ include file="/WEB-INF/jsp/kraExconTldHeader.jsp"%>

<c:set var="exconIntlShipmentAttributes" value="${DataDictionary.ExconIntlShipment.attributes}" />

<c:set var="readOnly" value="${not KualiForm.editingMode['fullEntry']}" scope="request" />
<c:set var="action" value="exconIntlShipment" />

<kul:tabTop tabTitle="" defaultOpen="true" tabErrorKey="document.exconProjectList[0].*" tabAuditKey="document.exconProjectList[0].*">

    <div class="tab-container">

        <table style="border-bottom-width:0px; border-bottom-style:none; border-bottom-color:transparent" summary="">
            <tr><td colspan="5">&nbsp;</td></tr>
            <tr>
                <th colspan="5" style="font-size: large"><div align="middle">International Shipping Checklist for Colorado State University</div></th>
            </tr>
            <tr><td colspan="5">&nbsp;</td></tr>
            <tr>
                <th colspan="5">
                    To protect you, the members of your research team or department, and the university, please make
                    all international shipments through Central Receiving, and answer the questions below.
                </th>
            </tr>
            <tr><td colspan="5"><hr></td></tr>

            <tr>
                <td width="9%">&nbsp;</td>
                <td width="1%">&nbsp;</td>
                <td width="10%"><b>Shipment ID:</b></td>
                <td width="10%">
                    <c:choose>
                        <c:when test="${empty KualiForm.document.exconIntlShipmentList[0].shipmentId}">
                            <span style='color: red;'>Assigned after submission</span>
                        </c:when>
                        <c:otherwise>
                            <c:out value="${KualiForm.document.exconIntlShipmentList[0].shipmentId}" />
                        </c:otherwise>
                    </c:choose>
                </td>
                <td width="70%">&nbsp;</td>
            </tr>

            <tr>
                <td colspan="2"></td>
                <td id="applicantId" class="grid" class="infoline">
                    <b>* <kul:htmlAttributeLabel attributeEntry="${exconIntlShipmentAttributes.applicantId}" labelFor="document.exconIntlShipmentList[0].applicantId"/></b>
                </td><td>
                <kra-excon:dynamicLookup property="document.exconIntlShipmentList[0].applicantId" attributeEntry="${exconIntlShipmentAttributes.applicantId}"
                                         readOnlyAlternateDisplay="${KualiForm.document.exconIntlShipmentList[0].applicantName}" placeHolder="Type: Last, First"
                                         searchMethod="findPersons"
                                         readOnly="${readOnly || !KualiForm.exconIntlShipmentBean.exconIntlShipment.isAdmin}"/>

            </td>
            </tr>

            <tr>
                <td colspan="2"></td>
                <td id="supervisorId" class="grid" class="infoline">
                    <b>* <kul:htmlAttributeLabel attributeEntry="${exconIntlShipmentAttributes.supervisorId}" labelFor="document.exconIntlShipmentList[0].supervisorId" /></b>
                </td><td>
                <kra-excon:dynamicLookup property="document.exconIntlShipmentList[0].supervisorId" attributeEntry="${exconIntlShipmentAttributes.supervisorId}"
                                         readOnlyAlternateDisplay="${KualiForm.document.exconIntlShipmentList[0].supervisorName}" placeHolder="Type: Last, First"
                                         readOnly="${readOnly}" searchMethod="findPersons"/>
            </td>
                <td>
                    To find your supervisor, type the first three characters of your supervisor's last name and wait for the list to populate.  Only two letters?  Type the first two followed by a comma and a space.
                </td>
            </tr>

            <tr>
                <td colspan="2">&nbsp;</td>
                <td class="grid" class="infoline">
                    <b>* <kul:htmlAttributeLabel attributeEntry="${exconIntlShipmentAttributes.unitNumber}" labelFor="document.exconIntlShipmentList[0].unitNumber"/></b>
                </td><td>
                <kra-excon:dynamicLookup property="document.exconIntlShipmentList[0].unitNumber" attributeEntry="${exconIntlShipmentAttributes.unitNumber}"
                                         readOnlyAlternateDisplay="${KualiForm.document.exconIntlShipmentList[0].unitName}" placeHolder="Type: Unit Name"
                                         readOnly="${readOnly}" searchMethod="findUnits"/>
            </td>
            </tr>

            <tr><td colspan="5"><hr></td></tr>
            <tr style="vertical-align: top; alignment: left">
                <td style="font-weight: bold; vertical-align: middle">
                    <kul:htmlControlAttribute property="document.exconIntlShipmentList[0].restrictedExport" attributeEntry="${exconIntlShipmentAttributes.restrictedExport}" />
                </td>
                <td><b><label for="document.exconIntlShipmentList[0].restrictedExport">1.&nbsp;</label></b></td>
                <td colspan="3">
                    Are you sending any items, software, or technical data outside the U.S. that is restricted for export?
                    CSU may need to secure an export license before making the shipment.  Please provide a detailed description of the actual item(s) you are sending.
                </td>
            </tr>
            <tr style="vertical-align: top; alignment: left">
                <td colspan="2">
                    &nbsp;
                </td>
                <td>
                    <b><kul:htmlAttributeLabel attributeEntry="${exconIntlShipmentAttributes.shipmentDescription}" labelFor="document.exconIntlShipmentList[0].shipmentDescription"/></b>
                </td><td>
                <kul:htmlControlAttribute property="document.exconIntlShipmentList[0].shipmentDescription" attributeEntry="${exconIntlShipmentAttributes.shipmentDescription}"/>
            </td>
            </tr>
            <tr><td colspan="5">&nbsp;</td></tr>

            <tr style="vertical-align: top; alignment: left">
                <td style="font-weight: bold; vertical-align: middle">
                    <kul:htmlControlAttribute property="document.exconIntlShipmentList[0].restrictedCountry" attributeEntry="${exconIntlShipmentAttributes.restrictedCountry}" />
                </td>
                <td><b><label for="document.exconIntlShipmentList[0].restrictedCountry">2.&nbsp;</label></b></td>
                <td colspan="3">
                    Are you sending something to any of the countries on the
                    <a href="https://www.research.colostate.edu/sgr/export-control/" target="_blank">Export Control Country List</a>?
                </td>
            </tr>
            <tr style="vertical-align: top; alignment: left">
                <td colspan="2">
                    &nbsp;
                </td>
                <td>
                    <b><kul:htmlAttributeLabel attributeEntry="${exconIntlShipmentAttributes.countryCode}" labelFor="document.exconIntlShipmentList[0].countryCode"/></b>
                </td><td>
                <kul:htmlControlAttribute property="document.exconIntlShipmentList[0].countryCode" attributeEntry="${exconIntlShipmentAttributes.countryCode}"
                                          styleClass="selectpicker\" data-size=\"10\" data-live-search=\"true\" data-live-search-placeholder=\"Type: Country Name"/>
                <c:if test="${readOnly && not empty KualiForm.exconIntlShipmentBean.exconIntlShipment.sanctionListCode}">
                    : <span style="color: red; font-weight: bold">${KualiForm.exconIntlShipmentBean.exconIntlShipment.sanctionListName}</span>
                </c:if>
            </td>
            </tr>
            <tr><td colspan="5">&nbsp;</td></tr>

            <tr style="vertical-align: top; alignment: left">
                <td style="font-weight: bold; vertical-align: middle">
                    <kul:htmlControlAttribute property="document.exconIntlShipmentList[0].restrictedParty" attributeEntry="${exconIntlShipmentAttributes.restrictedParty}" />
                </td>
                <td><b><label for="document.exconIntlShipmentList[0].restrictedParty">3.&nbsp;</label></b></td>
                <td colspan="3">
                    Is the recipient of your shipment listed as a denied party?  Federal requirements restrict CSU from doing business
                    with certain institutions, organizations, and individuals.  Please enter the name of the institution and/or individual who will receive the shipment.
                    Upon submission of this checklist, the receiving party will automatically be screened.  Results will be emailed to you, your supervisor and Central Receiving.
                </td>
            </tr>
            <tr style="vertical-align: top; alignment: left">
                <td colspan="2">
                    &nbsp;
                </td>
                <td>
                    <b><kul:htmlAttributeLabel attributeEntry="${exconIntlShipmentAttributes.receivingParty}" labelFor="document.exconIntlShipmentList[0].receivingParty"/></b>
                </td><td>
                <kul:htmlControlAttribute property="document.exconIntlShipmentList[0].receivingParty" attributeEntry="${exconIntlShipmentAttributes.receivingParty}"/>
                <c:if test="${readOnly && KualiForm.exconIntlShipmentBean.numMatches > -1}">
                    : <span style="color: red; font-weight: bold"> ${KualiForm.exconIntlShipmentBean.numMatches} Possible Matches &nbsp; </span>
                    <c:if test="${KualiForm.exconIntlShipmentBean.numMatches > 0 && KualiForm.exconIntlShipmentBean.exconIntlShipment.isAdmin}">
                        <html:image property="methodToCall.refresh"
                                    src='${ConfigProperties.kra.externalizable.images.url}tinybutton-view.gif' styleClass="tinybutton"
                                    alt="View Results"
                                    onclick="openNewWindow('exconIntlShipment','viewRPSResult','0','${KualiForm.formKey}','${KualiForm.document.sessionDocument}');return false;"/>

                    </c:if>
                </c:if>
            </td>
            </tr>
            <tr>
                <td colspan="5">&nbsp;</td></tr>
            <tr>
                <th colspan="5">
                    More information available at <a href="https://www.research.colostate.edu/sgr/export-control/" target="_blank">https://www.research.colostate.edu/sgr/export-control/</a><p>
                    Questions? After submission, ask the Export Control Administrator at
                    <a href="mailto:VPR_Export_Control@colostate.edu">VPR_Export_Control@colostate.edu</a>.
                </th>
            </tr>
            <tr><td colspan="5">&nbsp;</td></tr>
            <tr style="vertical-align: top">
                <td colspan="5" style="font-weight: bold; vertical-align: top">
                    <table><tr style="vertical-align: top">
                        <td>
                            <kul:htmlControlAttribute property="document.exconIntlShipmentList[0].certificationInd" attributeEntry="${exconIntlShipmentAttributes.certificationInd}" />
                            &nbsp;I certify that the information above is accurate to the best of my knowledge.
                        </td>
                    </tr></table>
                </td>
            </tr>


        </table>
    </div>
    <hr>

</kul:tabTop>
