<%--
  #%L
  %%
  Copyright (C) 2005 - 2026 Kuali, Inc. - All Rights Reserved
  %%
  You may use and modify this code under the terms of the Kuali, Inc.
  Pre-Release License Agreement. You may not distribute it.
  
  You should have received a copy of the Kuali, Inc. Pre-Release License
  Agreement with this file. If not, please write to license@kuali.co.
  #L%
  --%>

<%@ include file="/WEB-INF/jsp/kraTldHeader.jsp"%>
<%@ attribute name="businessObjectClassName" required="true"
              description="The specific per-module business class to use for the help pages" %>
<%@ attribute name="attributes" required="true" type="java.util.Map"
              description="The Data Dictionary reference to the Special Review attributes" %>
<%@ attribute name="exemptionAttributes" required="true" type="java.util.Map"
              description="The Data Dictionary reference to the Special Review Exemption attributes" %>
<%@ attribute name="collectionReference" required="true" type="java.util.List"
              description="The object reference to the collection that holds all the current Special Reviews" %>
<%@ attribute name="collectionProperty" required="true"
              description="The property name of the collection that holds all the current Special Reviews" %>
<%@ attribute name="action" required="true"
              description="The name of the action class" %>
<c:set var="canModify" value="${KualiForm.specialReviewHelper.canModifySpecialReview}"/>
<c:set var="exconEnabled" value="${KualiForm.specialReviewHelper.isExportControlEnabled}" />
<c:set var="commentDisplayLength" value="<%=org.kuali.kra.infrastructure.Constants.SPECIAL_REVIEW_COMMENT_LENGTH%>" />
<c:set var="canCreateExconProject" value="${KualiForm.specialReviewHelper.canCreateExconProject}" />
<c:set var="buttonStyle" value="display:none"/>
<c:set var="exconProjectTypeCode" value="RESBOOT-1000" />
<c:set var="protocolsFundedByAttributes" value="${DataDictionary.ProtocolsFundedByDto.attributes}" />

<script>
var SpecialReviewGlobals = {};
SpecialReviewGlobals.approvalTypeSelector = 'select[name*="approvalTypeCode"]';
SpecialReviewGlobals.specialReviewTypeSelector = 'select[name*="specialReviewTypeCode"]';
SpecialReviewGlobals.disabledApprovalTypeSelector = 'select[name*="disabledApprovalTypeCode"]';
SpecialReviewGlobals.notYetAppliedApprovalTypeCode = '3';
SpecialReviewGlobals.exconProjectTypeCode = '${exconProjectTypeCode}';
SpecialReviewGlobals.origSearchIcon;
SpecialReviewGlobals.disabledSearchIcon = "${ConfigProperties.kra.externalizable.images.url}/searchicon1.gif";
SpecialReviewGlobals.exconEnabled = "${exconEnabled}";

SpecialReviewGlobals.processNotYetAppliedChange = function(control) {
	var row = this.getRow(control);
	var reviewTypes = jQuery(row).find(this.specialReviewTypeSelector);
	var typeCode = reviewTypes.val();
	var approvalTypes = jQuery(row).find(this.approvalTypeSelector);
	var protocolNumber = jQuery(row).find('input[type="text"][name*="protocolNumber"]');
	if (typeCode === this.exconProjectTypeCode && this.exconEnabled) {
		if (approvalTypes.val() === this.notYetAppliedApprovalTypeCode) {
			jQuery(protocolNumber).prop('readonly', true);
			jQuery(protocolNumber).siblings().find('input').prop('disabled', true);
			jQuery(protocolNumber).siblings().find('input').attr('src', this.disabledSearchIcon);
		} else {
			jQuery(protocolNumber).prop('readonly', false);
			jQuery(protocolNumber).siblings().find('input').prop('disabled', false);
			jQuery(protocolNumber).siblings().find('input').attr('src', this.origSearchIcon);
		}
		if (jQuery(protocolNumber).val().length > 0) {
			approvalTypes.val('');
			approvalTypes.prop('disabled', true);
			if (approvalTypes.siblings('span').html().match(/\w/).length > 0) {
				approvalTypes.hide();
				approvalTypes.siblings('span').show();
			}
		} else {
			approvalTypes.show();
			approvalTypes.prop('disabled', false);
			approvalTypes.siblings('span').hide();
		}
	} else {
		approvalTypes.siblings('span').hide();
		approvalTypes.show();
		approvalTypes.prop('disabled', false);
		jQuery(protocolNumber).prop('readonly', false);
		jQuery(protocolNumber).siblings().find('input').prop('disabled', false);
		jQuery(protocolNumber).siblings().find('input').attr('src', this.origSearchIcon);
	}
}
SpecialReviewGlobals.getRow = function(control) {
	var parent = jQuery(control).parentsUntil('tr');
	return jQuery(parent).parent();
}
SpecialReviewGlobals.removeApprovalOptions = function(approvalType, optionValuesToKeep) {
	jQuery(approvalType).children().each(function() {
		if (jQuery.inArray(jQuery(this).val(), optionValuesToKeep) === -1) {
			jQuery(this).remove();
		}
	});
}
SpecialReviewGlobals.addDisabledOptionsBack = function(approvalType) {
	jQuery(approvalType).html('');
	jQuery(this.disabledApprovalTypeSelector).children().clone().each(function() {
		jQuery(approvalType).append(this);
	});
}

SpecialReviewGlobals.showHideSpecialReviewProtocolLink = function(specialReviewControl, canCreateExconProject) {
	var row = this.getRow(specialReviewControl);
	var typeCode = jQuery(specialReviewControl).val();
	if (typeCode === this.exconProjectTypeCode && canCreateExconProject) {
		jQuery(row).find('input[name*="createProtocol"]').show();
	} else {
		jQuery(row).find('input[name*="createProtocol"]').hide();
	}
	var selectedApprovalType = jQuery(row).find(this.approvalTypeSelector).val();
	if (typeCode === this.exconProjectTypeCode && this.exconEnabled) {
		jQuery(row).find('span.exconLookupLink').show();
		jQuery(row).find('.dynamicReadDiv').show();
		jQuery(row).find('.dynamicEditDiv').hide();
		this.removeApprovalOptions(jQuery(row).find(this.approvalTypeSelector), new Array("", this.notYetAppliedApprovalTypeCode));
	} else {
		jQuery(row).find('span.exconLookupLink').hide();
		jQuery(row).find('.dynamicReadDiv').hide();
		jQuery(row).find('.dynamicEditDiv').show();
		this.addDisabledOptionsBack(jQuery(row).find(this.approvalTypeSelector));
	}
	jQuery(row).find(this.approvalTypeSelector).val(selectedApprovalType);
	this.processNotYetAppliedChange(jQuery(row).find(this.approvalTypeSelector));
}

jQuery(document).ready(function() {
	SpecialReviewGlobals.origSearchIcon = jQuery('input[type="image"][src*="searchicon.gif"]').attr('src');
	jQuery('input[type="text"][name*="protocolNumber"]').change(function() {SpecialReviewGlobals.processNotYetAppliedChange(this);});
	jQuery(SpecialReviewGlobals.approvalTypeSelector).change(function() {SpecialReviewGlobals.processNotYetAppliedChange(this);});
	jQuery(SpecialReviewGlobals.approvalTypeSelector).first().children().clone().each(function() {jQuery(SpecialReviewGlobals.disabledApprovalTypeSelector).append(this);});
	jQuery('select[name*="specialReviewTypeCode"]').each(function() {
		SpecialReviewGlobals.showHideSpecialReviewProtocolLink(this, '${canCreateExconProject}');
	});
	jQuery('input[type="text"][name*="protocolNumber"]').each(function() {SpecialReviewGlobals.processNotYetAppliedChange(this);});
});
</script>

<kul:tab tabTitle="Compliance" defaultOpen="true" alwaysOpen="true" transparentBackground="true"
 	tabErrorKey="specialReviewHelper.newSpecialReview*,${collectionProperty}*"
	auditCluster="specialReviewKrmsAuditErrors,specialReviewKrmsAuditWarnings"
	tabAuditKey="specialReviewHelper.newSpecialReview,${collectionProperty}*"
	useRiceAuditMode="true">
	
    <%-- used to store the original list of approval type codes --%>
    <select name="disabledApprovalTypeCode" style="display:none;"></select>
	
    <div class="tab-container" align="center">
    	<h3>
    		<span class="subhead-left">Compliance</span>
    		<span class="subhead-right"><kul:help businessObjectClassName="${businessObjectClassName}" altText="help"/></span>
        </h3>
        
        <c:if test="${KualiForm.protocolsLinkingEnabled and not empty KualiForm.protocolsFundedBy}">
        <h4 style="text-align:left; margin: 20px 0; padding: 2px;">Linked Protocols</h4>
        <table id="protocolsFundedById" cellpadding="0" cellspacing="0" summary="">
        	<thead>
        		<th><div align="center"><kul:htmlAttributeLabel attributeEntry="${protocolsFundedByAttributes.protocolType}" noColon="true" /></div></th>
          		<th><div align="center"><kul:htmlAttributeLabel attributeEntry="${protocolsFundedByAttributes.protocolNumber}" noColon="true" /></div></th>
          		<th><div align="center"><kul:htmlAttributeLabel attributeEntry="${protocolsFundedByAttributes.title}" noColon="true" /></div></th>
          		<th><div align="center"><kul:htmlAttributeLabel attributeEntry="${protocolsFundedByAttributes.protocolState}" noColon="true" /></div></th>
				<th><div align="center"><kul:htmlAttributeLabel attributeEntry="${protocolsFundedByAttributes.reviewType}" noColon="true" /></div></th>
          		<th><div align="center"><kul:htmlAttributeLabel attributeEntry="${protocolsFundedByAttributes.approvalDate}" noColon="true" /></div></th>
          		<th><div align="center"><kul:htmlAttributeLabel attributeEntry="${protocolsFundedByAttributes.expirationDate}" noColon="true" /></div></th>
          	</thead>
          	<tbody>
          		<c:forEach var="protocolDto" items="${KualiForm.protocolsFundedBy}" varStatus="status">
					<tr>
                        <td align="left" valign="middle" class="infoline"><div align="center">
                            <kul:htmlControlAttribute property="protocolsFundedBy[${status.index}].protocolType"
                                attributeEntry="${protocolsFundedByAttributes.protocolType}"
                                readOnly="true"/>
                        </div></td>
                        <td align="left" valign="middle" class="infoline"><div align="center">
                            <a href="${protocolDto.url}" target="_blank" rel="noopener">${protocolDto.protocolNumber}</a>
                        </div></td>
                        <td align="left" valign="middle" class="infoline"><div align="center">
                            <kul:htmlControlAttribute property="protocolsFundedBy[${status.index}].title"
                                attributeEntry="${protocolsFundedByAttributes.title}"
                                readOnly="true"/>
                        </div></td>
                        <td align="left" valign="middle" class="infoline"><div align="center">
                            <kul:htmlControlAttribute property="protocolsFundedBy[${status.index}].protocolState"
                                attributeEntry="${protocolsFundedByAttributes.protocolState}"
                                readOnly="true"/>
                        </div></td>
                        <td align="left" valign="middle" class="infoline"><div align="center">
                            <kul:htmlControlAttribute property="protocolsFundedBy[${status.index}].reviewType"
                                attributeEntry="${protocolsFundedByAttributes.reviewType}"
                                readOnly="true"/>
                        </div></td>
                        <td align="left" valign="middle" class="infoline"><div align="center">
                            <kul:htmlControlAttribute property="protocolsFundedBy[${status.index}].approvalDate"
                                attributeEntry="${protocolsFundedByAttributes.approvalDate}"
                                readOnly="true"/>
                        </div></td>
                        <td align="left" valign="middle" class="infoline"><div align="center">
                            <kul:htmlControlAttribute property="protocolsFundedBy[${status.index}].expirationDate"
                                attributeEntry="${protocolsFundedByAttributes.expirationDate}"
                                readOnly="true"/>
                        </div></td>
                    </tr>
				</c:forEach>
          	</tbody>
         </table>
         </c:if>
        
        <c:if test="${KualiForm.protocolsLinkingEnabled and not empty KualiForm.protocolsFundedBy}">
        <h4 style="text-align:left; margin: 20px 0; padding: 2px;">Other Entries</h4>
        </c:if>
        <table id="specialReviewTableId" cellpadding="0" cellspacing="0" summary="">
          	<tr>
          		<th><div align="left">&nbsp;</div></th> 
          		<th><div align="center"><kul:htmlAttributeLabel attributeEntry="${attributes.specialReviewTypeCode}" noColon="true" /></div></th>
          		<th><div align="center"><kul:htmlAttributeLabel attributeEntry="${attributes.approvalTypeCode}" noColon="true" /></div></th>
				<th><div align="center"><kul:htmlAttributeLabel attributeEntry="${attributes.protocolNumber}" noColon="true" /><nobr></nobr></div></th>
          		<th><div align="center"><kul:htmlAttributeLabel attributeEntry="${attributes.applicationDate}" noColon="true" /></div></th>
          		<th><div align="center"><kul:htmlAttributeLabel attributeEntry="${attributes.approvalDate}" noColon="true" /></div></th>
          		<th><div align="center"><kul:htmlAttributeLabel attributeEntry="${attributes.expirationDate}" noColon="true" /></div></th>
          		<th><div align="center"><kul:htmlAttributeLabel attributeEntry="${exemptionAttributes.exemptionTypeCode}" noColon="true" /></div></th>
              	<c:if test="${canModify}"> 
              	    <kul:htmlAttributeHeaderCell literalLabel="Actions" scope="col"/>
          	    </c:if>
          	</tr>     

            <c:if test="${canModify}">
            	<tbody class="addline">
                <tr>
					<c:set var="protocolLinkingReadOnly" value="${(exconEnabled && KualiForm.specialReviewHelper.newSpecialReview.specialReviewTypeCode == exconProjectTypeCode)})}" />
					<c:choose>
						<c:when test="${exconEnabled && KualiForm.specialReviewHelper.newSpecialReview.specialReviewTypeCode == exconProjectTypeCode}">
							<c:set var="initialStyleExcon" value="display:inline"/>
						</c:when>
						<c:otherwise>
							<c:set var="initialStyleExcon" value="display:none"/>
						</c:otherwise>
					</c:choose>
	                <c:set var="textAreaFieldName" value="specialReviewHelper.newSpecialReview.comments" />
					<th class="infoline" rowspan="2">
						Add:
					</th>
	                <td align="left" valign="middle" class="infoline"><div align="center">
	                   <kul:htmlControlAttribute property="specialReviewHelper.newSpecialReview.specialReviewTypeCode" 
		                                         attributeEntry="${attributes.specialReviewTypeCode}"
		                                         styleClass="fixed-size-200-select"
												 onchange="SpecialReviewGlobals.showHideSpecialReviewProtocolLink(this, '${canCreateExconProject}'); return false" />
					</div></td>
	                <td class="infoline"><div align="center">
	                   <kul:htmlControlAttribute property="specialReviewHelper.newSpecialReview.approvalTypeCode" 
		                                                attributeEntry="${attributes.approvalTypeCode}"/>
                       <span>${KualiForm.specialReviewHelper.newSpecialReview.protocolStatus}</span>
	                </div></td>
	                <td class="infoline"><div align="center">
                        <kul:htmlControlAttribute property="specialReviewHelper.newSpecialReview.protocolNumber" 
		                                          attributeEntry="${attributes.protocolNumber}" />
						<span class="exconLookupLink" style="${initialStyleExcon}">
							<kul:lookup boClassName="org.kuali.kra.excon.project.ExconProject"
										fieldConversions="projectNumber:specialReviewHelper.newSpecialReview.protocolNumber" />
						</span>
					</div></td>
	                <td align="left" valign="middle" class="infoline"><div align="center">
                        <kra:dynamicHtmlControlAttribute property="specialReviewHelper.newSpecialReview.applicationDate" 
                                                         attributeEntry="${attributes.applicationDate}" 
                                                         initialReadOnly="${protocolLinkingReadOnly}"
                                                         staticOnly="false" />
	                </div></td>
                    <td align="left" valign="middle" class="infoline"><div align="center">
                        <kra:dynamicHtmlControlAttribute property="specialReviewHelper.newSpecialReview.approvalDate" 
                                                         attributeEntry="${attributes.approvalDate}" 
                                                         initialReadOnly="${protocolLinkingReadOnly}"
                                                         staticOnly="false" />
	                </div></td>
	                <td align="left" valign="middle" class="infoline"><div align="center">
	                	<kra:dynamicHtmlControlAttribute property="specialReviewHelper.newSpecialReview.expirationDate" 
	                	                                 attributeEntry="${attributes.expirationDate}" 
	                	                                 initialReadOnly="${protocolLinkingReadOnly}"
	                	                                 staticOnly="false" />
	                </div></td>
	                <td align="left" valign="middle" class="infoline"><div align="center">
                        <kra:dynamicHtmlControlAttribute property="specialReviewHelper.newSpecialReview.exemptionTypeCodes" 
                                                         attributeEntry="${exemptionAttributes.exemptionTypeCode}" 
                                                         initialReadOnly="${protocolLinkingReadOnly}"
														 styleClass="fixed-size-50-select"
                                                         staticOnly="false" />  			
	                </div></td>
					<td class="infoline" rowspan="1"><div align="center">
						<html:image property="methodToCall.addSpecialReview.anchor${tabKey}" 
						            src='${ConfigProperties.kra.externalizable.images.url}tinybutton-add1.gif' 
						            styleClass="tinybutton addButton"/>
						<c:if test="${canCreateExconProject}">
							<html:image property="methodToCall.createProtocol.anchor${tabKey}"
										src='${ConfigProperties.kra.externalizable.images.url}tinybutton-create.gif'
										title="Create Project"
										styleClass="tinybutton"/>
						</c:if>
	                </div></td>
	            </tr>
	            
	            <tr>
	            	<th><div align="right"><kul:htmlAttributeLabel attributeEntry="${attributes.comments}" noColon="false" labelFor="specialReviewHelper.newSpecialReview.comments"/></div></th>
	            	<td colspan="7">
	            		<kul:htmlControlAttribute property="specialReviewHelper.newSpecialReview.comments" 
	            		                          attributeEntry="${attributes.comments}" />
	            	</td>  
	            </tr>
	            </tbody>     
            </c:if>
            
        	<c:forEach var="specialReview" items="${collectionReference}" varStatus="status">
                <tr>
					<c:set var="protocolLinkingReadOnly" value="${specialReview.approvalTypeCode != '3' && (exconEnabled and specialReview.specialReviewTypeCode == exconProjectTypeCode)}" />
					<c:choose>
						<c:when test="${exconEnabled && specialReview.specialReviewTypeCode == exconProjectTypeCode}">
							<c:set var="initialStyleExcon" value="display:inline"/>
						</c:when>
						<c:otherwise>
							<c:set var="initialStyleExcon" value="display:none"/>
						</c:otherwise>
					</c:choose>
	                <c:set var="textAreaFieldName" value="${collectionProperty}[${status.index}].comments" />
					<th class="infoline" rowspan="2">
					   <c:out value="${status.index+1}" />
					</th>
                    <td align="left" valign="middle"><div align="center">
                        <kul:htmlControlAttribute property="${collectionProperty}[${status.index}].specialReviewTypeCode" 
	                                              attributeEntry="${attributes.specialReviewTypeCode}"  
	                                              readOnly="${not canModify}"
	                                              styleClass="fixed-size-200-select"
												  onchange="SpecialReviewGlobals.showHideSpecialReviewProtocolLink(this, '${canCreateExconProject}'); return false"
	                                              readOnlyAlternateDisplay="${specialReview.specialReviewType.description}" />
					</div></td>
                    <td><div align="center">
						<c:if test="${canModify}">
                        <kul:htmlControlAttribute property="${collectionProperty}[${status.index}].approvalTypeCode" 
	                                                     attributeEntry="${attributes.approvalTypeCode}" 
                                                         readOnly="${not canModify}"/>
						</c:if>
						<span>
							<c:choose>
								<c:when test="${protocolLinkingReadOnly}">
									${specialReview.protocolStatus}
								</c:when>
								<c:otherwise>
									${specialReview.approvalType.description}
								</c:otherwise>
							</c:choose>
						</span>
	                </div></td>
                    <td><div align="center">
                        <kul:htmlControlAttribute property="${collectionProperty}[${status.index}].protocolNumber" 
                                                  attributeEntry="${attributes.protocolNumber}" 
                                                  readOnly="${not canModify}" />
						<c:if test="${canModify}">
							<span class="exconLookupLink" style="${initialStyleExcon}">
								<kul:lookup boClassName="org.kuali.kra.excon.project.ExconProject"
											fieldConversions="projectNumber:${collectionProperty}[${status.index}].protocolNumber" />
							</span>
						</c:if>
					</div></td>
                    <td align="left" valign="middle"><div align="center">
                        <kra:dynamicHtmlControlAttribute property="${collectionProperty}[${status.index}].applicationDate" 
                                                         attributeEntry="${attributes.applicationDate}" 
                                                         initialReadOnly="${protocolLinkingReadOnly}"
                                                         readOnly="${not canModify}"
                                                         staticOnly="false" />
	                </div></td>
	                <td align="left" valign="middle"><div align="center">
                        <kra:dynamicHtmlControlAttribute property="${collectionProperty}[${status.index}].approvalDate" 
                                                         attributeEntry="${attributes.approvalDate}" 
                                                         initialReadOnly="${protocolLinkingReadOnly}"
                                                         readOnly="${not canModify}"
                                                         staticOnly="false" />
	                </div></td>
	                <td align="left" valign="middle"><div align="center">
                        <kra:dynamicHtmlControlAttribute property="${collectionProperty}[${status.index}].expirationDate" 
                                                         attributeEntry="${attributes.expirationDate}" 
                                                         initialReadOnly="${protocolLinkingReadOnly}"
                                                         readOnly="${not canModify}"
                                                         staticOnly="false"/>
	                </div></td>
	                <td align="left" valign="middle"><div align="center">
                        <kra:dynamicHtmlControlAttribute property="${collectionProperty}[${status.index}].exemptionTypeCodes" 
                                                         attributeEntry="${exemptionAttributes.exemptionTypeCode}" 
                                                         initialReadOnly="${protocolLinkingReadOnly}"
                                                         readOnly="${not canModify}"
														 styleClass="fixed-size-50-select"
                                                         staticOnly="false"/>
	                </div></td>
					<td rowspan="1"><div align=center>
                        <c:if test="${canModify}">
                            <html:image property="methodToCall.deleteSpecialReview.line${status.index}.anchor${currentTabIndex}.validate0"
									    src='${ConfigProperties.kra.externalizable.images.url}tinybutton-delete1.gif' styleClass="tinybutton"/>
                        </c:if>
						<c:if test="${protocolLinkingReadOnly and not empty collectionReference[status.index].protocolNumber}">
							<html:image property="methodToCall.viewSpecialReviewProtocolLink"
										src='${ConfigProperties.kra.externalizable.images.url}tinybutton-view.gif' alt="View Protocol" styleClass="tinybutton"
										onclick="javascript: specialReviewProtocolPop(${KualiForm.document.sessionDocument}, '${action}', 'viewSpecialReviewProtocolLink', ${status.index}, ${KualiForm.formKey});return false" />
						</c:if>
	                </div></td>
	            </tr>
	            <tr>
	            	<th><div align="right"><kul:htmlAttributeLabel attributeEntry="${attributes.comments}" noColon="false" labelFor="${collectionProperty}[${status.index}].comments"/></div></th>
	            	<td colspan="7">
		            	<nobr>
	                        <c:choose>
	                            <c:when test="${canModify}">
	                                <kul:htmlControlAttribute property="${collectionProperty}[${status.index}].comments" 
	                                                          attributeEntry="${attributes.comments}"/>
	                            </c:when>
	                            <c:otherwise>
			            		    <kra:truncateComment textAreaFieldName="${collectionProperty}[${status.index}].comments" action="${action}" 
		                                                 textAreaLabel="${attributes.comments.label}" textValue="${specialReview.comments}"  
		                                                 displaySize="${commentDisplayLength}"/>
	                            </c:otherwise>
	                        </c:choose>
	                    </nobr>
	            	</td> 
	            </tr>
        	</c:forEach>
        </table>
    </div>
</kul:tab>
