<#--
 #%L
 %%
 Copyright (C) 2005 - 2025 Kuali, Inc. - All Rights Reserved
 %%
 You may use and modify this code under the terms of the Kuali, Inc.
 Pre-Release License Agreement. You may not distribute it.
 
 You should have received a copy of the Kuali, Inc. Pre-Release License
 Agreement with this file. If not, please write to license@kuali.co.
 #L%
-->

<#macro uif_breadcrumbs widget page>

    <#local options=page.breadcrumbOptions/>

<ol ${krad.attrBuild(widget)} role="navigation">

<#-- process homewardPath breadcrumbs -->
    <#if options.renderHomewardPathBreadcrumbs && options.homewardPathBreadcrumbs?has_content>
    <#list options.homewardPathBreadcrumbs as crumb>
        <@krad.template component=crumb breadcrumbsWidget=widget/>
    </#list>
</#if>

    <#-- process parent locations (if set) -->
    <#if !widget.usePathBasedBreadcrumbs && KualiForm.view.parentLocation?has_content &&
KualiForm.view.parentLocation.resolvedBreadcrumbItems?has_content && options.renderParentLocations>
    <#list KualiForm.view.parentLocation.resolvedBreadcrumbItems as crumb>
        <@krad.template component=crumb breadcrumbsWidget=widget/>
    </#list>
</#if>

    <#-- process path based breadcrumbs (if set)-->
    <#if widget.usePathBasedBreadcrumbs && KualiForm.view.pathBasedBreadcrumbs?has_content>
    <#list KualiForm.view.pathBasedBreadcrumbs as crumb>
        <@krad.template component=crumb breadcrumbsWidget=widget/>
    </#list>
</#if>

    <#if options.breadcrumbOverrides?has_content>
<#-- process only the breadcrumb overrides (if set) -->
    <#list options.breadcrumbOverrides as crumb>
        <@krad.template component=crumb breadcrumbsWidget=widget/>
    </#list>
<#else>

<#-- preView Breadcrumbs -->
    <#if options.renderPreViewBreadcrumbs && options.preViewBreadcrumbs?has_content>
        <#list options.preViewBreadcrumbs as crumb>
            <@krad.template component=crumb breadcrumbsWidget=widget/>
        </#list>
    </#if>

<#-- View Breadcrumb -->
    <#if options.renderViewBreadcrumb && KualiForm.view.breadcrumbItem?has_content>
        <@krad.template component=KualiForm.view.breadcrumbItem breadcrumbsWidget=widget/>
    </#if>

<#-- prePage Breadcrumbs -->
    <#if options.renderPrePageBreadcrumbs && options.prePageBreadcrumbs?has_content>
        <#list options.prePageBreadcrumbs as crumb>
            <@krad.template component=crumb breadcrumbsWidget=widget/>
        </#list>
    </#if>

<#-- Page Breadcrumb -->
    <#if page.breadcrumbItem?has_content>
        <@krad.template component=page.breadcrumbItem breadcrumbsWidget=widget/>
    </#if>
</#if>

</ol>

    <@krad.script value="setupBreadcrumbs(${widget.displayBreadcrumbsWhenOne?string});" />

</#macro>



