<#--
 #%L
 %%
 Copyright (C) 2005 - 2025 Kuali, Inc. - All Rights Reserved
 %%
 You may use and modify this code under the terms of the Kuali, Inc.
 Pre-Release License Agreement. You may not distribute it.
 
 You should have received a copy of the Kuali, Inc. Pre-Release License
 Agreement with this file. If not, please write to license@kuali.co.
 #L%
-->

<#-- generate the standard HTML form element -->

<#macro form postUrl onSubmitScript disableNativeAutocomplete=false render=true onSubmitAttribute=''>

    <#if !postUrl?has_content>
        <#local render=false>
    </#if>

    <#if render>
      <#if disableNativeAutocomplete>
          <#local disableAutocompleteAttr='autocomplete="off"'/>
      </#if>

      <#if onSubmitScript?has_content>
          <#local onSubmitAttribute='onsubmit="${onSubmitScript}"'/>
      </#if>

      <form id="kualiForm" action="${postUrl}" method="post" accept-charset="UTF-8"
            ${onSubmitAttribute} ${disableAutocompleteAttr!}>

          <#nested/>

          <@krad.csrfToken/>

          <span id="formComplete"></span>
      </form>
    <#else>
        <#nested/>
    </#if>

</#macro>
